/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.resources;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URI;
import java.nio.file.Files;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ControllerMeter;
import org.apache.pinot.common.metrics.ControllerMetrics;
import org.apache.pinot.common.restlet.resources.StartReplaceSegmentsRequest;
import org.apache.pinot.common.utils.FileUploadDownloadClient;
import org.apache.pinot.common.utils.StringUtil;
import org.apache.pinot.common.utils.URIUtils;
import org.apache.pinot.common.utils.fetcher.SegmentFetcherFactory;
import org.apache.pinot.controller.ControllerConf;
import org.apache.pinot.controller.LeadControllerManager;
import org.apache.pinot.controller.api.access.AccessControl;
import org.apache.pinot.controller.api.access.AccessControlFactory;
import org.apache.pinot.controller.api.access.AccessType;
import org.apache.pinot.controller.api.access.Authenticate;
import org.apache.pinot.controller.api.exception.ControllerApplicationException;
import org.apache.pinot.controller.api.resources.ControllerFilePathProvider;
import org.apache.pinot.controller.api.resources.SuccessResponse;
import org.apache.pinot.controller.api.upload.SegmentValidator;
import org.apache.pinot.controller.api.upload.ZKOperator;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.core.metadata.DefaultMetadataExtractor;
import org.apache.pinot.core.metadata.MetadataExtractorFactory;
import org.apache.pinot.segment.spi.SegmentMetadata;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.crypt.PinotCrypter;
import org.apache.pinot.spi.crypt.PinotCrypterFactory;
import org.apache.pinot.spi.filesystem.PinotFS;
import org.apache.pinot.spi.filesystem.PinotFSFactory;
import org.apache.pinot.spi.utils.JsonUtils;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.server.ManagedAsync;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"Segment"})
@Path(value="/")
public class PinotSegmentUploadDownloadRestletResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(PinotSegmentUploadDownloadRestletResource.class);
    private static final String TMP_DIR_PREFIX = "tmp-";
    private static final String ENCRYPTED_SUFFIX = "_encrypted";
    @Inject
    PinotHelixResourceManager _pinotHelixResourceManager;
    @Inject
    ControllerConf _controllerConf;
    @Inject
    ControllerMetrics _controllerMetrics;
    @Inject
    HttpConnectionManager _connectionManager;
    @Inject
    Executor _executor;
    @Inject
    AccessControlFactory _accessControlFactory;
    @Inject
    LeadControllerManager _leadControllerManager;

    @GET
    @Produces(value={"application/octet-stream"})
    @Path(value="/segments/{tableName}/{segmentName}")
    @ApiOperation(value="Download a segment", notes="Download a segment")
    public Response downloadSegment(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="Name of the segment", required=true) @PathParam(value="segmentName") @Encoded String segmentName, @Context HttpHeaders httpHeaders) throws Exception {
        File segmentFile;
        boolean hasDataAccess;
        try {
            AccessControl accessControl = this._accessControlFactory.create();
            hasDataAccess = accessControl.hasDataAccess(httpHeaders, tableName);
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, "Caught exception while validating access to table: " + tableName, Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
        if (!hasDataAccess) {
            throw new ControllerApplicationException(LOGGER, "No data access to table: " + tableName, Response.Status.FORBIDDEN);
        }
        segmentName = URIUtils.decode((String)segmentName);
        URI dataDirURI = ControllerFilePathProvider.getInstance().getDataDirURI();
        Response.ResponseBuilder builder = Response.ok();
        if ("file".equals(dataDirURI.getScheme())) {
            segmentFile = new File(new File(dataDirURI), StringUtil.join((String)File.separator, (String[])new String[]{tableName, segmentName}));
            if (!segmentFile.exists()) {
                throw new ControllerApplicationException(LOGGER, "Segment " + segmentName + " or table " + tableName + " not found in " + segmentFile.getAbsolutePath(), Response.Status.NOT_FOUND);
            }
            builder.entity((Object)segmentFile);
        } else {
            URI remoteSegmentFileURI = URIUtils.getUri((String)dataDirURI.toString(), (String[])new String[]{tableName, URIUtils.encode((String)segmentName)});
            PinotFS pinotFS = PinotFSFactory.create((String)dataDirURI.getScheme());
            if (!pinotFS.exists(remoteSegmentFileURI)) {
                throw new ControllerApplicationException(LOGGER, "Segment: " + segmentName + " of table: " + tableName + " not found at: " + remoteSegmentFileURI, Response.Status.NOT_FOUND);
            }
            segmentFile = new File(new File(ControllerFilePathProvider.getInstance().getFileDownloadTempDir(), tableName), segmentName + "-" + UUID.randomUUID());
            pinotFS.copyToLocalFile(remoteSegmentFileURI, segmentFile);
            builder.entity(output -> {
                try {
                    Files.copy(segmentFile.toPath(), output);
                }
                finally {
                    FileUtils.deleteQuietly((File)segmentFile);
                }
            });
        }
        builder.header("Content-Disposition", (Object)("attachment; filename=" + segmentFile.getName()));
        builder.header("Content-Length", (Object)segmentFile.length());
        return builder.build();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SuccessResponse uploadSegment(@Nullable String tableName, TableType tableType, FormDataMultiPart multiPart, boolean enableParallelPushProtection, HttpHeaders headers, Request request, boolean moveSegmentToFinalLocation) {
        SuccessResponse successResponse;
        String uploadTypeStr = null;
        String crypterClassNameInHeader = null;
        String downloadUri = null;
        String ingestionDescriptor = null;
        if (headers != null) {
            this.extractHttpHeader(headers, "Pinot-Segment-Name");
            this.extractHttpHeader(headers, "Pinot-Table-Name");
            ingestionDescriptor = this.extractHttpHeader(headers, "Pinot-Ingestion-Descriptor");
            uploadTypeStr = this.extractHttpHeader(headers, "UPLOAD_TYPE");
            crypterClassNameInHeader = this.extractHttpHeader(headers, "CRYPTER");
            downloadUri = this.extractHttpHeader(headers, "DOWNLOAD_URI");
        }
        File tempEncryptedFile = null;
        File tempDecryptedFile = null;
        File tempSegmentDir = null;
        try {
            String zkDownloadUri;
            String tableNameWithType;
            String rawTableName;
            ControllerFilePathProvider provider = ControllerFilePathProvider.getInstance();
            String tempFileName = TMP_DIR_PREFIX + UUID.randomUUID();
            tempDecryptedFile = new File(provider.getFileUploadTempDir(), tempFileName);
            tempEncryptedFile = new File(provider.getFileUploadTempDir(), tempFileName + ENCRYPTED_SUFFIX);
            tempSegmentDir = new File(provider.getUntarredFileTempDir(), tempFileName);
            boolean uploadedSegmentIsEncrypted = !Strings.isNullOrEmpty((String)crypterClassNameInHeader);
            FileUploadDownloadClient.FileUploadType uploadType = this.getUploadType(uploadTypeStr);
            File dstFile = uploadedSegmentIsEncrypted ? tempEncryptedFile : tempDecryptedFile;
            switch (uploadType) {
                case URI: {
                    this.downloadSegmentFileFromURI(downloadUri, dstFile, tableName);
                    break;
                }
                case SEGMENT: {
                    this.createSegmentFileFromMultipart(multiPart, dstFile);
                    break;
                }
                case METADATA: {
                    moveSegmentToFinalLocation = false;
                    Preconditions.checkState((downloadUri != null ? 1 : 0) != 0, (Object)"Download URI is required in segment metadata upload mode");
                    this.createSegmentFileFromMultipart(multiPart, dstFile);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported upload type: " + uploadType);
                }
            }
            if (uploadedSegmentIsEncrypted) {
                this.decryptFile(crypterClassNameInHeader, tempEncryptedFile, tempDecryptedFile);
            }
            String metadataProviderClass = DefaultMetadataExtractor.class.getName();
            SegmentMetadata segmentMetadata = this.getSegmentMetadata(tempDecryptedFile, tempSegmentDir, metadataProviderClass);
            String segmentName = segmentMetadata.getName();
            if (tableName != null && !tableName.isEmpty()) {
                rawTableName = TableNameBuilder.extractRawTableName((String)tableName);
                LOGGER.info("Uploading a segment {} to table: {}, push type {}, (Derived from API parameter)", new Object[]{segmentName, tableName, uploadType});
            } else {
                rawTableName = segmentMetadata.getTableName();
                LOGGER.info("Uploading a segment {} to table: {}, push type {}, (Derived from segment metadata)", new Object[]{segmentName, tableName, uploadType});
            }
            if (tableType == TableType.OFFLINE) {
                tableNameWithType = TableNameBuilder.OFFLINE.tableNameWithType(rawTableName);
            } else {
                if (!this._pinotHelixResourceManager.isUpsertTable(rawTableName)) {
                    throw new UnsupportedOperationException("Upload segment to non-upsert realtime table is not supported " + rawTableName);
                }
                tableNameWithType = TableNameBuilder.REALTIME.tableNameWithType(rawTableName);
            }
            String clientAddress = InetAddress.getByName(request.getRemoteAddr()).getHostName();
            LOGGER.info("Processing upload request for segment: {} of table: {} from client: {}, ingestion descriptor: {}", new Object[]{segmentName, tableNameWithType, clientAddress, ingestionDescriptor});
            if (tableType == TableType.OFFLINE && uploadType != FileUploadDownloadClient.FileUploadType.METADATA) {
                new SegmentValidator(this._pinotHelixResourceManager, this._controllerConf, this._executor, this._connectionManager, this._controllerMetrics, this._leadControllerManager.isLeaderForTable(tableNameWithType)).validateOfflineSegment(tableNameWithType, segmentMetadata, tempSegmentDir);
            }
            String crypterClassNameInTableConfig = this._pinotHelixResourceManager.getCrypterClassNameFromTableConfig(tableNameWithType);
            Pair<String, File> encryptionInfo = this.encryptSegmentIfNeeded(tempDecryptedFile, tempEncryptedFile, uploadedSegmentIsEncrypted, crypterClassNameInHeader, crypterClassNameInTableConfig, segmentName, tableNameWithType);
            String crypterClassName = (String)encryptionInfo.getLeft();
            File finalSegmentFile = (File)encryptionInfo.getRight();
            if (!moveSegmentToFinalLocation) {
                LOGGER.info("Setting zkDownloadUri: to {} for segment: {} of table: {}, skipping move", new Object[]{downloadUri, segmentName, tableNameWithType});
                zkDownloadUri = downloadUri;
            } else {
                zkDownloadUri = this.getZkDownloadURIForSegmentUpload(rawTableName, segmentName);
            }
            this.completeZkOperations(enableParallelPushProtection, headers, finalSegmentFile, tableNameWithType, segmentMetadata, segmentName, zkDownloadUri, moveSegmentToFinalLocation, crypterClassName);
            successResponse = new SuccessResponse("Successfully uploaded segment: " + segmentName + " of table: " + tableNameWithType);
        }
        catch (WebApplicationException e) {
            try {
                throw e;
                catch (Exception e2) {
                    this._controllerMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ControllerMeter.CONTROLLER_SEGMENT_UPLOAD_ERROR, 1L);
                    throw new ControllerApplicationException(LOGGER, "Caught internal server exception while uploading segment", Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                FileUtils.deleteQuietly(tempEncryptedFile);
                FileUtils.deleteQuietly(tempDecryptedFile);
                FileUtils.deleteQuietly(tempSegmentDir);
                throw throwable;
            }
        }
        FileUtils.deleteQuietly((File)tempEncryptedFile);
        FileUtils.deleteQuietly((File)tempDecryptedFile);
        FileUtils.deleteQuietly((File)tempSegmentDir);
        return successResponse;
    }

    @Nullable
    private String extractHttpHeader(HttpHeaders headers, String name) {
        String value = headers.getHeaderString(name);
        if (value != null) {
            LOGGER.info("HTTP Header: {} is: {}", (Object)name, (Object)value);
        }
        return value;
    }

    Pair<String, File> encryptSegmentIfNeeded(File tempDecryptedFile, File tempEncryptedFile, boolean isUploadedSegmentEncrypted, String crypterUsedInUploadedSegment, String crypterClassNameInTableConfig, String segmentName, String tableNameWithType) {
        boolean segmentNeedsEncryption = !Strings.isNullOrEmpty((String)crypterClassNameInTableConfig);
        File finalSegmentFile = isUploadedSegmentEncrypted || segmentNeedsEncryption ? tempEncryptedFile : tempDecryptedFile;
        String crypterClassName = Strings.isNullOrEmpty((String)crypterClassNameInTableConfig) ? crypterUsedInUploadedSegment : crypterClassNameInTableConfig;
        ImmutablePair out = ImmutablePair.of((Object)crypterClassName, (Object)finalSegmentFile);
        if (!segmentNeedsEncryption) {
            return out;
        }
        if (isUploadedSegmentEncrypted && !crypterClassNameInTableConfig.equals(crypterUsedInUploadedSegment)) {
            throw new ControllerApplicationException(LOGGER, String.format("Uploaded segment is encrypted with '%s' while table config requires '%s' as crypter (segment name = '%s', table name = '%s').", crypterUsedInUploadedSegment, crypterClassNameInTableConfig, segmentName, tableNameWithType), Response.Status.INTERNAL_SERVER_ERROR);
        }
        PinotCrypter pinotCrypter = PinotCrypterFactory.create((String)crypterClassNameInTableConfig);
        LOGGER.info("Using crypter class '{}' for encrypting '{}' to '{}' (segment name = '{}', table name = '{}').", new Object[]{crypterClassNameInTableConfig, tempDecryptedFile, tempEncryptedFile, segmentName, tableNameWithType});
        pinotCrypter.encrypt(tempDecryptedFile, tempEncryptedFile);
        return out;
    }

    private String getZkDownloadURIForSegmentUpload(String rawTableName, String segmentName) {
        ControllerFilePathProvider provider = ControllerFilePathProvider.getInstance();
        URI dataDirURI = provider.getDataDirURI();
        if (dataDirURI.getScheme().equalsIgnoreCase("file")) {
            return URIUtils.constructDownloadUrl((String)provider.getVip(), (String)rawTableName, (String)segmentName);
        }
        String downloadUri = URIUtils.getPath((String)dataDirURI.toString(), (String[])new String[]{rawTableName, URIUtils.encode((String)segmentName)});
        LOGGER.info("Using download uri: {} for segment: {} of table {}", new Object[]{downloadUri, segmentName, rawTableName});
        return downloadUri;
    }

    private void downloadSegmentFileFromURI(String currentSegmentLocationURI, File destFile, String tableName) throws Exception {
        if (currentSegmentLocationURI == null || currentSegmentLocationURI.isEmpty()) {
            throw new ControllerApplicationException(LOGGER, "Failed to get downloadURI, needed for URI upload", Response.Status.BAD_REQUEST);
        }
        LOGGER.info("Downloading segment from {} to {} for table {}", new Object[]{currentSegmentLocationURI, destFile.getAbsolutePath(), tableName});
        SegmentFetcherFactory.fetchSegmentToLocal((String)currentSegmentLocationURI, (File)destFile);
    }

    private SegmentMetadata getSegmentMetadata(File tempDecryptedFile, File tempSegmentDir, String metadataProviderClass) throws Exception {
        return MetadataExtractorFactory.create((String)metadataProviderClass).extractMetadata(tempDecryptedFile, tempSegmentDir);
    }

    private void completeZkOperations(boolean enableParallelPushProtection, HttpHeaders headers, File uploadedSegmentFile, String tableNameWithType, SegmentMetadata segmentMetadata, String segmentName, String zkDownloadURI, boolean moveSegmentToFinalLocation, String crypter) throws Exception {
        String basePath = ControllerFilePathProvider.getInstance().getDataDirURI().toString();
        String rawTableName = TableNameBuilder.extractRawTableName((String)tableNameWithType);
        URI finalSegmentLocationURI = URIUtils.getUri((String)basePath, (String[])new String[]{rawTableName, URIUtils.encode((String)segmentName)});
        ZKOperator zkOperator = new ZKOperator(this._pinotHelixResourceManager, this._controllerConf, this._controllerMetrics);
        zkOperator.completeSegmentOperations(tableNameWithType, segmentMetadata, finalSegmentLocationURI, uploadedSegmentFile, enableParallelPushProtection, headers, zkDownloadURI, moveSegmentToFinalLocation, crypter);
    }

    private void decryptFile(String crypterClassName, File tempEncryptedFile, File tempDecryptedFile) {
        PinotCrypter pinotCrypter = PinotCrypterFactory.create((String)crypterClassName);
        LOGGER.info("Using crypter class {} for decrypting {} to {}", new Object[]{pinotCrypter.getClass().getName(), tempEncryptedFile, tempDecryptedFile});
        pinotCrypter.decrypt(tempEncryptedFile, tempDecryptedFile);
    }

    @POST
    @ManagedAsync
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/segments")
    @Authenticate(value=AccessType.CREATE)
    @ApiOperation(value="Upload a segment", notes="Upload a segment as json")
    public void uploadSegmentAsJson(String segmentJsonStr, @ApiParam(value="Name of the table") @QueryParam(value="tableName") String tableName, @ApiParam(value="Type of the table") @QueryParam(value="tableType") @DefaultValue(value="OFFLINE") String tableType, @ApiParam(value="Whether to enable parallel push protection") @DefaultValue(value="false") @QueryParam(value="enableParallelPushProtection") boolean enableParallelPushProtection, @Context HttpHeaders headers, @Context Request request, @Suspended AsyncResponse asyncResponse) {
        try {
            asyncResponse.resume((Object)this.uploadSegment(tableName, TableType.valueOf((String)tableType.toUpperCase()), null, enableParallelPushProtection, headers, request, false));
        }
        catch (Throwable t) {
            asyncResponse.resume(t);
        }
    }

    @POST
    @ManagedAsync
    @Produces(value={"application/json"})
    @Consumes(value={"multipart/form-data"})
    @Path(value="/segments")
    @Authenticate(value=AccessType.CREATE)
    @ApiOperation(value="Upload a segment", notes="Upload a segment as binary")
    public void uploadSegmentAsMultiPart(FormDataMultiPart multiPart, @ApiParam(value="Name of the table") @QueryParam(value="tableName") String tableName, @ApiParam(value="Type of the table") @QueryParam(value="tableType") @DefaultValue(value="OFFLINE") String tableType, @ApiParam(value="Whether to enable parallel push protection") @DefaultValue(value="false") @QueryParam(value="enableParallelPushProtection") boolean enableParallelPushProtection, @Context HttpHeaders headers, @Context Request request, @Suspended AsyncResponse asyncResponse) {
        try {
            asyncResponse.resume((Object)this.uploadSegment(tableName, TableType.valueOf((String)tableType.toUpperCase()), multiPart, enableParallelPushProtection, headers, request, true));
        }
        catch (Throwable t) {
            asyncResponse.resume(t);
        }
    }

    @POST
    @ManagedAsync
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/v2/segments")
    @Authenticate(value=AccessType.CREATE)
    @ApiOperation(value="Upload a segment", notes="Upload a segment as json")
    public void uploadSegmentAsJsonV2(String segmentJsonStr, @ApiParam(value="Name of the table") @QueryParam(value="tableName") String tableName, @ApiParam(value="Type of the table") @QueryParam(value="tableType") @DefaultValue(value="OFFLINE") String tableType, @ApiParam(value="Whether to enable parallel push protection") @DefaultValue(value="false") @QueryParam(value="enableParallelPushProtection") boolean enableParallelPushProtection, @Context HttpHeaders headers, @Context Request request, @Suspended AsyncResponse asyncResponse) {
        try {
            asyncResponse.resume((Object)this.uploadSegment(tableName, TableType.valueOf((String)tableType.toUpperCase()), null, enableParallelPushProtection, headers, request, true));
        }
        catch (Throwable t) {
            asyncResponse.resume(t);
        }
    }

    @POST
    @ManagedAsync
    @Produces(value={"application/json"})
    @Consumes(value={"multipart/form-data"})
    @Path(value="/v2/segments")
    @Authenticate(value=AccessType.CREATE)
    @ApiOperation(value="Upload a segment", notes="Upload a segment as binary")
    public void uploadSegmentAsMultiPartV2(FormDataMultiPart multiPart, @ApiParam(value="Name of the table") @QueryParam(value="tableName") String tableName, @ApiParam(value="Type of the table") @QueryParam(value="tableType") @DefaultValue(value="OFFLINE") String tableType, @ApiParam(value="Whether to enable parallel push protection") @DefaultValue(value="false") @QueryParam(value="enableParallelPushProtection") boolean enableParallelPushProtection, @Context HttpHeaders headers, @Context Request request, @Suspended AsyncResponse asyncResponse) {
        try {
            asyncResponse.resume((Object)this.uploadSegment(tableName, TableType.valueOf((String)tableType.toUpperCase()), multiPart, enableParallelPushProtection, headers, request, true));
        }
        catch (Throwable t) {
            asyncResponse.resume(t);
        }
    }

    @POST
    @Path(value="segments/{tableName}/startReplaceSegments")
    @Authenticate(value=AccessType.UPDATE)
    @Produces(value={"application/json"})
    @ApiOperation(value="Start to replace segments", notes="Start to replace segments")
    public Response startReplaceSegments(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="OFFLINE|REALTIME") @QueryParam(value="type") String tableTypeStr, StartReplaceSegmentsRequest startReplaceSegmentsRequest) {
        try {
            String tableNameWithType = TableNameBuilder.forType((TableType)TableType.valueOf((String)tableTypeStr.toUpperCase())).tableNameWithType(tableName);
            String segmentLineageEntryId = this._pinotHelixResourceManager.startReplaceSegments(tableNameWithType, startReplaceSegmentsRequest.getSegmentsFrom(), startReplaceSegmentsRequest.getSegmentsTo());
            return Response.ok((Object)JsonUtils.newObjectNode().put("segmentLineageEntryId", segmentLineageEntryId)).build();
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    @POST
    @Path(value="segments/{tableName}/endReplaceSegments")
    @Authenticate(value=AccessType.UPDATE)
    @Produces(value={"application/json"})
    @ApiOperation(value="End to replace segments", notes="End to replace segments")
    public Response endReplaceSegments(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="OFFLINE|REALTIME") @QueryParam(value="type") String tableTypeStr, @ApiParam(value="Segment lineage entry id returned by startReplaceSegments API") @QueryParam(value="segmentLineageEntryId") String segmentLineageEntryId) {
        try {
            String tableNameWithType = TableNameBuilder.forType((TableType)TableType.valueOf((String)tableTypeStr.toUpperCase())).tableNameWithType(tableName);
            Preconditions.checkNotNull((Object)segmentLineageEntryId, (Object)"'segmentLineageEntryId' should not be null");
            this._pinotHelixResourceManager.endReplaceSegments(tableNameWithType, segmentLineageEntryId);
            return Response.ok().build();
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createSegmentFileFromMultipart(FormDataMultiPart multiPart, File dstFile) throws IOException {
        Map segmentMetadataMap = multiPart.getFields();
        if (!PinotSegmentUploadDownloadRestletResource.validateMultiPart(segmentMetadataMap, null)) {
            throw new ControllerApplicationException(LOGGER, "Invalid multi-part form for segment metadata", Response.Status.BAD_REQUEST);
        }
        FormDataBodyPart segmentMetadataBodyPart = (FormDataBodyPart)((List)segmentMetadataMap.values().iterator().next()).get(0);
        try (InputStream inputStream = (InputStream)segmentMetadataBodyPart.getValueAs(InputStream.class);
             FileOutputStream outputStream = new FileOutputStream(dstFile);){
            IOUtils.copyLarge((InputStream)inputStream, (OutputStream)outputStream);
        }
        finally {
            multiPart.cleanup();
        }
        return dstFile;
    }

    private FileUploadDownloadClient.FileUploadType getUploadType(String uploadTypeStr) {
        if (uploadTypeStr != null) {
            return FileUploadDownloadClient.FileUploadType.valueOf((String)uploadTypeStr);
        }
        return FileUploadDownloadClient.FileUploadType.getDefaultUploadType();
    }

    public static boolean validateMultiPart(Map<String, List<FormDataBodyPart>> map, String segmentName) {
        List<FormDataBodyPart> bodyParts;
        boolean isGood = true;
        if (map.size() != 1) {
            LOGGER.warn("Incorrect number of multi-part elements: {} (segmentName {}). Picking one", (Object)map.size(), (Object)segmentName);
            isGood = false;
        }
        if ((bodyParts = map.values().iterator().next()).size() != 1) {
            LOGGER.warn("Incorrect number of elements in list in first part: {} (segmentName {}). Picking first one", (Object)bodyParts.size(), (Object)segmentName);
            isGood = false;
        }
        return isGood;
    }
}

