/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.resources;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import it.unimi.dsi.fastutil.Arrays;
import it.unimi.dsi.fastutil.Swapper;
import it.unimi.dsi.fastutil.ints.IntComparator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.helix.AccessOption;
import org.apache.helix.ZNRecord;
import org.apache.helix.store.zk.ZkHelixPropertyStore;
import org.apache.pinot.common.exception.InvalidConfigException;
import org.apache.pinot.common.exception.SchemaNotFoundException;
import org.apache.pinot.common.exception.TableNotFoundException;
import org.apache.pinot.common.metadata.ZKMetadataProvider;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ControllerMeter;
import org.apache.pinot.common.metrics.ControllerMetrics;
import org.apache.pinot.controller.ControllerConf;
import org.apache.pinot.controller.api.access.AccessControlFactory;
import org.apache.pinot.controller.api.access.AccessControlUtils;
import org.apache.pinot.controller.api.access.AccessType;
import org.apache.pinot.controller.api.access.Authenticate;
import org.apache.pinot.controller.api.exception.ControllerApplicationException;
import org.apache.pinot.controller.api.exception.InvalidTableConfigException;
import org.apache.pinot.controller.api.exception.TableAlreadyExistsException;
import org.apache.pinot.controller.api.resources.Constants;
import org.apache.pinot.controller.api.resources.ResourceUtils;
import org.apache.pinot.controller.api.resources.StateType;
import org.apache.pinot.controller.api.resources.SuccessResponse;
import org.apache.pinot.controller.api.resources.TableAndSchemaConfig;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.controller.helix.core.minion.PinotHelixTaskResourceManager;
import org.apache.pinot.controller.helix.core.rebalance.RebalanceResult;
import org.apache.pinot.controller.recommender.RecommenderDriver;
import org.apache.pinot.controller.tuner.TableConfigTunerUtils;
import org.apache.pinot.controller.util.TableIngestionStatusHelper;
import org.apache.pinot.controller.util.TableMetadataReader;
import org.apache.pinot.segment.local.utils.TableConfigUtils;
import org.apache.pinot.spi.config.table.SegmentsValidationAndRetentionConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.TableStats;
import org.apache.pinot.spi.config.table.TableStatus;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.utils.JsonUtils;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.apache.zookeeper.data.Stat;
import org.glassfish.grizzly.http.server.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"Table"})
@Path(value="/")
public class PinotTableRestletResource {
    public static Logger LOGGER = LoggerFactory.getLogger(PinotTableRestletResource.class);
    @Inject
    PinotHelixResourceManager _pinotHelixResourceManager;
    @Inject
    PinotHelixTaskResourceManager _pinotHelixTaskResourceManager;
    @Inject
    ControllerConf _controllerConf;
    @Inject
    ControllerMetrics _controllerMetrics;
    @Inject
    ExecutorService _executorService;
    @Inject
    AccessControlFactory _accessControlFactory;
    AccessControlUtils _accessControlUtils = new AccessControlUtils();
    @Inject
    Executor _executor;
    @Inject
    HttpConnectionManager _connectionManager;

    @POST
    @Produces(value={"application/json"})
    @Path(value="/tables")
    @ApiOperation(value="Adds a table", notes="Adds a table")
    public SuccessResponse addTable(String tableConfigStr, @Context HttpHeaders httpHeaders, @Context Request request) {
        String tableName;
        TableConfig tableConfig;
        try {
            tableConfig = (TableConfig)JsonUtils.stringToObject((String)tableConfigStr, TableConfig.class);
            tableName = tableConfig.getTableName();
            String endpointUrl = request.getRequestURL().toString();
            this._accessControlUtils.validatePermission(tableName, AccessType.CREATE, httpHeaders, endpointUrl, this._accessControlFactory.create());
            Schema schema = this._pinotHelixResourceManager.getSchemaForTableConfig(tableConfig);
            TableConfigTunerUtils.applyTunerConfig(this._pinotHelixResourceManager, tableConfig, schema);
            TableConfigUtils.validate((TableConfig)tableConfig, (Schema)schema);
            TableConfigUtils.validateTableName((TableConfig)tableConfig);
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.BAD_REQUEST, (Throwable)e);
        }
        try {
            try {
                TableConfigUtils.ensureMinReplicas((TableConfig)tableConfig, (int)this._controllerConf.getDefaultTableMinReplicas());
                TableConfigUtils.ensureStorageQuotaConstraints((TableConfig)tableConfig, (String)this._controllerConf.getDimTableMaxSize());
                this.checkHybridTableConfig(TableNameBuilder.extractRawTableName((String)tableName), tableConfig);
            }
            catch (Exception e) {
                throw new InvalidTableConfigException(e);
            }
            this._pinotHelixResourceManager.addTable(tableConfig);
            return new SuccessResponse("Table " + tableName + " succesfully added");
        }
        catch (Exception e) {
            this._controllerMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ControllerMeter.CONTROLLER_TABLE_ADD_ERROR, 1L);
            if (e instanceof InvalidTableConfigException) {
                String errStr = String.format("Invalid table config for table %s: %s", tableName, e.getMessage());
                throw new ControllerApplicationException(LOGGER, errStr, Response.Status.BAD_REQUEST, (Throwable)e);
            }
            if (e instanceof TableAlreadyExistsException) {
                throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.CONFLICT, (Throwable)e);
            }
            throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/tables/recommender")
    @ApiOperation(value="Recommend config", notes="Recommend a config with input json")
    public String recommendConfig(String inputStr) {
        try {
            return RecommenderDriver.run(inputStr);
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.BAD_REQUEST, (Throwable)e);
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/tables")
    @ApiOperation(value="Lists all tables in cluster", notes="Lists all tables in cluster")
    public String listTables(@ApiParam(value="realtime|offline") @QueryParam(value="type") String tableTypeStr, @ApiParam(value="name|creationTime|lastModifiedTime") @QueryParam(value="sortType") String sortTypeStr, @ApiParam(value="true|false") @QueryParam(value="sortAsc") @DefaultValue(value="true") boolean sortAsc) {
        try {
            SortType sortType;
            TableType tableType = null;
            if (tableTypeStr != null) {
                tableType = TableType.valueOf((String)tableTypeStr.toUpperCase());
            }
            SortType sortType2 = sortType = sortTypeStr != null ? SortType.valueOf(sortTypeStr.toUpperCase()) : SortType.NAME;
            List<String> tableNames = tableType == null ? (sortType == SortType.NAME ? this._pinotHelixResourceManager.getAllRawTables() : this._pinotHelixResourceManager.getAllTables()) : (tableType == TableType.REALTIME ? this._pinotHelixResourceManager.getAllRealtimeTables() : this._pinotHelixResourceManager.getAllOfflineTables());
            if (sortType == SortType.NAME) {
                tableNames.sort(sortAsc ? null : Comparator.reverseOrder());
            } else {
                IntComparator comparator;
                int sortFactor = sortAsc ? 1 : -1;
                ZkHelixPropertyStore<ZNRecord> propertyStore = this._pinotHelixResourceManager.getPropertyStore();
                int numTables = tableNames.size();
                ArrayList<String> zkPaths = new ArrayList<String>(numTables);
                for (String tableNameWithType : tableNames) {
                    zkPaths.add(ZKMetadataProvider.constructPropertyStorePathForResourceConfig((String)tableNameWithType));
                }
                Stat[] stats = propertyStore.getStats(zkPaths, AccessOption.PERSISTENT);
                for (int i2 = 0; i2 < numTables; ++i2) {
                    Preconditions.checkState((stats[i2] != null ? 1 : 0) != 0, (String)"Failed to read ZK stats for table: %s", (Object)tableNames.get(i2));
                }
                if (sortType == SortType.CREATIONTIME) {
                    comparator = (i, j) -> Long.compare(stats[i].getCtime(), stats[j].getCtime()) * sortFactor;
                } else {
                    assert (sortType == SortType.LASTMODIFIEDTIME);
                    comparator = (i, j) -> Long.compare(stats[i].getMtime(), stats[j].getMtime()) * sortFactor;
                }
                Swapper swapper = (i, j) -> {
                    Stat tempStat = stats[i];
                    stats[i] = stats[j];
                    stats[j] = tempStat;
                    String tempTableName = (String)tableNames.get(i);
                    tableNames.set(i, (String)tableNames.get(j));
                    tableNames.set(j, tempTableName);
                };
                Arrays.quickSort((int)0, (int)numTables, (IntComparator)comparator, (Swapper)swapper);
            }
            return JsonUtils.newObjectNode().set("tables", JsonUtils.objectToJsonNode(tableNames)).toString();
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    private String listTableConfigs(String tableName, @Nullable String tableTypeStr) {
        try {
            TableConfig tableConfig;
            ObjectNode ret = JsonUtils.newObjectNode();
            if ((tableTypeStr == null || TableType.OFFLINE.name().equalsIgnoreCase(tableTypeStr)) && this._pinotHelixResourceManager.hasOfflineTable(tableName)) {
                tableConfig = this._pinotHelixResourceManager.getOfflineTableConfig(tableName);
                Preconditions.checkNotNull((Object)tableConfig);
                ret.set(TableType.OFFLINE.name(), tableConfig.toJsonNode());
            }
            if ((tableTypeStr == null || TableType.REALTIME.name().equalsIgnoreCase(tableTypeStr)) && this._pinotHelixResourceManager.hasRealtimeTable(tableName)) {
                tableConfig = this._pinotHelixResourceManager.getRealtimeTableConfig(tableName);
                Preconditions.checkNotNull((Object)tableConfig);
                ret.set(TableType.REALTIME.name(), tableConfig.toJsonNode());
            }
            return ret.toString();
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/tables/{tableName}")
    @ApiOperation(value="Get/Enable/Disable/Drop a table", notes="Get/Enable/Disable/Drop a table. If table name is the only parameter specified , the tableconfig will be printed")
    public String alterTableStateOrListTableConfig(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="enable|disable|drop") @QueryParam(value="state") String stateStr, @ApiParam(value="realtime|offline") @QueryParam(value="type") String tableTypeStr, @Context HttpHeaders httpHeaders, @Context Request request) {
        try {
            if (stateStr == null) {
                return this.listTableConfigs(tableName, tableTypeStr);
            }
            StateType stateType = Constants.validateState(stateStr);
            TableType tableType = Constants.validateTableType(tableTypeStr);
            String endpointUrl = request.getRequestURL().toString();
            this._accessControlUtils.validatePermission(tableName, AccessType.UPDATE, httpHeaders, endpointUrl, this._accessControlFactory.create());
            ArrayNode ret = JsonUtils.newArrayNode();
            boolean tableExists = false;
            if (tableType != TableType.REALTIME && this._pinotHelixResourceManager.hasOfflineTable(tableName)) {
                String offlineTableName = TableNameBuilder.OFFLINE.tableNameWithType(tableName);
                ObjectNode offline = JsonUtils.newObjectNode();
                tableExists = true;
                offline.put("tableName", offlineTableName);
                offline.set("state", JsonUtils.objectToJsonNode((Object)this._pinotHelixResourceManager.toggleTableState(offlineTableName, stateType)));
                ret.add((JsonNode)offline);
            }
            if (tableType != TableType.OFFLINE && this._pinotHelixResourceManager.hasRealtimeTable(tableName)) {
                String realtimeTableName = TableNameBuilder.REALTIME.tableNameWithType(tableName);
                ObjectNode realtime = JsonUtils.newObjectNode();
                tableExists = true;
                realtime.put("tableName", realtimeTableName);
                realtime.set("state", JsonUtils.objectToJsonNode((Object)this._pinotHelixResourceManager.toggleTableState(realtimeTableName, stateType)));
                ret.add((JsonNode)realtime);
            }
            if (tableExists) {
                return ret.toString();
            }
            throw new ControllerApplicationException(LOGGER, "Table '" + tableName + "' does not exist", Response.Status.BAD_REQUEST);
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    @DELETE
    @Path(value="/tables/{tableName}")
    @Authenticate(value=AccessType.DELETE)
    @Produces(value={"application/json"})
    @ApiOperation(value="Deletes a table", notes="Deletes a table")
    public SuccessResponse deleteTable(@ApiParam(value="Name of the table to delete", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="realtime|offline") @QueryParam(value="type") String tableTypeStr) {
        TableType tableType = Constants.validateTableType(tableTypeStr);
        LinkedList<String> tablesDeleted = new LinkedList<String>();
        try {
            boolean tableExist = false;
            if (this.verifyTableType(tableName, tableType, TableType.OFFLINE)) {
                tableExist = this._pinotHelixResourceManager.hasOfflineTable(tableName);
                this._pinotHelixResourceManager.deleteOfflineTable(tableName);
                if (tableExist) {
                    tablesDeleted.add(TableNameBuilder.OFFLINE.tableNameWithType(tableName));
                }
            }
            if (this.verifyTableType(tableName, tableType, TableType.REALTIME)) {
                tableExist = this._pinotHelixResourceManager.hasRealtimeTable(tableName);
                this._pinotHelixResourceManager.deleteRealtimeTable(tableName);
                if (tableExist) {
                    tablesDeleted.add(TableNameBuilder.REALTIME.tableNameWithType(tableName));
                }
            }
            if (!tablesDeleted.isEmpty()) {
                return new SuccessResponse("Tables: " + tablesDeleted + " deleted");
            }
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
        throw new ControllerApplicationException(LOGGER, "Table '" + tableName + "' with type " + tableType + " does not exist", Response.Status.NOT_FOUND);
    }

    private boolean verifyTableType(String tableName, TableType tableType, TableType expectedType) {
        if (tableType != null && tableType != expectedType) {
            return false;
        }
        TableType typeFromTableName = TableNameBuilder.getTableTypeFromTableName((String)tableName);
        return typeFromTableName == null || typeFromTableName == expectedType;
    }

    @PUT
    @Path(value="/tables/{tableName}")
    @Authenticate(value=AccessType.UPDATE)
    @Produces(value={"application/json"})
    @ApiOperation(value="Updates table config for a table", notes="Updates table config for a table")
    public SuccessResponse updateTableConfig(@ApiParam(value="Name of the table to update", required=true) @PathParam(value="tableName") String tableName, String tableConfigString) throws Exception {
        TableConfig tableConfig;
        try {
            tableConfig = (TableConfig)JsonUtils.stringToObject((String)tableConfigString, TableConfig.class);
            Schema schema = this._pinotHelixResourceManager.getSchemaForTableConfig(tableConfig);
            TableConfigUtils.validate((TableConfig)tableConfig, (Schema)schema);
        }
        catch (Exception e) {
            String msg = String.format("Invalid table config: %s with error: %s", tableName, e.getMessage());
            throw new ControllerApplicationException(LOGGER, msg, Response.Status.BAD_REQUEST, (Throwable)e);
        }
        try {
            String tableNameWithType = tableConfig.getTableName();
            if (!TableNameBuilder.forType((TableType)tableConfig.getTableType()).tableNameWithType(tableName).equals(tableNameWithType)) {
                throw new ControllerApplicationException(LOGGER, "Request table " + tableName + " does not match table name in the body " + tableNameWithType, Response.Status.BAD_REQUEST);
            }
            if (!this._pinotHelixResourceManager.hasTable(tableNameWithType)) {
                throw new ControllerApplicationException(LOGGER, "Table " + tableNameWithType + " does not exist", Response.Status.NOT_FOUND);
            }
            try {
                TableConfigUtils.ensureMinReplicas((TableConfig)tableConfig, (int)this._controllerConf.getDefaultTableMinReplicas());
                TableConfigUtils.ensureStorageQuotaConstraints((TableConfig)tableConfig, (String)this._controllerConf.getDimTableMaxSize());
                this.checkHybridTableConfig(TableNameBuilder.extractRawTableName((String)tableName), tableConfig);
            }
            catch (Exception e) {
                throw new InvalidTableConfigException(e);
            }
            this._pinotHelixResourceManager.updateTableConfig(tableConfig);
        }
        catch (InvalidTableConfigException e) {
            String errStr = String.format("Failed to update configuration for %s due to: %s", tableName, e.getMessage());
            this._controllerMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ControllerMeter.CONTROLLER_TABLE_UPDATE_ERROR, 1L);
            throw new ControllerApplicationException(LOGGER, errStr, Response.Status.BAD_REQUEST, (Throwable)e);
        }
        catch (Exception e) {
            this._controllerMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ControllerMeter.CONTROLLER_TABLE_UPDATE_ERROR, 1L);
            throw e;
        }
        return new SuccessResponse("Table config updated for " + tableName);
    }

    @POST
    @Path(value="/tables/validate")
    @Produces(value={"application/json"})
    @ApiOperation(value="Validate table config for a table", notes="This API returns the table config that matches the one you get from 'GET /tables/{tableName}'. This allows us to validate table config before apply.")
    public String checkTableConfig(String tableConfigStr) {
        TableConfig tableConfig;
        try {
            tableConfig = (TableConfig)JsonUtils.stringToObject((String)tableConfigStr, TableConfig.class);
        }
        catch (IOException e) {
            String msg = String.format("Invalid table config json string: %s", tableConfigStr);
            throw new ControllerApplicationException(LOGGER, msg, Response.Status.BAD_REQUEST, (Throwable)e);
        }
        return this.validateConfig(tableConfig, this._pinotHelixResourceManager.getSchemaForTableConfig(tableConfig));
    }

    @Deprecated
    @POST
    @Path(value="/tables/validateTableAndSchema")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Validate table config for a table along with specified schema", notes="Deprecated. Use /tableConfigs/validate instead.Validate given table config and schema. If specified schema is null, attempt to retrieve schema using the table name. This API returns the table config that matches the one you get from 'GET /tables/{tableName}'. This allows us to validate table config before apply.")
    public String validateTableAndSchema(TableAndSchemaConfig tableSchemaConfig) {
        TableConfig tableConfig = tableSchemaConfig.getTableConfig();
        Schema schema = tableSchemaConfig.getSchema();
        if (schema == null) {
            schema = this._pinotHelixResourceManager.getSchemaForTableConfig(tableConfig);
        }
        return this.validateConfig(tableSchemaConfig.getTableConfig(), schema);
    }

    private String validateConfig(TableConfig tableConfig, Schema schema) {
        try {
            if (schema == null) {
                throw new SchemaNotFoundException("Got empty schema");
            }
            TableConfigUtils.validate((TableConfig)tableConfig, (Schema)schema);
            ObjectNode tableConfigValidateStr = JsonUtils.newObjectNode();
            if (tableConfig.getTableType() == TableType.OFFLINE) {
                tableConfigValidateStr.set(TableType.OFFLINE.name(), tableConfig.toJsonNode());
            } else {
                tableConfigValidateStr.set(TableType.REALTIME.name(), tableConfig.toJsonNode());
            }
            return tableConfigValidateStr.toString();
        }
        catch (Exception e) {
            String msg = String.format("Invalid table config: %s. %s", tableConfig.getTableName(), e.getMessage());
            throw new ControllerApplicationException(LOGGER, msg, Response.Status.BAD_REQUEST, (Throwable)e);
        }
    }

    @POST
    @Produces(value={"application/json"})
    @Authenticate(value=AccessType.UPDATE)
    @Path(value="/tables/{tableName}/rebalance")
    @ApiOperation(value="Rebalances a table (reassign instances and segments for a table)", notes="Rebalances a table (reassign instances and segments for a table)")
    public RebalanceResult rebalance(@ApiParam(value="Name of the table to rebalance", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="OFFLINE|REALTIME", required=true) @QueryParam(value="type") String tableTypeStr, @ApiParam(value="Whether to rebalance table in dry-run mode") @DefaultValue(value="false") @QueryParam(value="dryRun") boolean dryRun, @ApiParam(value="Whether to reassign instances before reassigning segments") @DefaultValue(value="false") @QueryParam(value="reassignInstances") boolean reassignInstances, @ApiParam(value="Whether to reassign CONSUMING segments for real-time table") @DefaultValue(value="false") @QueryParam(value="includeConsuming") boolean includeConsuming, @ApiParam(value="Whether to rebalance table in bootstrap mode (regardless of minimum segment movement, reassign all segments in a round-robin fashion as if adding new segments to an empty table)") @DefaultValue(value="false") @QueryParam(value="bootstrap") boolean bootstrap, @ApiParam(value="Whether to allow downtime for the rebalance") @DefaultValue(value="false") @QueryParam(value="downtime") boolean downtime, @ApiParam(value="For no-downtime rebalance, minimum number of replicas to keep alive during rebalance, or maximum number of replicas allowed to be unavailable if value is negative") @DefaultValue(value="1") @QueryParam(value="minAvailableReplicas") int minAvailableReplicas, @ApiParam(value="Whether to use best-efforts to rebalance (not fail the rebalance when the no-downtime contract cannot be achieved)") @DefaultValue(value="false") @QueryParam(value="bestEfforts") boolean bestEfforts) {
        String tableNameWithType = this.constructTableNameWithType(tableName, tableTypeStr);
        BaseConfiguration rebalanceConfig = new BaseConfiguration();
        rebalanceConfig.addProperty("dryRun", (Object)dryRun);
        rebalanceConfig.addProperty("reassignInstances", (Object)reassignInstances);
        rebalanceConfig.addProperty("includeConsuming", (Object)includeConsuming);
        rebalanceConfig.addProperty("bootstrap", (Object)bootstrap);
        rebalanceConfig.addProperty("downtime", (Object)downtime);
        rebalanceConfig.addProperty("minReplicasToKeepUpForNoDowntime", (Object)minAvailableReplicas);
        rebalanceConfig.addProperty("bestEfforts", (Object)bestEfforts);
        try {
            if (dryRun || downtime) {
                return this._pinotHelixResourceManager.rebalanceTable(tableNameWithType, (Configuration)rebalanceConfig);
            }
            rebalanceConfig.setProperty("dryRun", (Object)true);
            RebalanceResult dryRunResult = this._pinotHelixResourceManager.rebalanceTable(tableNameWithType, (Configuration)rebalanceConfig);
            if (dryRunResult.getStatus() == RebalanceResult.Status.DONE) {
                rebalanceConfig.setProperty("dryRun", (Object)false);
                this._executorService.submit(() -> this.lambda$rebalance$3(tableNameWithType, (Configuration)rebalanceConfig));
                return new RebalanceResult(RebalanceResult.Status.IN_PROGRESS, "In progress, check controller logs for updates", dryRunResult.getInstanceAssignment(), dryRunResult.getSegmentAssignment());
            }
            return dryRunResult;
        }
        catch (TableNotFoundException e) {
            throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.NOT_FOUND);
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/tables/{tableName}/state")
    @ApiOperation(value="Get current table state", notes="Get current table state")
    public String getTableState(@ApiParam(value="Name of the table to get its state", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="realtime|offline", required=true) @QueryParam(value="type") String tableTypeStr) {
        String tableNameWithType = this.constructTableNameWithType(tableName, tableTypeStr);
        try {
            ObjectNode data = JsonUtils.newObjectNode();
            data.put("state", this._pinotHelixResourceManager.isTableEnabled(tableNameWithType) ? "enabled" : "disabled");
            return data.toString();
        }
        catch (TableNotFoundException e) {
            throw new ControllerApplicationException(LOGGER, "Failed to find table: " + tableNameWithType, Response.Status.NOT_FOUND);
        }
    }

    @GET
    @Path(value="/tables/{tableName}/stats")
    @Produces(value={"application/json"})
    @ApiOperation(value="table stats", notes="Provides metadata info/stats about the table.")
    public String getTableStats(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="realtime|offline") @QueryParam(value="type") String tableTypeStr) {
        TableStats tableStats;
        String tableNameWithType;
        ObjectNode ret = JsonUtils.newObjectNode();
        if ((tableTypeStr == null || TableType.OFFLINE.name().equalsIgnoreCase(tableTypeStr)) && this._pinotHelixResourceManager.hasOfflineTable(tableName)) {
            tableNameWithType = TableNameBuilder.forType((TableType)TableType.OFFLINE).tableNameWithType(tableName);
            tableStats = this._pinotHelixResourceManager.getTableStats(tableNameWithType);
            ret.set(TableType.OFFLINE.name(), JsonUtils.objectToJsonNode((Object)tableStats));
        }
        if ((tableTypeStr == null || TableType.REALTIME.name().equalsIgnoreCase(tableTypeStr)) && this._pinotHelixResourceManager.hasRealtimeTable(tableName)) {
            tableNameWithType = TableNameBuilder.forType((TableType)TableType.REALTIME).tableNameWithType(tableName);
            tableStats = this._pinotHelixResourceManager.getTableStats(tableNameWithType);
            ret.set(TableType.REALTIME.name(), JsonUtils.objectToJsonNode((Object)tableStats));
        }
        return ret.toString();
    }

    private String constructTableNameWithType(String tableName, String tableTypeStr) {
        TableType tableType;
        try {
            tableType = TableType.valueOf((String)tableTypeStr.toUpperCase());
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, "Illegal table type: " + tableTypeStr, Response.Status.BAD_REQUEST);
        }
        return TableNameBuilder.forType((TableType)tableType).tableNameWithType(tableName);
    }

    private void checkHybridTableConfig(String rawTableName, TableConfig tableConfig) {
        if (tableConfig.getTableType() == TableType.REALTIME) {
            if (this._pinotHelixResourceManager.hasOfflineTable(rawTableName)) {
                TableConfigUtils.verifyHybridTableConfigs((String)rawTableName, (TableConfig)this._pinotHelixResourceManager.getOfflineTableConfig(rawTableName), (TableConfig)tableConfig);
            }
        } else if (this._pinotHelixResourceManager.hasRealtimeTable(rawTableName)) {
            TableConfigUtils.verifyHybridTableConfigs((String)rawTableName, (TableConfig)tableConfig, (TableConfig)this._pinotHelixResourceManager.getRealtimeTableConfig(rawTableName));
        }
    }

    @GET
    @Path(value="/tables/{tableName}/status")
    @Produces(value={"application/json"})
    @ApiOperation(value="table status", notes="Provides status of the table including ingestion status")
    public String getTableStatus(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="realtime|offline") @QueryParam(value="type") String tableTypeStr) {
        try {
            TableType tableType = Constants.validateTableType(tableTypeStr);
            if (tableType == null) {
                throw new ControllerApplicationException(LOGGER, "Table type should either be realtime|offline", Response.Status.BAD_REQUEST);
            }
            String tableNameWithType = TableNameBuilder.forType((TableType)tableType).tableNameWithType(tableName);
            if (!this._pinotHelixResourceManager.hasTable(tableNameWithType)) {
                throw new ControllerApplicationException(LOGGER, "Specified table name: " + tableName + " of type: " + tableTypeStr + " does not exist.", Response.Status.BAD_REQUEST);
            }
            TableStatus.IngestionStatus ingestionStatus = null;
            ingestionStatus = TableType.OFFLINE == tableType ? TableIngestionStatusHelper.getOfflineTableIngestionStatus(tableNameWithType, this._pinotHelixResourceManager, this._pinotHelixTaskResourceManager) : TableIngestionStatusHelper.getRealtimeTableIngestionStatus(tableNameWithType, this._controllerConf.getServerAdminRequestTimeoutSeconds() * 1000, this._executor, this._connectionManager, this._pinotHelixResourceManager);
            TableStatus tableStatus = new TableStatus(ingestionStatus);
            return JsonUtils.objectToPrettyString((Object)tableStatus);
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, String.format("Failed to get status (ingestion status) for table %s. Reason: %s", tableName, e.getMessage()), Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    @GET
    @Path(value="tables/{tableName}/metadata")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the aggregate metadata of all segments for a table", notes="Get the aggregate metadata of all segments for a table")
    public String getTableAggregateMetadata(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="OFFLINE|REALTIME") @QueryParam(value="type") String tableTypeStr, @ApiParam(value="Columns name", allowMultiple=true) @QueryParam(value="columns") @DefaultValue(value="") List<String> columns) {
        String segmentsMetadata;
        LOGGER.info("Received a request to fetch aggregate metadata for a table {}", (Object)tableName);
        TableType tableType = Constants.validateTableType(tableTypeStr);
        if (tableType == TableType.REALTIME) {
            throw new ControllerApplicationException(LOGGER, "Table type : " + tableTypeStr + " not yet supported.", Response.Status.NOT_IMPLEMENTED);
        }
        String tableNameWithType = ResourceUtils.getExistingTableNamesWithType(this._pinotHelixResourceManager, tableName, tableType, LOGGER).get(0);
        TableConfig tableConfig = this._pinotHelixResourceManager.getTableConfig(tableNameWithType);
        SegmentsValidationAndRetentionConfig segmentsConfig = tableConfig != null ? tableConfig.getValidationConfig() : null;
        int numReplica = segmentsConfig == null ? 1 : Integer.parseInt(segmentsConfig.getReplication());
        try {
            JsonNode segmentsMetadataJson = this.getAggregateMetadataFromServer(tableNameWithType, columns, numReplica);
            segmentsMetadata = JsonUtils.objectToPrettyString((Object)segmentsMetadataJson);
        }
        catch (InvalidConfigException e) {
            throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.BAD_REQUEST);
        }
        catch (IOException ioe) {
            throw new ControllerApplicationException(LOGGER, "Error parsing Pinot server response: " + ioe.getMessage(), Response.Status.INTERNAL_SERVER_ERROR, (Throwable)ioe);
        }
        return segmentsMetadata;
    }

    private JsonNode getAggregateMetadataFromServer(String tableNameWithType, List<String> columns, int numReplica) throws InvalidConfigException, IOException {
        TableMetadataReader tableMetadataReader = new TableMetadataReader(this._executor, this._connectionManager, this._pinotHelixResourceManager);
        return tableMetadataReader.getAggregateTableMetadata(tableNameWithType, columns, numReplica, this._controllerConf.getServerAdminRequestTimeoutSeconds() * 1000);
    }

    private /* synthetic */ void lambda$rebalance$3(String tableNameWithType, Configuration rebalanceConfig) {
        try {
            this._pinotHelixResourceManager.rebalanceTable(tableNameWithType, rebalanceConfig);
        }
        catch (Throwable t) {
            LOGGER.error("Caught exception/error while rebalancing table: {}", (Object)tableNameWithType, (Object)t);
        }
    }

    private static enum SortType {
        NAME,
        CREATIONTIME,
        LASTMODIFIEDTIME;

    }
}

