/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.resources;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.apache.helix.task.TaskState;
import org.apache.pinot.controller.api.access.AccessType;
import org.apache.pinot.controller.api.access.Authenticate;
import org.apache.pinot.controller.api.resources.StringResultResponse;
import org.apache.pinot.controller.api.resources.SuccessResponse;
import org.apache.pinot.controller.helix.core.minion.PinotHelixTaskResourceManager;
import org.apache.pinot.controller.helix.core.minion.PinotTaskManager;
import org.apache.pinot.core.minion.PinotTaskConfig;
import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerMetaData;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.impl.matchers.GroupMatcher;

@Api(tags={"Task"})
@Path(value="/")
public class PinotTaskRestletResource {
    private static final String TASK_QUEUE_STATE_STOP = "STOP";
    private static final String TASK_QUEUE_STATE_RESUME = "RESUME";
    @Inject
    PinotHelixTaskResourceManager _pinotHelixTaskResourceManager;
    @Inject
    PinotTaskManager _pinotTaskManager;

    @GET
    @Path(value="/tasks/tasktypes")
    @ApiOperation(value="List all task types")
    public Set<String> listTaskTypes() {
        return this._pinotHelixTaskResourceManager.getTaskTypes();
    }

    @Deprecated
    @GET
    @Path(value="/tasks/taskqueues")
    @ApiOperation(value="List all task queues (deprecated)")
    public Set<String> getTaskQueues() {
        return this._pinotHelixTaskResourceManager.getTaskQueues();
    }

    @GET
    @Path(value="/tasks/{taskType}/state")
    @ApiOperation(value="Get the state (task queue state) for the given task type")
    public TaskState getTaskQueueState(@ApiParam(value="Task type", required=true) @PathParam(value="taskType") String taskType) {
        return this._pinotHelixTaskResourceManager.getTaskQueueState(taskType);
    }

    @Deprecated
    @GET
    @Path(value="/tasks/taskqueuestate/{taskType}")
    @ApiOperation(value="Get the state (task queue state) for the given task type (deprecated)")
    public StringResultResponse getTaskQueueStateDeprecated(@ApiParam(value="Task type", required=true) @PathParam(value="taskType") String taskType) {
        return new StringResultResponse(this._pinotHelixTaskResourceManager.getTaskQueueState(taskType).toString());
    }

    @GET
    @Path(value="/tasks/{taskType}/tasks")
    @ApiOperation(value="List all tasks for the given task type")
    public Set<String> getTasks(@ApiParam(value="Task type", required=true) @PathParam(value="taskType") String taskType) {
        return this._pinotHelixTaskResourceManager.getTasks(taskType);
    }

    @GET
    @Path(value="/tasks/{taskType}/{tableNameWithType}/state")
    @ApiOperation(value="List all tasks for the given task type")
    public Map<String, TaskState> getTaskStatesByTable(@ApiParam(value="Task type", required=true) @PathParam(value="taskType") String taskType, @ApiParam(value="Table name with type", required=true) @PathParam(value="tableNameWithType") String tableNameWithType) {
        return this._pinotHelixTaskResourceManager.getTaskStatesByTable(taskType, tableNameWithType);
    }

    @Deprecated
    @GET
    @Path(value="/tasks/tasks/{taskType}")
    @ApiOperation(value="List all tasks for the given task type (deprecated)")
    public Set<String> getTasksDeprecated(@ApiParam(value="Task type", required=true) @PathParam(value="taskType") String taskType) {
        return this._pinotHelixTaskResourceManager.getTasks(taskType);
    }

    @GET
    @Path(value="/tasks/{taskType}/taskstates")
    @ApiOperation(value="Get a map from task to task state for the given task type")
    public Map<String, TaskState> getTaskStates(@ApiParam(value="Task type", required=true) @PathParam(value="taskType") String taskType) {
        return this._pinotHelixTaskResourceManager.getTaskStates(taskType);
    }

    @Deprecated
    @GET
    @Path(value="/tasks/taskstates/{taskType}")
    @ApiOperation(value="Get a map from task to task state for the given task type (deprecated)")
    public Map<String, TaskState> getTaskStatesDeprecated(@ApiParam(value="Task type", required=true) @PathParam(value="taskType") String taskType) {
        return this._pinotHelixTaskResourceManager.getTaskStates(taskType);
    }

    @GET
    @Path(value="/tasks/task/{taskName}/state")
    @ApiOperation(value="Get the task state for the given task")
    public TaskState getTaskState(@ApiParam(value="Task name", required=true) @PathParam(value="taskName") String taskName) {
        return this._pinotHelixTaskResourceManager.getTaskState(taskName);
    }

    @Deprecated
    @GET
    @Path(value="/tasks/taskstate/{taskName}")
    @ApiOperation(value="Get the task state for the given task (deprecated)")
    public StringResultResponse getTaskStateDeprecated(@ApiParam(value="Task name", required=true) @PathParam(value="taskName") String taskName) {
        return new StringResultResponse(this._pinotHelixTaskResourceManager.getTaskState(taskName).toString());
    }

    @GET
    @Path(value="/tasks/task/{taskName}/config")
    @ApiOperation(value="Get the task config (a list of child task configs) for the given task")
    public List<PinotTaskConfig> getTaskConfigs(@ApiParam(value="Task name", required=true) @PathParam(value="taskName") String taskName) {
        return this._pinotHelixTaskResourceManager.getTaskConfigs(taskName);
    }

    @Deprecated
    @GET
    @Path(value="/tasks/taskconfig/{taskName}")
    @ApiOperation(value="Get the task config (a list of child task configs) for the given task (deprecated)")
    public List<PinotTaskConfig> getTaskConfigsDeprecated(@ApiParam(value="Task name", required=true) @PathParam(value="taskName") String taskName) {
        return this._pinotHelixTaskResourceManager.getTaskConfigs(taskName);
    }

    @GET
    @Path(value="/tasks/scheduler/information")
    @ApiOperation(value="Fetch cron scheduler information")
    public Map<String, Object> getCronSchedulerInformation() throws SchedulerException {
        Scheduler scheduler = this._pinotTaskManager.getScheduler();
        if (scheduler == null) {
            throw new NotFoundException("Task scheduler is disabled");
        }
        SchedulerMetaData metaData = scheduler.getMetaData();
        HashMap<String, Object> schedulerMetaData = new HashMap<String, Object>();
        schedulerMetaData.put("Version", metaData.getVersion());
        schedulerMetaData.put("SchedulerName", metaData.getSchedulerName());
        schedulerMetaData.put("SchedulerInstanceId", metaData.getSchedulerInstanceId());
        schedulerMetaData.put("getThreadPoolClass", metaData.getThreadPoolClass());
        schedulerMetaData.put("getThreadPoolSize", metaData.getThreadPoolSize());
        schedulerMetaData.put("SchedulerClass", metaData.getSchedulerClass());
        schedulerMetaData.put("Clustered", metaData.isJobStoreClustered());
        schedulerMetaData.put("JobStoreClass", metaData.getJobStoreClass());
        schedulerMetaData.put("NumberOfJobsExecuted", metaData.getNumberOfJobsExecuted());
        schedulerMetaData.put("InStandbyMode", metaData.isInStandbyMode());
        schedulerMetaData.put("RunningSince", metaData.getRunningSince());
        ArrayList jobDetails = new ArrayList();
        for (String groupName : scheduler.getJobGroupNames()) {
            for (JobKey jobKey : scheduler.getJobKeys(GroupMatcher.jobGroupEquals((String)groupName))) {
                HashMap<String, Object> jobMap = new HashMap<String, Object>();
                List triggers = scheduler.getTriggersOfJob(jobKey);
                jobMap.put("JobKey", jobKey);
                jobMap.put("NextFireTime", ((Trigger)triggers.get(0)).getNextFireTime());
                jobMap.put("PreviousFireTime", ((Trigger)triggers.get(0)).getPreviousFireTime());
                jobDetails.add(jobMap);
            }
        }
        schedulerMetaData.put("JobDetails", jobDetails);
        return schedulerMetaData;
    }

    @GET
    @Path(value="/tasks/scheduler/jobKeys")
    @ApiOperation(value="Fetch cron scheduler job keys")
    public List<JobKey> getCronSchedulerJobKeys() throws SchedulerException {
        Scheduler scheduler = this._pinotTaskManager.getScheduler();
        if (scheduler == null) {
            throw new NotFoundException("Task scheduler is disabled");
        }
        ArrayList<JobKey> jobKeys = new ArrayList<JobKey>();
        for (String group : scheduler.getTriggerGroupNames()) {
            jobKeys.addAll(scheduler.getJobKeys(GroupMatcher.groupEquals((String)group)));
        }
        return jobKeys;
    }

    @GET
    @Path(value="/tasks/scheduler/jobDetails")
    @ApiOperation(value="Fetch cron scheduler job keys")
    public Map<String, Object> getCronSchedulerJobDetails(@ApiParam(value="Table name (with type suffix)") @QueryParam(value="tableName") String tableName, @ApiParam(value="Task type") @QueryParam(value="taskType") String taskType) throws SchedulerException {
        Scheduler scheduler = this._pinotTaskManager.getScheduler();
        if (scheduler == null) {
            throw new NotFoundException("Task scheduler is disabled");
        }
        JobKey jobKey = JobKey.jobKey((String)tableName, (String)taskType);
        if (!scheduler.checkExists(jobKey)) {
            throw new NotFoundException("Unable to find job detail for table name - " + tableName + ", task type - " + taskType);
        }
        JobDetail schedulerJobDetail = scheduler.getJobDetail(jobKey);
        HashMap<String, Object> jobDetail = new HashMap<String, Object>();
        jobDetail.put("JobKey", schedulerJobDetail.getKey());
        jobDetail.put("Description", schedulerJobDetail.getDescription());
        jobDetail.put("JobClass", schedulerJobDetail.getJobClass());
        JobDataMap jobData = schedulerJobDetail.getJobDataMap();
        HashMap<String, String> jobDataMap = new HashMap<String, String>();
        for (String key : jobData.getKeys()) {
            jobDataMap.put(key, jobData.get((Object)key).toString());
        }
        jobDetail.put("JobDataMap", jobDataMap);
        List triggers = scheduler.getTriggersOfJob(jobKey);
        ArrayList triggerMaps = new ArrayList();
        if (!triggers.isEmpty()) {
            for (Trigger trigger : triggers) {
                HashMap<String, Object> triggerMap = new HashMap<String, Object>();
                if (trigger instanceof SimpleTrigger) {
                    SimpleTrigger simpleTrigger = (SimpleTrigger)trigger;
                    triggerMap.put("TriggerType", SimpleTrigger.class.getSimpleName());
                    triggerMap.put("RepeatInterval", simpleTrigger.getRepeatInterval());
                    triggerMap.put("RepeatCount", simpleTrigger.getRepeatCount());
                    triggerMap.put("TimesTriggered", simpleTrigger.getTimesTriggered());
                } else if (trigger instanceof CronTrigger) {
                    CronTrigger cronTrigger = (CronTrigger)trigger;
                    triggerMap.put("TriggerType", CronTrigger.class.getSimpleName());
                    triggerMap.put("TimeZone", cronTrigger.getTimeZone());
                    triggerMap.put("CronExpression", cronTrigger.getCronExpression());
                    triggerMap.put("ExpressionSummary", cronTrigger.getExpressionSummary());
                    triggerMap.put("NextFireTime", cronTrigger.getNextFireTime());
                    triggerMap.put("PreviousFireTime", cronTrigger.getPreviousFireTime());
                }
                triggerMaps.add(triggerMap);
            }
        }
        jobDetail.put("Triggers", triggerMaps);
        return jobDetail;
    }

    @POST
    @Path(value="/tasks/schedule")
    @Authenticate(value=AccessType.UPDATE)
    @ApiOperation(value="Schedule tasks and return a map from task type to task name scheduled")
    public Map<String, String> scheduleTasks(@ApiParam(value="Task type") @QueryParam(value="taskType") String taskType, @ApiParam(value="Table name (with type suffix)") @QueryParam(value="tableName") String tableName) {
        if (taskType != null) {
            String taskName = tableName != null ? this._pinotTaskManager.scheduleTask(taskType, tableName) : this._pinotTaskManager.scheduleTask(taskType);
            return Collections.singletonMap(taskType, taskName);
        }
        return tableName != null ? this._pinotTaskManager.scheduleTasks(tableName) : this._pinotTaskManager.scheduleTasks();
    }

    @Deprecated
    @PUT
    @Path(value="/tasks/scheduletasks")
    @Authenticate(value=AccessType.UPDATE)
    @ApiOperation(value="Schedule tasks (deprecated)")
    public Map<String, String> scheduleTasksDeprecated() {
        return this._pinotTaskManager.scheduleTasks();
    }

    @PUT
    @Path(value="/tasks/{taskType}/cleanup")
    @Authenticate(value=AccessType.UPDATE)
    @ApiOperation(value="Clean up finished tasks (COMPLETED, FAILED) for the given task type")
    public SuccessResponse cleanUpTasks(@ApiParam(value="Task type", required=true) @PathParam(value="taskType") String taskType) {
        this._pinotHelixTaskResourceManager.cleanUpTaskQueue(taskType);
        return new SuccessResponse("Successfully cleaned up tasks for task type: " + taskType);
    }

    @Deprecated
    @PUT
    @Path(value="/tasks/cleanuptasks/{taskType}")
    @Authenticate(value=AccessType.UPDATE)
    @ApiOperation(value="Clean up finished tasks (COMPLETED, FAILED) for the given task type (deprecated)")
    public SuccessResponse cleanUpTasksDeprecated(@ApiParam(value="Task type", required=true) @PathParam(value="taskType") String taskType) {
        this._pinotHelixTaskResourceManager.cleanUpTaskQueue(taskType);
        return new SuccessResponse("Successfully cleaned up tasks for task type: " + taskType);
    }

    @PUT
    @Path(value="/tasks/{taskType}/stop")
    @Authenticate(value=AccessType.UPDATE)
    @ApiOperation(value="Stop all running/pending tasks (as well as the task queue) for the given task type")
    public SuccessResponse stopTasks(@ApiParam(value="Task type", required=true) @PathParam(value="taskType") String taskType) {
        this._pinotHelixTaskResourceManager.stopTaskQueue(taskType);
        return new SuccessResponse("Successfully stopped tasks for task type: " + taskType);
    }

    @PUT
    @Path(value="/tasks/{taskType}/resume")
    @Authenticate(value=AccessType.UPDATE)
    @ApiOperation(value="Resume all stopped tasks (as well as the task queue) for the given task type")
    public SuccessResponse resumeTasks(@ApiParam(value="Task type", required=true) @PathParam(value="taskType") String taskType) {
        this._pinotHelixTaskResourceManager.resumeTaskQueue(taskType);
        return new SuccessResponse("Successfully resumed tasks for task type: " + taskType);
    }

    @Deprecated
    @PUT
    @Path(value="/tasks/taskqueue/{taskType}")
    @Authenticate(value=AccessType.UPDATE)
    @ApiOperation(value="Stop/resume a task queue (deprecated)")
    public SuccessResponse toggleTaskQueueState(@ApiParam(value="Task type", required=true) @PathParam(value="taskType") String taskType, @ApiParam(value="state", required=true) @QueryParam(value="state") String state) {
        switch (state.toUpperCase()) {
            case "STOP": {
                this._pinotHelixTaskResourceManager.stopTaskQueue(taskType);
                return new SuccessResponse("Successfully stopped task queue for task type: " + taskType);
            }
            case "RESUME": {
                this._pinotHelixTaskResourceManager.resumeTaskQueue(taskType);
                return new SuccessResponse("Successfully resumed task queue for task type: " + taskType);
            }
        }
        throw new IllegalArgumentException("Unsupported state: " + state);
    }

    @DELETE
    @Path(value="/tasks/{taskType}")
    @Authenticate(value=AccessType.DELETE)
    @ApiOperation(value="Delete all tasks (as well as the task queue) for the given task type")
    public SuccessResponse deleteTasks(@ApiParam(value="Task type", required=true) @PathParam(value="taskType") String taskType, @ApiParam(value="Whether to force deleting the tasks (expert only option, enable with cautious") @DefaultValue(value="false") @QueryParam(value="forceDelete") boolean forceDelete) {
        this._pinotHelixTaskResourceManager.deleteTaskQueue(taskType, forceDelete);
        return new SuccessResponse("Successfully deleted tasks for task type: " + taskType);
    }

    @Deprecated
    @DELETE
    @Path(value="/tasks/taskqueue/{taskType}")
    @Authenticate(value=AccessType.DELETE)
    @ApiOperation(value="Delete a task queue (deprecated)")
    public SuccessResponse deleteTaskQueue(@ApiParam(value="Task type", required=true) @PathParam(value="taskType") String taskType, @ApiParam(value="Whether to force delete the task queue (expert only option, enable with cautious") @DefaultValue(value="false") @QueryParam(value="forceDelete") boolean forceDelete) {
        this._pinotHelixTaskResourceManager.deleteTaskQueue(taskType, forceDelete);
        return new SuccessResponse("Successfully deleted task queue for task type: " + taskType);
    }
}

