/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.resources;

import java.util.List;
import javax.annotation.Nullable;
import javax.ws.rs.core.Response;
import org.apache.pinot.common.exception.TableNotFoundException;
import org.apache.pinot.controller.api.exception.ControllerApplicationException;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.spi.config.table.TableType;
import org.slf4j.Logger;

public class ResourceUtils {
    public static List<String> getExistingTableNamesWithType(PinotHelixResourceManager pinotHelixResourceManager, String tableName, @Nullable TableType tableType, Logger logger) {
        try {
            return pinotHelixResourceManager.getExistingTableNamesWithType(tableName, tableType);
        }
        catch (TableNotFoundException e) {
            throw new ControllerApplicationException(logger, e.getMessage(), Response.Status.NOT_FOUND);
        }
        catch (IllegalArgumentException e) {
            throw new ControllerApplicationException(logger, e.getMessage(), Response.Status.FORBIDDEN);
        }
    }
}

