/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.resources;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.base.Preconditions;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ControllerMeter;
import org.apache.pinot.common.metrics.ControllerMetrics;
import org.apache.pinot.controller.ControllerConf;
import org.apache.pinot.controller.api.access.AccessControl;
import org.apache.pinot.controller.api.access.AccessControlFactory;
import org.apache.pinot.controller.api.access.AccessControlUtils;
import org.apache.pinot.controller.api.access.AccessType;
import org.apache.pinot.controller.api.access.Authenticate;
import org.apache.pinot.controller.api.exception.ControllerApplicationException;
import org.apache.pinot.controller.api.exception.InvalidTableConfigException;
import org.apache.pinot.controller.api.exception.TableAlreadyExistsException;
import org.apache.pinot.controller.api.resources.SuccessResponse;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.controller.tuner.TableConfigTunerUtils;
import org.apache.pinot.segment.local.utils.SchemaUtils;
import org.apache.pinot.segment.local.utils.TableConfigUtils;
import org.apache.pinot.spi.config.TableConfigs;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.utils.JsonUtils;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.glassfish.grizzly.http.server.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"Table"})
@Path(value="/")
public class TableConfigsRestletResource {
    public static Logger LOGGER = LoggerFactory.getLogger(TableConfigsRestletResource.class);
    @Inject
    PinotHelixResourceManager _pinotHelixResourceManager;
    @Inject
    ControllerConf _controllerConf;
    @Inject
    ControllerMetrics _controllerMetrics;
    @Inject
    AccessControlFactory _accessControlFactory;
    AccessControlUtils _accessControlUtils = new AccessControlUtils();

    @GET
    @Produces(value={"application/json"})
    @Path(value="/tableConfigs")
    @Authenticate(value=AccessType.READ)
    @ApiOperation(value="Lists all TableConfigs in cluster", notes="Lists all TableConfigs in cluster")
    public String listConfigs() {
        try {
            List<String> rawTableNames = this._pinotHelixResourceManager.getAllRawTables();
            Collections.sort(rawTableNames);
            ArrayNode configsList = JsonUtils.newArrayNode();
            for (String rawTableName : rawTableNames) {
                configsList.add(rawTableName);
            }
            return configsList.toString();
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/tableConfigs/{tableName}")
    @Authenticate(value=AccessType.READ)
    @ApiOperation(value="Get the TableConfigs for a given raw tableName", notes="Get the TableConfigs for a given raw tableName")
    public String getConfig(@ApiParam(value="Raw table name", required=true) @PathParam(value="tableName") String tableName) {
        try {
            Schema schema = this._pinotHelixResourceManager.getSchema(tableName);
            TableConfig offlineTableConfig = this._pinotHelixResourceManager.getOfflineTableConfig(tableName);
            TableConfig realtimeTableConfig = this._pinotHelixResourceManager.getRealtimeTableConfig(tableName);
            TableConfigs config = new TableConfigs(tableName, schema, offlineTableConfig, realtimeTableConfig);
            return config.toJsonString();
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/tableConfigs")
    @ApiOperation(value="Add the TableConfigs using the tableConfigsStr json", notes="Add the TableConfigs using the tableConfigsStr json")
    public SuccessResponse addConfig(String tableConfigsStr, @Context HttpHeaders httpHeaders, @Context Request request) {
        TableConfigs tableConfigs;
        try {
            tableConfigs = (TableConfigs)JsonUtils.stringToObject((String)tableConfigsStr, TableConfigs.class);
            this.validateConfig(tableConfigs);
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, String.format("Invalid TableConfigs. %s", e.getMessage()), Response.Status.BAD_REQUEST, (Throwable)e);
        }
        String rawTableName = tableConfigs.getTableName();
        if (this._pinotHelixResourceManager.hasOfflineTable(rawTableName) || this._pinotHelixResourceManager.hasRealtimeTable(rawTableName) || this._pinotHelixResourceManager.getSchema(rawTableName) != null) {
            throw new ControllerApplicationException(LOGGER, String.format("TableConfigs: %s already exists. Use PUT to update existing config", rawTableName), Response.Status.BAD_REQUEST);
        }
        TableConfig offlineTableConfig = tableConfigs.getOffline();
        TableConfig realtimeTableConfig = tableConfigs.getRealtime();
        Schema schema = tableConfigs.getSchema();
        try {
            String endpointUrl = request.getRequestURL().toString();
            AccessControl accessControl = this._accessControlFactory.create();
            this._accessControlUtils.validatePermission(schema.getSchemaName(), AccessType.CREATE, httpHeaders, endpointUrl, accessControl);
            if (offlineTableConfig != null) {
                this.tuneConfig(offlineTableConfig, schema);
                this._accessControlUtils.validatePermission(offlineTableConfig.getTableName(), AccessType.CREATE, httpHeaders, endpointUrl, accessControl);
            }
            if (realtimeTableConfig != null) {
                this.tuneConfig(realtimeTableConfig, schema);
                this._accessControlUtils.validatePermission(realtimeTableConfig.getTableName(), AccessType.CREATE, httpHeaders, endpointUrl, accessControl);
            }
            try {
                this._pinotHelixResourceManager.addSchema(schema, false);
                LOGGER.info("Added schema: {}", (Object)schema.getSchemaName());
                if (offlineTableConfig != null) {
                    this._pinotHelixResourceManager.addTable(offlineTableConfig);
                    LOGGER.info("Added offline table config: {}", (Object)offlineTableConfig.getTableName());
                }
                if (realtimeTableConfig != null) {
                    this._pinotHelixResourceManager.addTable(realtimeTableConfig);
                    LOGGER.info("Added realtime table config: {}", (Object)realtimeTableConfig.getTableName());
                }
            }
            catch (Exception e) {
                this._pinotHelixResourceManager.deleteRealtimeTable(rawTableName);
                this._pinotHelixResourceManager.deleteOfflineTable(rawTableName);
                this._pinotHelixResourceManager.deleteSchema(schema);
                throw e;
            }
            return new SuccessResponse("TableConfigs " + tableConfigs.getTableName() + " successfully added");
        }
        catch (Exception e) {
            this._controllerMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ControllerMeter.CONTROLLER_TABLE_ADD_ERROR, 1L);
            if (e instanceof InvalidTableConfigException) {
                throw new ControllerApplicationException(LOGGER, String.format("Invalid TableConfigs: %s", tableConfigs.getTableName()), Response.Status.BAD_REQUEST, (Throwable)e);
            }
            if (e instanceof TableAlreadyExistsException) {
                throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.CONFLICT, (Throwable)e);
            }
            throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    @DELETE
    @Path(value="/tableConfigs/{tableName}")
    @Authenticate(value=AccessType.DELETE)
    @Produces(value={"application/json"})
    @ApiOperation(value="Delete the TableConfigs", notes="Delete the TableConfigs")
    public SuccessResponse deleteConfig(@ApiParam(value="TableConfigs name i.e. raw table name", required=true) @PathParam(value="tableName") String tableName) {
        try {
            boolean tableExists = false;
            if (this._pinotHelixResourceManager.hasRealtimeTable(tableName) || this._pinotHelixResourceManager.hasOfflineTable(tableName)) {
                tableExists = true;
            }
            this._pinotHelixResourceManager.deleteRealtimeTable(tableName);
            LOGGER.info("Deleted realtime table: {}", (Object)tableName);
            this._pinotHelixResourceManager.deleteOfflineTable(tableName);
            LOGGER.info("Deleted offline table: {}", (Object)tableName);
            Schema schema = this._pinotHelixResourceManager.getSchema(tableName);
            if (schema != null) {
                this._pinotHelixResourceManager.deleteSchema(schema);
                LOGGER.info("Deleted schema: {}", (Object)tableName);
            }
            if (tableExists || schema != null) {
                return new SuccessResponse("Deleted TableConfigs: " + tableName);
            }
            return new SuccessResponse("TableConfigs: " + tableName + " don't exist. Invoked delete anyway to clean stale metadata/segments");
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    @PUT
    @Path(value="/tableConfigs/{tableName}")
    @Authenticate(value=AccessType.UPDATE)
    @Produces(value={"application/json"})
    @ApiOperation(value="Update the TableConfigs provided by the tableConfigsStr json", notes="Update the TableConfigs provided by the tableConfigsStr json")
    public SuccessResponse updateConfig(@ApiParam(value="TableConfigs name i.e. raw table name", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="Reload the table if the new schema is backward compatible") @DefaultValue(value="false") @QueryParam(value="reload") boolean reload, String tableConfigsStr) throws Exception {
        TableConfigs tableConfigs;
        try {
            tableConfigs = (TableConfigs)JsonUtils.stringToObject((String)tableConfigsStr, TableConfigs.class);
            Preconditions.checkState((boolean)tableConfigs.getTableName().equals(tableName), (String)"'tableName' in TableConfigs: %s must match provided tableName: %s", (Object)tableConfigs.getTableName(), (Object)tableName);
            this.validateConfig(tableConfigs);
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, String.format("Invalid TableConfigs: %s", tableName), Response.Status.BAD_REQUEST, (Throwable)e);
        }
        if (!this._pinotHelixResourceManager.hasOfflineTable(tableName) && !this._pinotHelixResourceManager.hasRealtimeTable(tableName)) {
            throw new ControllerApplicationException(LOGGER, String.format("TableConfigs: %s does not exist. Use POST to create it first.", tableName), Response.Status.BAD_REQUEST);
        }
        TableConfig offlineTableConfig = tableConfigs.getOffline();
        TableConfig realtimeTableConfig = tableConfigs.getRealtime();
        Schema schema = tableConfigs.getSchema();
        try {
            this._pinotHelixResourceManager.updateSchema(schema, reload);
            LOGGER.info("Updated schema: {}", (Object)tableName);
            if (offlineTableConfig != null) {
                this.tuneConfig(offlineTableConfig, schema);
                if (this._pinotHelixResourceManager.hasOfflineTable(tableName)) {
                    this._pinotHelixResourceManager.updateTableConfig(offlineTableConfig);
                    LOGGER.info("Updated offline table config: {}", (Object)tableName);
                } else {
                    this._pinotHelixResourceManager.addTable(offlineTableConfig);
                    LOGGER.info("Created offline table config: {}", (Object)tableName);
                }
            }
            if (realtimeTableConfig != null) {
                this.tuneConfig(realtimeTableConfig, schema);
                if (this._pinotHelixResourceManager.hasRealtimeTable(tableName)) {
                    this._pinotHelixResourceManager.updateTableConfig(realtimeTableConfig);
                    LOGGER.info("Updated realtime table config: {}", (Object)tableName);
                } else {
                    this._pinotHelixResourceManager.addTable(realtimeTableConfig);
                    LOGGER.info("Created realtime table config: {}", (Object)tableName);
                }
            }
        }
        catch (InvalidTableConfigException e) {
            this._controllerMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ControllerMeter.CONTROLLER_TABLE_UPDATE_ERROR, 1L);
            throw new ControllerApplicationException(LOGGER, String.format("Invalid TableConfigs for: %s, %s", tableName, e.getMessage()), Response.Status.BAD_REQUEST, (Throwable)e);
        }
        catch (Exception e) {
            this._controllerMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ControllerMeter.CONTROLLER_TABLE_UPDATE_ERROR, 1L);
            throw new ControllerApplicationException(LOGGER, String.format("Failed to update TableConfigs for: %s, %s", tableName, e.getMessage()), Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
        return new SuccessResponse("TableConfigs updated for " + tableName);
    }

    @POST
    @Path(value="/tableConfigs/validate")
    @Produces(value={"application/json"})
    @ApiOperation(value="Validate the TableConfigs", notes="Validate the TableConfigs")
    public String validateConfig(String tableConfigsStr) {
        TableConfigs tableConfigs;
        try {
            tableConfigs = (TableConfigs)JsonUtils.stringToObject((String)tableConfigsStr, TableConfigs.class);
        }
        catch (IOException e) {
            throw new ControllerApplicationException(LOGGER, String.format("Invalid TableConfigs json string: %s", tableConfigsStr), Response.Status.BAD_REQUEST, (Throwable)e);
        }
        return this.validateConfig(tableConfigs);
    }

    private void tuneConfig(TableConfig tableConfig, Schema schema) {
        TableConfigTunerUtils.applyTunerConfig(this._pinotHelixResourceManager, tableConfig, schema);
        TableConfigUtils.ensureMinReplicas((TableConfig)tableConfig, (int)this._controllerConf.getDefaultTableMinReplicas());
        TableConfigUtils.ensureStorageQuotaConstraints((TableConfig)tableConfig, (String)this._controllerConf.getDimTableMaxSize());
    }

    private String validateConfig(TableConfigs tableConfigs) {
        String rawTableName = tableConfigs.getTableName();
        TableConfig offlineTableConfig = tableConfigs.getOffline();
        TableConfig realtimeTableConfig = tableConfigs.getRealtime();
        Schema schema = tableConfigs.getSchema();
        try {
            Preconditions.checkState((offlineTableConfig != null || realtimeTableConfig != null ? 1 : 0) != 0, (String)"Must provide at least one of 'realtime' or 'offline' table configs for adding TableConfigs: %s", (Object)rawTableName);
            Preconditions.checkState((schema != null ? 1 : 0) != 0, (String)"Must provide 'schema' for adding TableConfigs: %s", (Object)rawTableName);
            Preconditions.checkState((!rawTableName.isEmpty() ? 1 : 0) != 0, (Object)"'tableName' cannot be empty in TableConfigs");
            Preconditions.checkState((boolean)rawTableName.equals(schema.getSchemaName()), (String)"'tableName': %s must be equal to 'schemaName' from 'schema': %s", (Object)rawTableName, (Object)schema.getSchemaName());
            SchemaUtils.validate((Schema)schema);
            if (offlineTableConfig != null) {
                String offlineRawTableName = TableNameBuilder.extractRawTableName((String)offlineTableConfig.getTableName());
                Preconditions.checkState((boolean)offlineRawTableName.equals(rawTableName), (String)"Name in 'offline' table config: %s must be equal to 'tableName': %s", (Object)offlineRawTableName, (Object)rawTableName);
                TableConfigUtils.validateTableName((TableConfig)offlineTableConfig);
                TableConfigUtils.validate((TableConfig)offlineTableConfig, (Schema)schema);
            }
            if (realtimeTableConfig != null) {
                String realtimeRawTableName = TableNameBuilder.extractRawTableName((String)realtimeTableConfig.getTableName());
                Preconditions.checkState((boolean)realtimeRawTableName.equals(rawTableName), (String)"Name in 'realtime' table config: %s must be equal to 'tableName': %s", (Object)realtimeRawTableName, (Object)rawTableName);
                TableConfigUtils.validateTableName((TableConfig)realtimeTableConfig);
                TableConfigUtils.validate((TableConfig)realtimeTableConfig, (Schema)schema);
            }
            if (offlineTableConfig != null && realtimeTableConfig != null) {
                TableConfigUtils.verifyHybridTableConfigs((String)rawTableName, (TableConfig)offlineTableConfig, (TableConfig)realtimeTableConfig);
            }
            return tableConfigs.toJsonString();
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, String.format("Invalid TableConfigs: %s. %s", rawTableName, e.getMessage()), Response.Status.BAD_REQUEST, (Throwable)e);
        }
    }
}

