/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.resources;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.BiMap;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.PropertyKey;
import org.apache.helix.model.ExternalView;
import org.apache.helix.model.IdealState;
import org.apache.pinot.common.exception.InvalidConfigException;
import org.apache.pinot.common.metrics.ControllerMetrics;
import org.apache.pinot.common.restlet.resources.SegmentConsumerInfo;
import org.apache.pinot.common.restlet.resources.SegmentErrorInfo;
import org.apache.pinot.common.restlet.resources.SegmentServerDebugInfo;
import org.apache.pinot.controller.ControllerConf;
import org.apache.pinot.controller.api.debug.TableDebugInfo;
import org.apache.pinot.controller.api.exception.ControllerApplicationException;
import org.apache.pinot.controller.api.resources.Constants;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.controller.helix.core.minion.PinotHelixTaskResourceManager;
import org.apache.pinot.controller.util.CompletionServiceHelper;
import org.apache.pinot.controller.util.TableIngestionStatusHelper;
import org.apache.pinot.controller.util.TableSizeReader;
import org.apache.pinot.spi.config.table.TableStatus;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.utils.CommonConstants;
import org.apache.pinot.spi.utils.JsonUtils;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"Cluster"})
@Path(value="/")
public class TableDebugResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableDebugResource.class);
    @Inject
    PinotHelixResourceManager _pinotHelixResourceManager;
    @Inject
    PinotHelixTaskResourceManager _pinotHelixTaskResourceManager;
    @Inject
    Executor _executor;
    @Inject
    HttpConnectionManager _connectionManager;
    @Inject
    ControllerMetrics _controllerMetrics;
    @Inject
    ControllerConf _controllerConf;

    @GET
    @Path(value="/debug/tables/{tableName}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get debug information for table.", notes="Debug information for table.")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=404, message="Table not found"), @ApiResponse(code=500, message="Internal server error")})
    public String getTableDebugInfo(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="OFFLINE|REALTIME") @QueryParam(value="type") String tableTypeStr, @ApiParam(value="Verbosity of debug information") @DefaultValue(value="0") @QueryParam(value="verbosity") int verbosity) throws JsonProcessingException {
        ObjectNode root = JsonUtils.newObjectNode();
        root.put("clusterName", this._pinotHelixResourceManager.getHelixClusterName());
        List<TableType> tableTypes = this.getValidTableTypes(tableName, tableTypeStr, this._pinotHelixResourceManager);
        if (tableTypes.isEmpty()) {
            throw new ControllerApplicationException(LOGGER, "Table '" + tableName + "' not found", Response.Status.NOT_FOUND);
        }
        ArrayList<TableDebugInfo> tableDebugInfos = new ArrayList<TableDebugInfo>();
        for (TableType type : tableTypes) {
            tableDebugInfos.add(this.debugTable(this._pinotHelixResourceManager, tableName, type, verbosity));
        }
        return new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(tableDebugInfos);
    }

    private TableDebugInfo debugTable(PinotHelixResourceManager pinotHelixResourceManager, String tableName, TableType tableType, int verbosity) {
        String tableNameWithType = TableNameBuilder.forType((TableType)tableType).tableNameWithType(tableName);
        List<TableDebugInfo.SegmentDebugInfo> segmentDebugInfos = this.debugSegments(pinotHelixResourceManager, tableNameWithType, verbosity);
        List<TableDebugInfo.BrokerDebugInfo> brokerDebugInfos = this.debugBrokers(tableNameWithType, verbosity);
        List<TableDebugInfo.ServerDebugInfo> serverDebugInfos = this.debugServers(pinotHelixResourceManager, tableName, tableType);
        TableDebugInfo.TableSizeSummary tableSizeSummary = this.getTableSize(tableNameWithType);
        TableStatus.IngestionStatus ingestionStatus = this.getIngestionStatus(tableNameWithType, tableType);
        IdealState idealState = this._pinotHelixResourceManager.getTableIdealState(tableNameWithType);
        int numSegments = idealState != null ? idealState.getPartitionSet().size() : 0;
        return new TableDebugInfo(tableNameWithType, ingestionStatus, tableSizeSummary, this._pinotHelixResourceManager.getBrokerInstancesForTable(tableName, tableType).size(), this._pinotHelixResourceManager.getServerInstancesForTable(tableName, tableType).size(), numSegments, segmentDebugInfos, serverDebugInfos, brokerDebugInfos);
    }

    private TableStatus.IngestionStatus getIngestionStatus(String tableNameWithType, TableType tableType) {
        try {
            switch (tableType) {
                case OFFLINE: {
                    return TableIngestionStatusHelper.getOfflineTableIngestionStatus(tableNameWithType, this._pinotHelixResourceManager, this._pinotHelixTaskResourceManager);
                }
                case REALTIME: {
                    return TableIngestionStatusHelper.getRealtimeTableIngestionStatus(tableNameWithType, this._controllerConf.getServerAdminRequestTimeoutSeconds() * 1000, this._executor, this._connectionManager, this._pinotHelixResourceManager);
                }
            }
        }
        catch (Exception e) {
            return TableStatus.IngestionStatus.newIngestionStatus((TableStatus.IngestionState)TableStatus.IngestionState.UNKNOWN, (String)e.getMessage());
        }
        return null;
    }

    private TableDebugInfo.TableSizeSummary getTableSize(String tableNameWithType) {
        TableSizeReader.TableSizeDetails tableSizeDetails;
        TableSizeReader tableSizeReader = new TableSizeReader(this._executor, this._connectionManager, this._controllerMetrics, this._pinotHelixResourceManager);
        try {
            tableSizeDetails = tableSizeReader.getTableSizeDetails(tableNameWithType, this._controllerConf.getServerAdminRequestTimeoutSeconds() * 1000);
        }
        catch (Throwable t) {
            tableSizeDetails = null;
        }
        return tableSizeDetails != null ? new TableDebugInfo.TableSizeSummary(tableSizeDetails.reportedSizeInBytes, tableSizeDetails.estimatedSizeInBytes) : new TableDebugInfo.TableSizeSummary(-1L, -1L);
    }

    private List<TableDebugInfo.SegmentDebugInfo> debugSegments(PinotHelixResourceManager pinotHelixResourceManager, String tableNameWithType, int verbosity) {
        BiMap<String, String> serverToEndpoints;
        ExternalView externalView = pinotHelixResourceManager.getTableExternalView(tableNameWithType);
        IdealState idealState = pinotHelixResourceManager.getTableIdealState(tableNameWithType);
        ArrayList<TableDebugInfo.SegmentDebugInfo> result = new ArrayList<TableDebugInfo.SegmentDebugInfo>();
        if (idealState == null) {
            return result;
        }
        int serverRequestTimeoutMs = this._controllerConf.getServerAdminRequestTimeoutSeconds() * 1000;
        Map<String, List<String>> serverToSegments = this._pinotHelixResourceManager.getServerToSegmentsMap(tableNameWithType);
        try {
            serverToEndpoints = this._pinotHelixResourceManager.getDataInstanceAdminEndpoints(serverToSegments.keySet());
        }
        catch (InvalidConfigException e) {
            throw new WebApplicationException("Caught exception when getting segment debug info for table: " + tableNameWithType);
        }
        Map<String, Map<String, SegmentServerDebugInfo>> segmentsDebugInfoFromServers = this.getSegmentsDebugInfoFromServers(tableNameWithType, serverToEndpoints, serverRequestTimeoutMs);
        for (Map.Entry segmentMapEntry : idealState.getRecord().getMapFields().entrySet()) {
            String segmentName = (String)segmentMapEntry.getKey();
            Map segmentIsMap = (Map)segmentMapEntry.getValue();
            HashMap<String, TableDebugInfo.SegmentState> segmentServerState = new HashMap<String, TableDebugInfo.SegmentState>();
            for (Map.Entry<String, Map<String, SegmentServerDebugInfo>> segmentEntry : segmentsDebugInfoFromServers.entrySet()) {
                String evState;
                String instanceName = segmentEntry.getKey();
                String isState = (String)segmentIsMap.get(instanceName);
                Map evStateMap = externalView != null ? externalView.getStateMap(segmentName) : null;
                String string = evState = evStateMap != null ? (String)evStateMap.get(instanceName) : null;
                if (evState != null) {
                    Map<String, SegmentServerDebugInfo> segmentServerDebugInfoMap = segmentEntry.getValue();
                    SegmentServerDebugInfo segmentServerDebugInfo = segmentServerDebugInfoMap.get(segmentName);
                    if (verbosity <= 0 && (segmentServerDebugInfo == null || !this.segmentHasErrors(segmentServerDebugInfo, evState))) continue;
                    segmentServerState.put(instanceName, new TableDebugInfo.SegmentState(isState, evState, segmentServerDebugInfo.getSegmentSize(), segmentServerDebugInfo.getConsumerInfo(), segmentServerDebugInfo.getErrorInfo()));
                    continue;
                }
                segmentServerState.put(instanceName, new TableDebugInfo.SegmentState(isState, null, null, null, null));
            }
            if (segmentServerState.isEmpty()) continue;
            result.add(new TableDebugInfo.SegmentDebugInfo(segmentName, segmentServerState));
        }
        return result;
    }

    private boolean segmentHasErrors(SegmentServerDebugInfo segmentServerDebugInfo, String externalView) {
        if (externalView.equals("ERROR")) {
            return true;
        }
        SegmentConsumerInfo consumerInfo = segmentServerDebugInfo.getConsumerInfo();
        if (consumerInfo != null && consumerInfo.getConsumerState().equals(CommonConstants.ConsumerState.NOT_CONSUMING.toString())) {
            return true;
        }
        SegmentErrorInfo errorInfo = segmentServerDebugInfo.getErrorInfo();
        return errorInfo != null && (errorInfo.getErrorMessage() != null || errorInfo.getStackTrace() != null);
    }

    private List<TableDebugInfo.BrokerDebugInfo> debugBrokers(String tableNameWithType, int verbosity) {
        ArrayList<TableDebugInfo.BrokerDebugInfo> brokerDebugInfos = new ArrayList<TableDebugInfo.BrokerDebugInfo>();
        HelixDataAccessor helixDataAccessor = this._pinotHelixResourceManager.getHelixZkManager().getHelixDataAccessor();
        IdealState idealState = (IdealState)helixDataAccessor.getProperty(helixDataAccessor.keyBuilder().idealStates("brokerResource"));
        ExternalView externalView = (ExternalView)helixDataAccessor.getProperty(helixDataAccessor.keyBuilder().externalView("brokerResource"));
        for (Map.Entry entry : idealState.getInstanceStateMap(tableNameWithType).entrySet()) {
            String brokerName = (String)entry.getKey();
            String isState = (String)entry.getValue();
            String evState = (String)externalView.getStateMap(tableNameWithType).get(brokerName);
            if (verbosity <= 0 && isState.equals(evState)) continue;
            brokerDebugInfos.add(new TableDebugInfo.BrokerDebugInfo(brokerName, isState, evState));
        }
        return brokerDebugInfos;
    }

    private List<TableDebugInfo.ServerDebugInfo> debugServers(PinotHelixResourceManager pinotHelixResourceManager, String tableName, TableType tableType) {
        HelixDataAccessor accessor = this._pinotHelixResourceManager.getHelixZkManager().getHelixDataAccessor();
        ArrayList<TableDebugInfo.ServerDebugInfo> serverDebugInfos = new ArrayList<TableDebugInfo.ServerDebugInfo>();
        for (String instanceName : pinotHelixResourceManager.getServerInstancesForTable(tableName, tableType)) {
            PropertyKey.Builder keyBuilder = accessor.keyBuilder();
            List sessionIds = accessor.getChildNames(keyBuilder.errors(instanceName));
            if (sessionIds == null || sessionIds.size() == 0) {
                return serverDebugInfos;
            }
            int numErrors = 0;
            String tableNameWithType = TableNameBuilder.forType((TableType)tableType).tableNameWithType(tableName);
            for (String sessionId : sessionIds) {
                List childValues = accessor.getChildValues(keyBuilder.errors(instanceName, sessionId, tableNameWithType), false);
                numErrors += childValues != null ? childValues.size() : 0;
            }
            List messageNames = accessor.getChildNames(accessor.keyBuilder().messages(instanceName));
            int numMessages = messageNames != null ? messageNames.size() : 0;
            serverDebugInfos.add(new TableDebugInfo.ServerDebugInfo(instanceName, numErrors, numMessages));
        }
        return serverDebugInfos;
    }

    private Map<String, Map<String, SegmentServerDebugInfo>> getSegmentsDebugInfoFromServers(String tableNameWithType, BiMap<String, String> serverToEndpoints, int timeoutMs) {
        LOGGER.info("Reading segments debug info from servers: {} for table: {}", (Object)serverToEndpoints.keySet(), (Object)tableNameWithType);
        ArrayList<String> serverUrls = new ArrayList<String>(serverToEndpoints.size());
        BiMap endpointsToServers = serverToEndpoints.inverse();
        for (String endpoint : endpointsToServers.keySet()) {
            String segmentDebugInfoURI = String.format("%s/debug/tables/%s", endpoint, tableNameWithType);
            serverUrls.add(segmentDebugInfoURI);
        }
        CompletionServiceHelper completionServiceHelper = new CompletionServiceHelper(this._executor, this._connectionManager, (BiMap<String, String>)endpointsToServers);
        CompletionServiceHelper.CompletionServiceResponse serviceResponse = completionServiceHelper.doMultiGetRequest(serverUrls, tableNameWithType, false, timeoutMs);
        HashMap<String, Map<String, SegmentServerDebugInfo>> serverToSegmentDebugInfoMap = new HashMap<String, Map<String, SegmentServerDebugInfo>>();
        int failedParses = 0;
        for (Map.Entry<String, String> streamResponse : serviceResponse._httpResponses.entrySet()) {
            try {
                List segmentDebugInfos = (List)JsonUtils.stringToObject((String)streamResponse.getValue(), (TypeReference)new TypeReference<List<SegmentServerDebugInfo>>(){});
                Map segmentsMap = segmentDebugInfos.stream().collect(Collectors.toMap(SegmentServerDebugInfo::getSegmentName, Function.identity()));
                serverToSegmentDebugInfoMap.put(streamResponse.getKey(), segmentsMap);
            }
            catch (IOException e) {
                ++failedParses;
                LOGGER.error("Unable to parse server {} response due to an error: ", (Object)streamResponse.getKey(), (Object)e);
            }
        }
        if (failedParses != 0) {
            LOGGER.warn("Failed to parse {} / {} segment size info responses from servers.", (Object)failedParses, (Object)serverUrls.size());
        }
        return serverToSegmentDebugInfoMap;
    }

    private List<TableType> getValidTableTypes(String tableName, String tableTypeStr, PinotHelixResourceManager pinotHelixResourceManager) {
        TableType tableType = Constants.validateTableType(tableTypeStr);
        ArrayList<TableType> tableTypes = new ArrayList<TableType>();
        if (tableType == null) {
            if (pinotHelixResourceManager.hasOfflineTable(tableName)) {
                tableTypes.add(TableType.OFFLINE);
            }
            if (pinotHelixResourceManager.hasRealtimeTable(tableName)) {
                tableTypes.add(TableType.REALTIME);
            }
        } else {
            String tableNameWithType = TableNameBuilder.forType((TableType)tableType).tableNameWithType(tableName);
            if (pinotHelixResourceManager.hasTable(tableNameWithType)) {
                tableTypes.add(tableType);
            }
        }
        return tableTypes;
    }
}

