/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.upload;

import java.io.File;
import java.net.URI;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.helix.ZNRecord;
import org.apache.pinot.common.metadata.segment.OfflineSegmentZKMetadata;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadataCustomMapModifier;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ControllerMeter;
import org.apache.pinot.common.metrics.ControllerMetrics;
import org.apache.pinot.controller.ControllerConf;
import org.apache.pinot.controller.api.exception.ControllerApplicationException;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.segment.spi.SegmentMetadata;
import org.apache.pinot.spi.filesystem.PinotFS;
import org.apache.pinot.spi.filesystem.PinotFSFactory;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZKOperator.class);
    private final PinotHelixResourceManager _pinotHelixResourceManager;
    private final ControllerConf _controllerConf;
    private final ControllerMetrics _controllerMetrics;

    public ZKOperator(PinotHelixResourceManager pinotHelixResourceManager, ControllerConf controllerConf, ControllerMetrics controllerMetrics) {
        this._pinotHelixResourceManager = pinotHelixResourceManager;
        this._controllerConf = controllerConf;
        this._controllerMetrics = controllerMetrics;
    }

    public void completeSegmentOperations(String tableNameWithType, SegmentMetadata segmentMetadata, URI finalSegmentLocationURI, File currentSegmentLocation, boolean enableParallelPushProtection, HttpHeaders headers, String zkDownloadURI, boolean moveSegmentToFinalLocation, String crypter) throws Exception {
        String segmentName = segmentMetadata.getName();
        ZNRecord segmentMetadataZnRecord = this._pinotHelixResourceManager.getSegmentMetadataZnRecord(tableNameWithType, segmentName);
        if (segmentMetadataZnRecord == null) {
            LOGGER.info("Adding new segment {} from table {}", (Object)segmentName, (Object)tableNameWithType);
            this.processNewSegment(segmentMetadata, finalSegmentLocationURI, currentSegmentLocation, zkDownloadURI, crypter, tableNameWithType, segmentName, moveSegmentToFinalLocation);
            return;
        }
        if (TableNameBuilder.isRealtimeTableResource((String)tableNameWithType)) {
            throw new ControllerApplicationException(LOGGER, "Refresh existing segment " + segmentName + " for realtime table " + tableNameWithType + " is not yet supported ", Response.Status.NOT_IMPLEMENTED);
        }
        LOGGER.info("Segment {} from table {} already exists, refreshing if necessary", (Object)segmentName, (Object)tableNameWithType);
        this.processExistingSegment(segmentMetadata, finalSegmentLocationURI, currentSegmentLocation, enableParallelPushProtection, headers, zkDownloadURI, crypter, tableNameWithType, segmentName, segmentMetadataZnRecord, moveSegmentToFinalLocation);
    }

    private void processExistingSegment(SegmentMetadata segmentMetadata, URI finalSegmentLocationURI, File currentSegmentLocation, boolean enableParallelPushProtection, HttpHeaders headers, String zkDownloadURI, String crypter, String tableNameWithType, String segmentName, ZNRecord znRecord, boolean moveSegmentToFinalLocation) throws Exception {
        OfflineSegmentZKMetadata existingSegmentZKMetadata = new OfflineSegmentZKMetadata(znRecord);
        long existingCrc = existingSegmentZKMetadata.getCrc();
        this.checkCRC(headers, tableNameWithType, segmentName, existingCrc);
        if (enableParallelPushProtection) {
            long segmentUploadStartTime = existingSegmentZKMetadata.getSegmentUploadStartTime();
            if (segmentUploadStartTime > 0L) {
                if (System.currentTimeMillis() - segmentUploadStartTime > this._controllerConf.getSegmentUploadTimeoutInMillis()) {
                    LOGGER.error("Segment: {} of table: {} was not properly uploaded, replacing it", (Object)segmentName, (Object)tableNameWithType);
                    this._controllerMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ControllerMeter.NUMBER_SEGMENT_UPLOAD_TIMEOUT_EXCEEDED, 1L);
                } else {
                    throw new ControllerApplicationException(LOGGER, "Another segment upload is in progress for segment: " + segmentName + " of table: " + tableNameWithType + ", retry later", Response.Status.CONFLICT);
                }
            }
            existingSegmentZKMetadata.setSegmentUploadStartTime(System.currentTimeMillis());
            if (!this._pinotHelixResourceManager.updateZkMetadata(tableNameWithType, existingSegmentZKMetadata, znRecord.getVersion())) {
                throw new ControllerApplicationException(LOGGER, "Failed to lock the segment: " + segmentName + " of table: " + tableNameWithType + ", retry later", Response.Status.CONFLICT);
            }
        }
        existingSegmentZKMetadata.setSegmentUploadStartTime(-1L);
        try {
            String segmentZKMetadataCustomMapModifierStr = headers.getHeaderString("Pinot-SegmentZKMetadataCustomMapModifier");
            SegmentZKMetadataCustomMapModifier segmentZKMetadataCustomMapModifier = segmentZKMetadataCustomMapModifierStr != null ? new SegmentZKMetadataCustomMapModifier(segmentZKMetadataCustomMapModifierStr) : new SegmentZKMetadataCustomMapModifier(SegmentZKMetadataCustomMapModifier.ModifyMode.REPLACE, null);
            existingSegmentZKMetadata.setCustomMap(segmentZKMetadataCustomMapModifier.modifyMap(existingSegmentZKMetadata.getCustomMap()));
            long newCrc = Long.valueOf(segmentMetadata.getCrc());
            if (newCrc == existingCrc) {
                LOGGER.info("New segment crc '{}' is the same as existing segment crc for segment '{}'. Updating ZK metadata without refreshing the segment.", (Object)newCrc, (Object)segmentName);
                existingSegmentZKMetadata.setCreationTime(segmentMetadata.getIndexCreationTime());
                existingSegmentZKMetadata.setRefreshTime(System.currentTimeMillis());
                if (!this._pinotHelixResourceManager.updateZkMetadata(tableNameWithType, existingSegmentZKMetadata)) {
                    throw new RuntimeException("Failed to update ZK metadata for segment: " + segmentName + " of table: " + tableNameWithType);
                }
            } else {
                LOGGER.info("New segment crc {} is different than the existing segment crc {}. Updating ZK metadata and refreshing segment {}", new Object[]{newCrc, existingCrc, segmentName});
                if (moveSegmentToFinalLocation) {
                    this.moveSegmentToPermanentDirectory(currentSegmentLocation, finalSegmentLocationURI);
                    LOGGER.info("Moved segment {} from temp location {} to {}", new Object[]{segmentName, currentSegmentLocation.getAbsolutePath(), finalSegmentLocationURI.getPath()});
                } else {
                    LOGGER.info("Skipping segment move, keeping segment {} from table {} at {}", new Object[]{segmentName, tableNameWithType, zkDownloadURI});
                }
                this._pinotHelixResourceManager.refreshSegment(tableNameWithType, segmentMetadata, existingSegmentZKMetadata, zkDownloadURI, crypter);
            }
        }
        catch (Exception e) {
            if (!this._pinotHelixResourceManager.updateZkMetadata(tableNameWithType, existingSegmentZKMetadata)) {
                LOGGER.error("Failed to update ZK metadata for segment: {} of table: {}", (Object)segmentName, (Object)tableNameWithType);
            }
            throw e;
        }
    }

    private void checkCRC(HttpHeaders headers, String offlineTableName, String segmentName, long existingCrc) {
        String expectedCrcStr = headers.getHeaderString("If-Match");
        if (expectedCrcStr != null) {
            long expectedCrc;
            try {
                expectedCrc = Long.parseLong(expectedCrcStr);
            }
            catch (NumberFormatException e) {
                throw new ControllerApplicationException(LOGGER, "Caught exception for segment: " + segmentName + " of table: " + offlineTableName + " while parsing IF-MATCH CRC: \"" + expectedCrcStr + "\"", Response.Status.PRECONDITION_FAILED);
            }
            if (expectedCrc != existingCrc) {
                throw new ControllerApplicationException(LOGGER, "For segment: " + segmentName + " of table: " + offlineTableName + ", expected CRC: " + expectedCrc + " does not match existing CRC: " + existingCrc, Response.Status.PRECONDITION_FAILED);
            }
        }
    }

    private void processNewSegment(SegmentMetadata segmentMetadata, URI finalSegmentLocationURI, File currentSegmentLocation, String zkDownloadURI, String crypter, String tableNameWithType, String segmentName, boolean moveSegmentToFinalLocation) {
        if (moveSegmentToFinalLocation) {
            try {
                this.moveSegmentToPermanentDirectory(currentSegmentLocation, finalSegmentLocationURI);
                LOGGER.info("Moved segment {} from temp location {} to {}", new Object[]{segmentName, currentSegmentLocation.getAbsolutePath(), finalSegmentLocationURI.getPath()});
            }
            catch (Exception e) {
                LOGGER.error("Could not move segment {} from table {} to permanent directory", new Object[]{segmentName, tableNameWithType, e});
                throw new RuntimeException(e);
            }
        } else {
            LOGGER.info("Skipping segment move, keeping segment {} from table {} at {}", new Object[]{segmentName, tableNameWithType, zkDownloadURI});
        }
        this._pinotHelixResourceManager.addNewSegment(tableNameWithType, segmentMetadata, zkDownloadURI, crypter);
    }

    private void moveSegmentToPermanentDirectory(File currentSegmentLocation, URI finalSegmentLocationURI) throws Exception {
        PinotFS pinotFS = PinotFSFactory.create((String)finalSegmentLocationURI.getScheme());
        LOGGER.info("Copying segment from {} to {}", (Object)currentSegmentLocation.getAbsolutePath(), (Object)finalSegmentLocationURI.toString());
        pinotFS.copyFromLocalFile(currentSegmentLocation, finalSegmentLocationURI);
    }
}

