/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.common.utils.StringUtil;
import org.apache.pinot.common.utils.URIUtils;
import org.apache.pinot.spi.config.table.assignment.InstancePartitionsType;

public class ControllerRequestURLBuilder {
    private final String _baseUrl;

    private ControllerRequestURLBuilder(String baseUrl) {
        this._baseUrl = StringUtils.chomp((String)baseUrl, (String)"/");
    }

    public static ControllerRequestURLBuilder baseUrl(String baseUrl) {
        return new ControllerRequestURLBuilder(baseUrl);
    }

    public String forDataFileUpload() {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "segments"});
    }

    public String forInstanceCreate() {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "instances"});
    }

    public String forInstanceState(String instanceName) {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "instances", instanceName, "state"});
    }

    public String forInstance(String instanceName) {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "instances", instanceName});
    }

    public String forInstanceUpdateTags(String instanceName, List<String> tags) {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "instances", instanceName, "updateTags?tags=" + StringUtils.join(tags, (String)",")});
    }

    public String forInstanceList() {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "instances"});
    }

    public String forTablesFromTenant(String tenantName) {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tenants", tenantName, "tables"});
    }

    public String forTenantCreate() {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tenants"});
    }

    public String forTenantGet() {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tenants"});
    }

    public String forTenantGet(String tenantName) {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tenants", tenantName});
    }

    public String forBrokerTenantGet(String tenantName) {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tenants", tenantName, "?type=broker"});
    }

    public String forServerTenantGet(String tenantName) {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tenants", tenantName, "?type=server"});
    }

    public String forBrokerTenantDelete(String tenantName) {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tenants", tenantName, "?type=broker"});
    }

    public String forServerTenantDelete(String tenantName) {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tenants", tenantName, "?type=server"});
    }

    public String forBrokersGet(String state) {
        if (state == null) {
            return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "brokers"});
        }
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "brokers", "?state=" + state});
    }

    public String forBrokerTenantsGet(String state) {
        if (state == null) {
            return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "brokers", "tenants"});
        }
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "brokers", "tenants", "?state=" + state});
    }

    public String forBrokerTenantGet(String tenant, String state) {
        if (state == null) {
            return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "brokers", "tenants", tenant});
        }
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "brokers", "tenants", tenant, "?state=" + state});
    }

    public String forBrokerTablesGet(String state) {
        if (state == null) {
            return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "brokers", "tables"});
        }
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "brokers", "tables", "?state=" + state});
    }

    public String forBrokerTableGet(String table, String tableType, String state) {
        StringBuilder params = new StringBuilder();
        if (tableType != null) {
            params.append("?type=" + tableType);
        }
        if (state != null) {
            if (params.length() > 0) {
                params.append("&");
            }
            params.append("?state=" + state);
        }
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "brokers", "tables", table, params.toString()});
    }

    public String forTableCreate() {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tables"});
    }

    public String forUpdateTableConfig(String tableName) {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tables", tableName});
    }

    public String forTableRebalance(String tableName, String tableType) {
        return this.forTableRebalance(tableName, tableType, false, false, false, false, 1);
    }

    public String forTableRebalance(String tableName, String tableType, boolean dryRun, boolean reassignInstances, boolean includeConsuming, boolean downtime, int minAvailableReplicas) {
        StringBuilder stringBuilder = new StringBuilder(StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tables", tableName, "rebalance?type=" + tableType}));
        if (dryRun) {
            stringBuilder.append("&dryRun=").append(dryRun);
        }
        if (reassignInstances) {
            stringBuilder.append("&reassignInstances=").append(reassignInstances);
        }
        if (includeConsuming) {
            stringBuilder.append("&includeConsuming=").append(includeConsuming);
        }
        if (downtime) {
            stringBuilder.append("&downtime=").append(downtime);
        }
        if (minAvailableReplicas != 1) {
            stringBuilder.append("&minAvailableReplicas=").append(minAvailableReplicas);
        }
        return stringBuilder.toString();
    }

    public String forTableReload(String tableName, String tableType) {
        String query = "reload?type=" + tableType;
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tables", tableName, "segments", query});
    }

    public String forTableUpdateIndexingConfigs(String tableName) {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tables", tableName, "indexingConfigs"});
    }

    public String forTableGetServerInstances(String tableName) {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tables", tableName, "instances?type=server"});
    }

    public String forTableGetBrokerInstances(String tableName) {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tables", tableName, "instances?type=broker"});
    }

    public String forTableGet(String tableName) {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tables", tableName});
    }

    public String forTableDelete(String tableName) {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tables", tableName});
    }

    public String forTableView(String tableName, String view, @Nullable String tableType) {
        Object url = StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tables", tableName, view});
        if (tableType != null) {
            url = (String)url + "?tableType=" + tableType;
        }
        return url;
    }

    public String forTableSchemaGet(String tableName) {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tables", tableName, "schema"});
    }

    public String forTableExternalView(String tableName) {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tables", tableName, "externalview"});
    }

    public String forSchemaCreate() {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "schemas"});
    }

    public String forSchemaUpdate(String schemaName) {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "schemas", schemaName});
    }

    public String forSchemaGet(String schemaName) {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "schemas", schemaName});
    }

    public String forTableConfigsCreate() {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tableConfigs"});
    }

    public String forTableConfigsGet(String configName) {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tableConfigs", configName});
    }

    public String forTableConfigsList() {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tableConfigs"});
    }

    public String forTableConfigsUpdate(String configName) {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tableConfigs", configName});
    }

    public String forTableConfigsDelete(String configName) {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tableConfigs", configName});
    }

    public String forTableConfigsValidate() {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tableConfigs", "validate"});
    }

    public String forSegmentDownload(String tableName, String segmentName) {
        return URIUtils.constructDownloadUrl((String)this._baseUrl, (String)tableName, (String)segmentName);
    }

    public String forSegmentDelete(String tableName, String segmentName) {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "segments", tableName, segmentName});
    }

    public String forSegmentDeleteAPI(String tableName, String segmentName, String tableType) {
        return URIUtils.getPath((String)this._baseUrl, (String[])new String[]{"segments", tableName, URIUtils.encode((String)segmentName)}) + "?type=" + tableType;
    }

    public String forSegmentDeleteAllAPI(String tableName, String tableType) {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "segments", tableName + "?type=" + tableType});
    }

    public String forListAllSegments(String tableName) {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tables", tableName, "segments"});
    }

    public String forSegmentMetadata(String tableName, String segmentName) {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "segments", tableName, segmentName, "metadata"});
    }

    public String forListAllCrcInformationForTable(String tableName) {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tables", tableName, "segments", "crc"});
    }

    public String forDeleteTableWithType(String tableName, String tableType) {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tables", tableName + "?type=" + tableType});
    }

    public String forSegmentListAPIWithTableType(String tableName, String tableType) {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "segments", tableName + "?type=" + tableType});
    }

    public String forSegmentListAPI(String tableName) {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "segments", tableName});
    }

    public String forInstancePartitions(String tableName, @Nullable InstancePartitionsType instancePartitionsType) {
        Object url = StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tables", tableName, "instancePartitions"});
        if (instancePartitionsType != null) {
            url = (String)url + "?type=" + instancePartitionsType;
        }
        return url;
    }

    public String forInstanceAssign(String tableName, @Nullable InstancePartitionsType instancePartitionsType, boolean dryRun) {
        Object url = StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tables", tableName, "assignInstances"});
        if (instancePartitionsType != null) {
            url = (String)url + "?type=" + instancePartitionsType;
            if (dryRun) {
                url = (String)url + "&dryRun=true";
            }
        } else if (dryRun) {
            url = (String)url + "?dryRun=true";
        }
        return url;
    }

    public String forInstanceReplace(String tableName, @Nullable InstancePartitionsType instancePartitionsType, String oldInstanceId, String newInstanceId) {
        String url = StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tables", tableName, "replaceInstance"}) + "?oldInstanceId=" + oldInstanceId + "&newInstanceId=" + newInstanceId;
        if (instancePartitionsType != null) {
            url = url + "&type=" + instancePartitionsType;
        }
        return url;
    }

    public String forIngestFromFile(String tableNameWithType, String batchConfigMapStr) throws UnsupportedEncodingException {
        return String.format("%s?tableNameWithType=%s&batchConfigMapStr=%s", StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "ingestFromFile"}), tableNameWithType, URLEncoder.encode(batchConfigMapStr, StandardCharsets.UTF_8.toString()));
    }

    public String forIngestFromFile(String tableNameWithType, Map<String, String> batchConfigMap) throws UnsupportedEncodingException {
        String batchConfigMapStr = batchConfigMap.entrySet().stream().map(e -> String.format("\"%s\":\"%s\"", e.getKey(), e.getValue())).collect(Collectors.joining(",", "{", "}"));
        return this.forIngestFromFile(tableNameWithType, batchConfigMapStr);
    }

    public String forIngestFromURI(String tableNameWithType, String batchConfigMapStr, String sourceURIStr) throws UnsupportedEncodingException {
        return String.format("%s?tableNameWithType=%s&batchConfigMapStr=%s&sourceURIStr=%s", StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "ingestFromURI"}), tableNameWithType, URLEncoder.encode(batchConfigMapStr, StandardCharsets.UTF_8.toString()), URLEncoder.encode(sourceURIStr, StandardCharsets.UTF_8.toString()));
    }

    public String forIngestFromURI(String tableNameWithType, Map<String, String> batchConfigMap, String sourceURIStr) throws UnsupportedEncodingException {
        String batchConfigMapStr = batchConfigMap.entrySet().stream().map(e -> String.format("\"%s\":\"%s\"", e.getKey(), e.getValue())).collect(Collectors.joining(",", "{", "}"));
        return this.forIngestFromURI(tableNameWithType, batchConfigMapStr, sourceURIStr);
    }

    public String forClusterConfigs() {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "cluster/configs"});
    }

    public String forAppConfigs() {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "appconfigs"});
    }
}

