/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.helix.HelixManager;
import org.apache.helix.ZNRecord;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.builder.CustomModeISBuilder;
import org.apache.helix.store.zk.ZkHelixPropertyStore;
import org.apache.pinot.common.metadata.ZKMetadataProvider;
import org.apache.pinot.common.metadata.instance.InstanceZKMetadata;
import org.apache.pinot.common.utils.StringUtil;
import org.apache.pinot.common.utils.config.TagNameUtils;
import org.apache.pinot.common.utils.helix.HelixHelper;
import org.apache.pinot.controller.api.exception.InvalidTableConfigException;
import org.apache.pinot.controller.helix.core.realtime.PinotLLCRealtimeSegmentManager;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.TenantConfig;
import org.apache.pinot.spi.stream.PartitionGroupConsumptionStatus;
import org.apache.pinot.spi.stream.PartitionGroupMetadata;
import org.apache.pinot.spi.stream.PartitionGroupMetadataFetcher;
import org.apache.pinot.spi.stream.StreamConfig;
import org.apache.pinot.spi.utils.IngestionConfigUtils;
import org.apache.pinot.spi.utils.retry.RetryPolicies;
import org.apache.pinot.spi.utils.retry.RetryPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PinotTableIdealStateBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(PinotTableIdealStateBuilder.class);
    public static final String ONLINE = "ONLINE";
    public static final String OFFLINE = "OFFLINE";
    private static final RetryPolicy DEFAULT_IDEALSTATE_UPDATE_RETRY_POLICY = RetryPolicies.randomDelayRetryPolicy((int)3, (long)100L, (long)200L);

    public static IdealState buildEmptyIdealStateFor(String tableName, int numCopies, boolean enableBatchMessageMode) {
        CustomModeISBuilder customModeIdealStateBuilder = new CustomModeISBuilder(tableName);
        int replicas = numCopies;
        customModeIdealStateBuilder.setStateModel("SegmentOnlineOfflineStateModel").setNumPartitions(0).setNumReplica(replicas).setMaxPartitionsPerNode(1);
        IdealState idealState = customModeIdealStateBuilder.build();
        idealState.setInstanceGroupTag(tableName);
        idealState.setBatchMessageMode(enableBatchMessageMode);
        return idealState;
    }

    public static IdealState addNewRealtimeSegmentToIdealState(String segmentId, IdealState state, String instanceName) {
        state.setPartitionState(segmentId, instanceName, ONLINE);
        state.setNumPartitions(state.getNumPartitions() + 1);
        return state;
    }

    public static IdealState buildInitialHighLevelRealtimeIdealStateFor(String realtimeTableName, TableConfig realtimeTableConfig, HelixManager helixManager, ZkHelixPropertyStore<ZNRecord> zkHelixPropertyStore, boolean enableBatchMessageMode) {
        List realtimeInstances = HelixHelper.getInstancesWithTag((HelixManager)helixManager, (String)TagNameUtils.extractConsumingServerTag((TenantConfig)realtimeTableConfig.getTenantConfig()));
        IdealState idealState = PinotTableIdealStateBuilder.buildEmptyRealtimeIdealStateFor(realtimeTableName, 1, enableBatchMessageMode);
        if (realtimeInstances.size() % Integer.parseInt(realtimeTableConfig.getValidationConfig().getReplication()) != 0) {
            throw new RuntimeException("Number of instance in current tenant should be an integer multiples of the number of replications");
        }
        PinotTableIdealStateBuilder.setupInstanceConfigForHighLevelConsumer(realtimeTableName, realtimeInstances.size(), Integer.parseInt(realtimeTableConfig.getValidationConfig().getReplication()), IngestionConfigUtils.getStreamConfigMap((TableConfig)realtimeTableConfig), zkHelixPropertyStore, realtimeInstances);
        return idealState;
    }

    public static void buildLowLevelRealtimeIdealStateFor(PinotLLCRealtimeSegmentManager pinotLLCRealtimeSegmentManager, String realtimeTableName, TableConfig realtimeTableConfig, IdealState idealState, boolean enableBatchMessageMode) {
        int nReplicas;
        String replicasPerPartitionStr = realtimeTableConfig.getValidationConfig().getReplicasPerPartition();
        if (replicasPerPartitionStr == null || replicasPerPartitionStr.isEmpty()) {
            throw new RuntimeException("Null or empty value for replicasPerPartition, expected a number");
        }
        try {
            nReplicas = Integer.valueOf(replicasPerPartitionStr);
        }
        catch (NumberFormatException e) {
            throw new InvalidTableConfigException("Invalid value for replicasPerPartition, expected a number: " + replicasPerPartitionStr, e);
        }
        if (idealState == null) {
            idealState = PinotTableIdealStateBuilder.buildEmptyRealtimeIdealStateFor(realtimeTableName, nReplicas, enableBatchMessageMode);
        }
        pinotLLCRealtimeSegmentManager.setUpNewTable(realtimeTableConfig, idealState);
    }

    public static List<PartitionGroupMetadata> getPartitionGroupMetadataList(StreamConfig streamConfig, List<PartitionGroupConsumptionStatus> partitionGroupConsumptionStatusList) {
        PartitionGroupMetadataFetcher partitionGroupMetadataFetcher = new PartitionGroupMetadataFetcher(streamConfig, partitionGroupConsumptionStatusList);
        try {
            DEFAULT_IDEALSTATE_UPDATE_RETRY_POLICY.attempt((Callable)partitionGroupMetadataFetcher);
            return partitionGroupMetadataFetcher.getPartitionGroupMetadataList();
        }
        catch (Exception e) {
            Exception fetcherException = partitionGroupMetadataFetcher.getException();
            LOGGER.error("Could not get PartitionGroupMetadata for topic: {} of table: {}", new Object[]{streamConfig.getTopicName(), streamConfig.getTableNameWithType(), fetcherException});
            throw new RuntimeException(fetcherException);
        }
    }

    public static IdealState buildEmptyRealtimeIdealStateFor(String realtimeTableName, int replicaCount, boolean enableBatchMessageMode) {
        CustomModeISBuilder customModeIdealStateBuilder = new CustomModeISBuilder(realtimeTableName);
        customModeIdealStateBuilder.setStateModel("SegmentOnlineOfflineStateModel").setNumPartitions(0).setNumReplica(replicaCount).setMaxPartitionsPerNode(1);
        IdealState idealState = customModeIdealStateBuilder.build();
        idealState.setInstanceGroupTag(realtimeTableName);
        idealState.setBatchMessageMode(enableBatchMessageMode);
        return idealState;
    }

    private static void setupInstanceConfigForHighLevelConsumer(String realtimeTableName, int numDataInstances, int numDataReplicas, Map<String, String> streamConfig, ZkHelixPropertyStore<ZNRecord> zkHelixPropertyStore, List<String> instanceList) {
        int numInstancesPerReplica = numDataInstances / numDataReplicas;
        int partitionId = 0;
        int replicaId = 0;
        String groupId = PinotTableIdealStateBuilder.getGroupIdFromRealtimeDataTable(realtimeTableName, streamConfig);
        for (int i = 0; i < numInstancesPerReplica * numDataReplicas; ++i) {
            String instance = instanceList.get(i);
            InstanceZKMetadata instanceZKMetadata = ZKMetadataProvider.getInstanceZKMetadata(zkHelixPropertyStore, (String)instance);
            if (instanceZKMetadata == null) {
                instanceZKMetadata = new InstanceZKMetadata();
                String[] instanceConfigs = instance.split("_");
                assert (instanceConfigs.length == 3);
                instanceZKMetadata.setInstanceType(instanceConfigs[0]);
                instanceZKMetadata.setInstanceName(instanceConfigs[1]);
                instanceZKMetadata.setInstancePort(Integer.parseInt(instanceConfigs[2]));
            }
            instanceZKMetadata.setGroupId(realtimeTableName, groupId + "_" + replicaId);
            instanceZKMetadata.setPartition(realtimeTableName, Integer.toString(partitionId));
            partitionId = (partitionId + 1) % numInstancesPerReplica;
            if (partitionId == 0) {
                ++replicaId;
            }
            ZKMetadataProvider.setInstanceZKMetadata(zkHelixPropertyStore, (InstanceZKMetadata)instanceZKMetadata);
        }
    }

    private static String getGroupIdFromRealtimeDataTable(String realtimeTableName, Map<String, String> streamConfigMap) {
        String groupId = StringUtil.join((String)"_", (String[])new String[]{realtimeTableName, "" + System.currentTimeMillis()});
        StreamConfig streamConfig = new StreamConfig(realtimeTableName, streamConfigMap);
        String streamConfigGroupId = streamConfig.getGroupId();
        if (streamConfigGroupId != null && !streamConfigGroupId.isEmpty()) {
            groupId = streamConfigGroupId;
        }
        return groupId;
    }
}

