/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.assignment.instance;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.helix.model.InstanceConfig;
import org.apache.pinot.controller.helix.core.assignment.instance.InstanceConstraintApplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashBasedRotateInstanceConstraintApplier
implements InstanceConstraintApplier {
    private static final Logger LOGGER = LoggerFactory.getLogger(HashBasedRotateInstanceConstraintApplier.class);
    private final String _tableNameWithType;

    public HashBasedRotateInstanceConstraintApplier(String tableNameWithType) {
        this._tableNameWithType = tableNameWithType;
    }

    @Override
    public Map<Integer, List<InstanceConfig>> applyConstraint(Map<Integer, List<InstanceConfig>> poolToInstanceConfigsMap) {
        int tableNameHash = Math.abs(this._tableNameWithType.hashCode());
        LOGGER.info("Rotating instances for table: {} with hash: {}", (Object)this._tableNameWithType, (Object)tableNameHash);
        for (Map.Entry<Integer, List<InstanceConfig>> entry : poolToInstanceConfigsMap.entrySet()) {
            List<InstanceConfig> instanceConfigs = entry.getValue();
            int numInstanceConfigs = instanceConfigs.size();
            Preconditions.checkState((numInstanceConfigs > 0 ? 1 : 0) != 0, (String)"No instance left in pool: %s", (Object)entry.getKey());
            Collections.rotate(instanceConfigs, -(tableNameHash % numInstanceConfigs));
        }
        return poolToInstanceConfigsMap;
    }
}

