/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.assignment.segment;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.configuration.Configuration;
import org.apache.helix.HelixManager;
import org.apache.helix.store.zk.ZkHelixPropertyStore;
import org.apache.pinot.common.assignment.InstancePartitions;
import org.apache.pinot.common.metadata.ZKMetadataProvider;
import org.apache.pinot.common.metadata.segment.OfflineSegmentZKMetadata;
import org.apache.pinot.common.tier.Tier;
import org.apache.pinot.controller.helix.core.assignment.segment.SegmentAssignment;
import org.apache.pinot.controller.helix.core.assignment.segment.SegmentAssignmentUtils;
import org.apache.pinot.segment.spi.partition.metadata.ColumnPartitionMetadata;
import org.apache.pinot.spi.config.table.ReplicaGroupStrategyConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.assignment.InstancePartitionsType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OfflineSegmentAssignment
implements SegmentAssignment {
    private static final Logger LOGGER = LoggerFactory.getLogger(OfflineSegmentAssignment.class);
    private HelixManager _helixManager;
    private String _offlineTableName;
    private int _replication;
    private String _partitionColumn;

    @Override
    public void init(HelixManager helixManager, TableConfig tableConfig) {
        this._helixManager = helixManager;
        this._offlineTableName = tableConfig.getTableName();
        this._replication = tableConfig.getValidationConfig().getReplicationNumber();
        ReplicaGroupStrategyConfig replicaGroupStrategyConfig = tableConfig.getValidationConfig().getReplicaGroupStrategyConfig();
        String string = this._partitionColumn = replicaGroupStrategyConfig != null ? replicaGroupStrategyConfig.getPartitionColumn() : null;
        if (this._partitionColumn == null) {
            LOGGER.info("Initialized OfflineSegmentAssignment with replication: {} without partition column for table: {} ", (Object)this._replication, (Object)this._offlineTableName);
        } else {
            LOGGER.info("Initialized OfflineSegmentAssignment with replication: {} and partition column: {} for table: {}", new Object[]{this._replication, this._partitionColumn, this._offlineTableName});
        }
    }

    @Override
    public List<String> assignSegment(String segmentName, Map<String, Map<String, String>> currentAssignment, Map<InstancePartitionsType, InstancePartitions> instancePartitionsMap) {
        InstancePartitions instancePartitions = instancePartitionsMap.get(InstancePartitionsType.OFFLINE);
        Preconditions.checkState((instancePartitions != null ? 1 : 0) != 0, (String)"Failed to find OFFLINE instance partitions for table: %s", (Object)this._offlineTableName);
        LOGGER.info("Assigning segment: {} with instance partitions: {} for table: {}", new Object[]{segmentName, instancePartitions, this._offlineTableName});
        this.checkReplication(instancePartitions);
        List<String> instancesAssigned = this.assignSegment(segmentName, currentAssignment, instancePartitions);
        LOGGER.info("Assigned segment: {} to instances: {} for table: {}", new Object[]{segmentName, instancesAssigned, this._offlineTableName});
        return instancesAssigned;
    }

    private void checkReplication(InstancePartitions instancePartitions) {
        int numReplicaGroups = instancePartitions.getNumReplicaGroups();
        if (numReplicaGroups != 1 && numReplicaGroups != this._replication) {
            LOGGER.warn("Number of replica-groups in instance partitions {}: {} does not match replication in table config: {} for table: {}, use: {}", new Object[]{instancePartitions.getInstancePartitionsName(), numReplicaGroups, this._replication, this._offlineTableName, numReplicaGroups});
        }
    }

    private List<String> assignSegment(String segmentName, Map<String, Map<String, String>> currentAssignment, InstancePartitions instancePartitions) {
        int partitionId;
        int numReplicaGroups = instancePartitions.getNumReplicaGroups();
        if (numReplicaGroups == 1) {
            return SegmentAssignmentUtils.assignSegmentWithoutReplicaGroup(currentAssignment, instancePartitions, this._replication);
        }
        if (this._partitionColumn == null) {
            partitionId = 0;
        } else {
            OfflineSegmentZKMetadata segmentZKMetadata = ZKMetadataProvider.getOfflineSegmentZKMetadata((ZkHelixPropertyStore)this._helixManager.getHelixPropertyStore(), (String)this._offlineTableName, (String)segmentName);
            Preconditions.checkState((segmentZKMetadata != null ? 1 : 0) != 0, (String)"Failed to find segment ZK metadata for segment: %s of table: %s", (Object)segmentName, (Object)this._offlineTableName);
            int segmentPartitionId = this.getPartitionId(segmentZKMetadata);
            int numPartitions = instancePartitions.getNumPartitions();
            partitionId = segmentPartitionId % numPartitions;
        }
        return SegmentAssignmentUtils.assignSegmentWithReplicaGroup(currentAssignment, instancePartitions, partitionId);
    }

    @Override
    public Map<String, Map<String, String>> rebalanceTable(Map<String, Map<String, String>> currentAssignment, Map<InstancePartitionsType, InstancePartitions> instancePartitionsMap, @Nullable List<Tier> sortedTiers, @Nullable Map<String, InstancePartitions> tierInstancePartitionsMap, Configuration config) {
        InstancePartitions offlineInstancePartitions = instancePartitionsMap.get(InstancePartitionsType.OFFLINE);
        Preconditions.checkState((offlineInstancePartitions != null ? 1 : 0) != 0, (String)"Failed to find OFFLINE instance partitions for table: %s", (Object)this._offlineTableName);
        boolean bootstrap = config.getBoolean("bootstrap", false);
        Map<String, Map<String, String>> nonTierAssignment = currentAssignment;
        ArrayList<Map<String, Map<String, String>>> newTierAssignments = null;
        if (sortedTiers != null) {
            Preconditions.checkState((tierInstancePartitionsMap != null ? 1 : 0) != 0, (Object)"Tier to instancePartitions map is null");
            LOGGER.info("Rebalancing tiers: {} for table: {} with bootstrap: {}", new Object[]{tierInstancePartitionsMap.keySet(), this._offlineTableName, bootstrap});
            SegmentAssignmentUtils.TierSegmentAssignment tierSegmentAssignment = new SegmentAssignmentUtils.TierSegmentAssignment(this._offlineTableName, sortedTiers, currentAssignment);
            Map<String, Map<String, Map<String, String>>> tierNameToSegmentAssignmentMap = tierSegmentAssignment.getTierNameToSegmentAssignmentMap();
            newTierAssignments = new ArrayList<Map<String, Map<String, String>>>(tierNameToSegmentAssignmentMap.size());
            for (Map.Entry<String, Map<String, Map<String, String>>> entry : tierNameToSegmentAssignmentMap.entrySet()) {
                String tierName = entry.getKey();
                Map<String, Map<String, String>> tierCurrentAssignment = entry.getValue();
                InstancePartitions tierInstancePartitions = tierInstancePartitionsMap.get(tierName);
                Preconditions.checkNotNull((Object)tierInstancePartitions, (String)"Failed to find instance partitions for tier: %s of table: %s", (Object)tierName, (Object)this._offlineTableName);
                this.checkReplication(tierInstancePartitions);
                LOGGER.info("Rebalancing tier: {} for table: {} with bootstrap: {}, instance partitions: {}", new Object[]{tierName, this._offlineTableName, bootstrap, tierInstancePartitions});
                newTierAssignments.add(this.reassignSegments(tierName, tierCurrentAssignment, tierInstancePartitions, bootstrap));
            }
            nonTierAssignment = tierSegmentAssignment.getNonTierSegmentAssignment();
        }
        LOGGER.info("Rebalancing table: {} with instance partitions: {}, bootstrap: {}", new Object[]{this._offlineTableName, offlineInstancePartitions, bootstrap});
        this.checkReplication(offlineInstancePartitions);
        Map<String, Map<String, String>> newAssignment = this.reassignSegments(InstancePartitionsType.OFFLINE.toString(), nonTierAssignment, offlineInstancePartitions, bootstrap);
        if (CollectionUtils.isNotEmpty(newTierAssignments)) {
            newTierAssignments.forEach(newAssignment::putAll);
        }
        LOGGER.info("Rebalanced table: {}, number of segments to be moved to each instance: {}", (Object)this._offlineTableName, SegmentAssignmentUtils.getNumSegmentsToBeMovedPerInstance(currentAssignment, newAssignment));
        return newAssignment;
    }

    private Map<String, Map<String, String>> reassignSegments(String instancePartitionType, Map<String, Map<String, String>> currentAssignment, InstancePartitions instancePartitions, boolean bootstrap) {
        TreeMap<String, Map<String, String>> newAssignment;
        if (bootstrap) {
            LOGGER.info("Bootstrapping segment assignment for {} segments of table: {}", (Object)instancePartitionType, (Object)this._offlineTableName);
            newAssignment = new TreeMap();
            for (String segment : currentAssignment.keySet()) {
                List<String> assignedInstances = this.assignSegment(segment, newAssignment, instancePartitions);
                newAssignment.put(segment, SegmentAssignmentUtils.getInstanceStateMap(assignedInstances, "ONLINE"));
            }
        } else {
            int numReplicaGroups = instancePartitions.getNumReplicaGroups();
            if (numReplicaGroups == 1) {
                List<String> instances = SegmentAssignmentUtils.getInstancesForNonReplicaGroupBasedAssignment(instancePartitions, this._replication);
                newAssignment = SegmentAssignmentUtils.rebalanceTableWithHelixAutoRebalanceStrategy(currentAssignment, instances, this._replication);
            } else if (this._partitionColumn == null) {
                ArrayList<String> segments = new ArrayList<String>(currentAssignment.keySet());
                Collections.shuffle(segments, new Random(this._offlineTableName.hashCode()));
                newAssignment = new TreeMap();
                SegmentAssignmentUtils.rebalanceReplicaGroupBasedPartition(currentAssignment, instancePartitions, 0, segments, newAssignment);
            } else {
                newAssignment = this.rebalanceTableWithPartition(currentAssignment, instancePartitions);
            }
        }
        return newAssignment;
    }

    private Map<String, Map<String, String>> rebalanceTableWithPartition(Map<String, Map<String, String>> currentAssignment, InstancePartitions instancePartitions) {
        List segmentZKMetadataList = ZKMetadataProvider.getOfflineSegmentZKMetadataListForTable((ZkHelixPropertyStore)this._helixManager.getHelixPropertyStore(), (String)this._offlineTableName);
        HashMap<String, OfflineSegmentZKMetadata> segmentZKMetadataMap = new HashMap<String, OfflineSegmentZKMetadata>();
        for (Object segmentZKMetadata : segmentZKMetadataList) {
            segmentZKMetadataMap.put(segmentZKMetadata.getSegmentName(), (OfflineSegmentZKMetadata)segmentZKMetadata);
        }
        HashMap<Integer, List<String>> partitionIdToSegmentsMap = new HashMap<Integer, List<String>>();
        for (String segmentName : currentAssignment.keySet()) {
            int partitionId = this.getPartitionId((OfflineSegmentZKMetadata)segmentZKMetadataMap.get(segmentName));
            partitionIdToSegmentsMap.computeIfAbsent(partitionId, k -> new ArrayList()).add(segmentName);
        }
        Random random = new Random(this._offlineTableName.hashCode());
        for (List segments : partitionIdToSegmentsMap.values()) {
            Collections.shuffle(segments, random);
        }
        return SegmentAssignmentUtils.rebalanceReplicaGroupBasedTable(currentAssignment, instancePartitions, partitionIdToSegmentsMap);
    }

    private int getPartitionId(OfflineSegmentZKMetadata segmentZKMetadata) {
        String segmentName = segmentZKMetadata.getSegmentName();
        ColumnPartitionMetadata partitionMetadata = (ColumnPartitionMetadata)segmentZKMetadata.getPartitionMetadata().getColumnPartitionMap().get(this._partitionColumn);
        Preconditions.checkState((partitionMetadata != null ? 1 : 0) != 0, (String)"Segment ZK metadata for segment: %s of table: %s does not contain partition metadata for column: %s", (Object)segmentName, (Object)this._offlineTableName, (Object)this._partitionColumn);
        Set partitions = partitionMetadata.getPartitions();
        Preconditions.checkState((partitions.size() == 1 ? 1 : 0) != 0, (String)"Segment ZK metadata for segment: %s of table: %s contains multiple partitions for column: %s", (Object)segmentName, (Object)this._offlineTableName, (Object)this._partitionColumn);
        return (Integer)partitions.iterator().next();
    }
}

