/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.minion;

import java.util.ArrayList;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ControllerGauge;
import org.apache.pinot.common.metrics.ControllerMetrics;
import org.apache.pinot.controller.ControllerConf;
import org.apache.pinot.controller.LeadControllerManager;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.controller.helix.core.PinotResourceManagerResponse;
import org.apache.pinot.core.periodictask.BasePeriodicTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinionInstancesCleanupTask
extends BasePeriodicTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(MinionInstancesCleanupTask.class);
    private static final String TASK_NAME = "MinionInstancesCleanupTask";
    protected final PinotHelixResourceManager _pinotHelixResourceManager;
    protected final LeadControllerManager _leadControllerManager;
    protected final ControllerMetrics _controllerMetrics;
    private final long _minionInstanceCleanupTaskMinOfflineTimeBeforeDeletionInMilliseconds;

    public MinionInstancesCleanupTask(PinotHelixResourceManager pinotHelixResourceManager, LeadControllerManager leadControllerManager, ControllerConf controllerConf, ControllerMetrics controllerMetrics) {
        super(TASK_NAME, controllerConf.getMinionInstancesCleanupTaskFrequencyInSeconds(), controllerConf.getMinionInstancesCleanupTaskInitialDelaySeconds());
        this._pinotHelixResourceManager = pinotHelixResourceManager;
        this._leadControllerManager = leadControllerManager;
        this._controllerMetrics = controllerMetrics;
        this._minionInstanceCleanupTaskMinOfflineTimeBeforeDeletionInMilliseconds = (long)controllerConf.getMinionInstancesCleanupTaskMinOfflineTimeBeforeDeletionInSeconds() * 1000L;
    }

    protected void runTask() {
        if (!this._leadControllerManager.isLeaderForTable(TASK_NAME)) {
            return;
        }
        ArrayList<String> offlineInstances = new ArrayList<String>(this._pinotHelixResourceManager.getAllInstances());
        offlineInstances.removeAll(this._pinotHelixResourceManager.getOnlineInstanceList());
        for (String offlineInstance : offlineInstances) {
            if (!offlineInstance.startsWith("Minion_") || !this._pinotHelixResourceManager.isInstanceOfflineFor(offlineInstance, this._minionInstanceCleanupTaskMinOfflineTimeBeforeDeletionInMilliseconds)) continue;
            LOGGER.info("Dropping minion instance: {}", (Object)offlineInstance);
            PinotResourceManagerResponse response = this._pinotHelixResourceManager.dropInstance(offlineInstance);
            if (!response.isSuccessful()) continue;
            this._controllerMetrics.addValueToGlobalGauge((AbstractMetrics.Gauge)ControllerGauge.DROPPED_MINION_INSTANCES, 1L);
        }
    }
}

