/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.minion;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.helix.task.JobConfig;
import org.apache.helix.task.JobContext;
import org.apache.helix.task.JobQueue;
import org.apache.helix.task.TaskConfig;
import org.apache.helix.task.TaskDriver;
import org.apache.helix.task.TaskPartitionState;
import org.apache.helix.task.TaskState;
import org.apache.helix.task.WorkflowConfig;
import org.apache.helix.task.WorkflowContext;
import org.apache.pinot.core.minion.PinotTaskConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PinotHelixTaskResourceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(PinotHelixTaskResourceManager.class);
    public static final String TASK_NAME_SEPARATOR = "_";
    private static final String TASK_QUEUE_PREFIX = "TaskQueue_";
    private static final String TASK_PREFIX = "Task_";
    private final TaskDriver _taskDriver;

    public PinotHelixTaskResourceManager(TaskDriver taskDriver) {
        this._taskDriver = taskDriver;
    }

    public synchronized Set<String> getTaskTypes() {
        Set helixJobQueues = this._taskDriver.getWorkflows().keySet();
        HashSet<String> taskTypes = new HashSet<String>(helixJobQueues.size());
        for (String helixJobQueue : helixJobQueues) {
            taskTypes.add(PinotHelixTaskResourceManager.getTaskType(helixJobQueue));
        }
        return taskTypes;
    }

    public void ensureTaskQueueExists(String taskType) {
        String helixJobQueueName = PinotHelixTaskResourceManager.getHelixJobQueueName(taskType);
        WorkflowConfig workflowConfig = this._taskDriver.getWorkflowConfig(helixJobQueueName);
        if (workflowConfig == null) {
            LOGGER.info("Creating task queue: {} for task type: {}", (Object)helixJobQueueName, (Object)taskType);
            JobQueue jobQueue = new JobQueue.Builder(helixJobQueueName).setWorkflowConfig(new WorkflowConfig.Builder().setParallelJobs(Integer.MAX_VALUE).build()).build();
            this._taskDriver.createQueue(jobQueue);
        }
        while (this._taskDriver.getWorkflowContext(helixJobQueueName) == null) {
            Uninterruptibles.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
    }

    public synchronized void cleanUpTaskQueue(String taskType) {
        String helixJobQueueName = PinotHelixTaskResourceManager.getHelixJobQueueName(taskType);
        LOGGER.info("Cleaning up task queue: {} for task type: {}", (Object)helixJobQueueName, (Object)taskType);
        this._taskDriver.cleanupQueue(helixJobQueueName);
    }

    public synchronized void stopTaskQueue(String taskType) {
        String helixJobQueueName = PinotHelixTaskResourceManager.getHelixJobQueueName(taskType);
        LOGGER.info("Stopping task queue: {} for task type: {}", (Object)helixJobQueueName, (Object)taskType);
        this._taskDriver.stop(helixJobQueueName);
    }

    public synchronized void resumeTaskQueue(String taskType) {
        String helixJobQueueName = PinotHelixTaskResourceManager.getHelixJobQueueName(taskType);
        LOGGER.info("Resuming task queue: {} for task type: {}", (Object)helixJobQueueName, (Object)taskType);
        this._taskDriver.resume(helixJobQueueName);
    }

    public synchronized void deleteTaskQueue(String taskType, boolean forceDelete) {
        String helixJobQueueName = PinotHelixTaskResourceManager.getHelixJobQueueName(taskType);
        if (forceDelete) {
            LOGGER.warn("Force deleting task queue: {} for task type: {}", (Object)helixJobQueueName, (Object)taskType);
        } else {
            LOGGER.info("Deleting task queue: {} for task type: {}", (Object)helixJobQueueName, (Object)taskType);
        }
        this._taskDriver.delete(helixJobQueueName, forceDelete);
    }

    public synchronized Set<String> getTaskQueues() {
        return this._taskDriver.getWorkflows().keySet();
    }

    public synchronized TaskState getTaskQueueState(String taskType) {
        return this._taskDriver.getWorkflowContext(PinotHelixTaskResourceManager.getHelixJobQueueName(taskType)).getWorkflowState();
    }

    public synchronized String submitTask(List<PinotTaskConfig> pinotTaskConfigs, long taskTimeoutMs, int numConcurrentTasksPerInstance) {
        return this.submitTask(pinotTaskConfigs, "minion_untagged", taskTimeoutMs, numConcurrentTasksPerInstance);
    }

    public synchronized String submitTask(List<PinotTaskConfig> pinotTaskConfigs, String minionInstanceTag, long taskTimeoutMs, int numConcurrentTasksPerInstance) {
        int numChildTasks = pinotTaskConfigs.size();
        Preconditions.checkState((numChildTasks > 0 ? 1 : 0) != 0);
        Preconditions.checkState((numConcurrentTasksPerInstance > 0 ? 1 : 0) != 0);
        String taskType = pinotTaskConfigs.get(0).getTaskType();
        String parentTaskName = TASK_PREFIX + taskType + TASK_NAME_SEPARATOR + System.currentTimeMillis();
        LOGGER.info("Submitting parent task: {} of type: {} with {} child task configs: {} to Minion instances with tag: {}", new Object[]{parentTaskName, taskType, numChildTasks, pinotTaskConfigs, minionInstanceTag});
        ArrayList<TaskConfig> helixTaskConfigs = new ArrayList<TaskConfig>(numChildTasks);
        for (int i = 0; i < numChildTasks; ++i) {
            PinotTaskConfig pinotTaskConfig = pinotTaskConfigs.get(i);
            Preconditions.checkState((boolean)pinotTaskConfig.getTaskType().equals(taskType));
            helixTaskConfigs.add(pinotTaskConfig.toHelixTaskConfig(parentTaskName + TASK_NAME_SEPARATOR + i));
        }
        JobConfig.Builder jobBuilder = new JobConfig.Builder().addTaskConfigs(helixTaskConfigs).setInstanceGroupTag(minionInstanceTag).setTimeoutPerTask(taskTimeoutMs).setNumConcurrentTasksPerInstance(numConcurrentTasksPerInstance).setIgnoreDependentJobFailure(true).setMaxAttemptsPerTask(1).setFailureThreshold(Integer.MAX_VALUE);
        this._taskDriver.enqueueJob(PinotHelixTaskResourceManager.getHelixJobQueueName(taskType), parentTaskName, jobBuilder);
        while (this.getTaskState(parentTaskName) == null) {
            Uninterruptibles.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        return parentTaskName;
    }

    public synchronized Set<String> getTasks(String taskType) {
        Set helixJobs = this._taskDriver.getWorkflowContext(PinotHelixTaskResourceManager.getHelixJobQueueName(taskType)).getJobStates().keySet();
        HashSet<String> tasks = new HashSet<String>(helixJobs.size());
        for (String helixJobName : helixJobs) {
            tasks.add(PinotHelixTaskResourceManager.getPinotTaskName(helixJobName));
        }
        return tasks;
    }

    public synchronized Map<String, TaskState> getTaskStates(String taskType) {
        Map<String, Object> helixJobStates = new HashMap<String, TaskState>();
        WorkflowContext workflowContext = this._taskDriver.getWorkflowContext(PinotHelixTaskResourceManager.getHelixJobQueueName(taskType));
        if (workflowContext == null) {
            return helixJobStates;
        }
        helixJobStates = workflowContext.getJobStates();
        HashMap<String, TaskState> taskStates = new HashMap<String, TaskState>(helixJobStates.size());
        for (Map.Entry<String, Object> entry : helixJobStates.entrySet()) {
            taskStates.put(PinotHelixTaskResourceManager.getPinotTaskName(entry.getKey()), (TaskState)entry.getValue());
        }
        return taskStates;
    }

    public synchronized TaskCount getTaskCount(String parentTaskName) {
        TaskCount taskCount = new TaskCount();
        JobContext jobContext = this._taskDriver.getJobContext(PinotHelixTaskResourceManager.getHelixJobName(parentTaskName));
        if (jobContext == null) {
            return taskCount;
        }
        Set partitionSet = jobContext.getPartitionSet();
        taskCount.addToTotal(partitionSet.size());
        Iterator iterator = partitionSet.iterator();
        while (iterator.hasNext()) {
            int partition = (Integer)iterator.next();
            TaskPartitionState state = jobContext.getPartitionState(partition);
            if (state == null) {
                taskCount.addToWaiting(1);
                continue;
            }
            if (state.equals((Object)TaskPartitionState.INIT) || state.equals((Object)TaskPartitionState.RUNNING)) {
                taskCount.addToRunning(1);
                continue;
            }
            if (!state.equals((Object)TaskPartitionState.TASK_ERROR)) continue;
            taskCount.addToError(1);
        }
        return taskCount;
    }

    public synchronized Set<String> getTasksInProgress(String taskType) {
        HashSet<String> tasksInProgress = new HashSet<String>();
        WorkflowContext workflowContext = this._taskDriver.getWorkflowContext(PinotHelixTaskResourceManager.getHelixJobQueueName(taskType));
        if (workflowContext == null) {
            return tasksInProgress;
        }
        Map helixJobStates = workflowContext.getJobStates();
        for (Map.Entry entry : helixJobStates.entrySet()) {
            if (!((TaskState)entry.getValue()).equals((Object)TaskState.NOT_STARTED) && !((TaskState)entry.getValue()).equals((Object)TaskState.IN_PROGRESS)) continue;
            tasksInProgress.add(PinotHelixTaskResourceManager.getPinotTaskName((String)entry.getKey()));
        }
        return tasksInProgress;
    }

    public synchronized TaskState getTaskState(String taskName) {
        String taskType = PinotHelixTaskResourceManager.getTaskType(taskName);
        return this._taskDriver.getWorkflowContext(PinotHelixTaskResourceManager.getHelixJobQueueName(taskType)).getJobState(PinotHelixTaskResourceManager.getHelixJobName(taskName));
    }

    public synchronized List<PinotTaskConfig> getTaskConfigs(String taskName) {
        Collection helixTaskConfigs = this._taskDriver.getJobConfig(PinotHelixTaskResourceManager.getHelixJobName(taskName)).getTaskConfigMap().values();
        ArrayList<PinotTaskConfig> taskConfigs = new ArrayList<PinotTaskConfig>(helixTaskConfigs.size());
        for (TaskConfig helixTaskConfig : helixTaskConfigs) {
            taskConfigs.add(PinotTaskConfig.fromHelixTaskConfig((TaskConfig)helixTaskConfig));
        }
        return taskConfigs;
    }

    public synchronized Map<String, TaskState> getTaskStatesByTable(String taskType, String tableNameWithType) {
        HashMap<String, TaskState> filteredTaskStateMap = new HashMap<String, TaskState>();
        Map<String, TaskState> taskStateMap = this.getTaskStates(taskType);
        block0: for (Map.Entry<String, TaskState> taskState : taskStateMap.entrySet()) {
            String taskName = taskState.getKey();
            for (PinotTaskConfig taskConfig : this.getTaskConfigs(taskName)) {
                String tableNameConfig;
                Map pinotConfigs = taskConfig.getConfigs();
                if (pinotConfigs == null || (tableNameConfig = (String)pinotConfigs.get("tableName")) == null || !tableNameConfig.equals(tableNameWithType)) continue;
                filteredTaskStateMap.put(taskName, taskStateMap.get(taskName));
                continue block0;
            }
        }
        return filteredTaskStateMap;
    }

    public static String getHelixJobQueueName(String taskType) {
        return TASK_QUEUE_PREFIX + taskType;
    }

    private static String getHelixJobName(String pinotTaskName) {
        return PinotHelixTaskResourceManager.getHelixJobQueueName(PinotHelixTaskResourceManager.getTaskType(pinotTaskName)) + TASK_NAME_SEPARATOR + pinotTaskName;
    }

    private static String getPinotTaskName(String helixJobName) {
        return helixJobName.substring(TASK_QUEUE_PREFIX.length() + PinotHelixTaskResourceManager.getTaskType(helixJobName).length() + 1);
    }

    private static String getTaskType(String name) {
        return name.split(TASK_NAME_SEPARATOR)[1];
    }

    public static class TaskCount {
        private int _waiting;
        private int _error;
        private int _running;
        private int _total;

        public void addToWaiting(int waiting) {
            this._waiting += waiting;
        }

        public void addToRunning(int running) {
            this._running += running;
        }

        public void addToTotal(int total) {
            this._total += total;
        }

        public void addToError(int error) {
            this._error += error;
        }

        public int getWaiting() {
            return this._waiting;
        }

        public int getRunning() {
            return this._running;
        }

        public int getTotal() {
            return this._total;
        }

        public int getError() {
            return this._error;
        }

        public void accumulate(TaskCount other) {
            this.addToWaiting(other.getWaiting());
            this.addToRunning(other.getRunning());
            this.addToError(other.getError());
            this.addToTotal(other.getTotal());
        }
    }
}

