/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.recommender.data.generator;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.IntRange;
import org.apache.pinot.controller.recommender.data.generator.AvroWriter;
import org.apache.pinot.controller.recommender.data.generator.DataGeneratorSpec;
import org.apache.pinot.controller.recommender.data.generator.Generator;
import org.apache.pinot.controller.recommender.data.generator.GeneratorFactory;
import org.apache.pinot.controller.recommender.data.generator.PatternType;
import org.apache.pinot.spi.data.DimensionFieldSpec;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.MetricFieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.TimeFieldSpec;
import org.apache.pinot.spi.data.TimeGranularitySpec;
import org.apache.pinot.spi.data.readers.FileFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataGenerator.class);
    private File outDir;
    DataGeneratorSpec genSpec;
    private final Map<String, Generator> generators = new HashMap<String, Generator>();

    public void init(DataGeneratorSpec spec) throws IOException {
        this.genSpec = spec;
        this.outDir = new File(this.genSpec.getOutputDir());
        if (this.outDir.exists() && !this.genSpec.isOverrideOutDir()) {
            LOGGER.error("output directory already exists, and override is set to false");
            throw new RuntimeException("output directory exists");
        }
        if (this.outDir.exists()) {
            FileUtils.deleteDirectory((File)this.outDir);
        }
        this.outDir.mkdir();
        for (String column : this.genSpec.getColumns()) {
            Generator generator;
            FieldSpec.DataType dataType = this.genSpec.getDataTypesMap().get(column);
            if (this.genSpec.getPatternMap().containsKey(column)) {
                generator = GeneratorFactory.getGeneratorFor(PatternType.valueOf(this.genSpec.getPatternMap().get(column).get("type").toString()), this.genSpec.getPatternMap().get(column));
            } else if (this.genSpec.getCardinalityMap().containsKey(column)) {
                generator = GeneratorFactory.getGeneratorFor(dataType, this.genSpec.getCardinalityMap().get(column), this.genSpec.getMvCountMap().get(column), this.genSpec.getLengthMap().get(column), this.genSpec.getTimeUnitMap().get(column));
            } else if (this.genSpec.getRangeMap().containsKey(column)) {
                IntRange range = this.genSpec.getRangeMap().get(column);
                generator = GeneratorFactory.getGeneratorFor(dataType, range.getMinimumInteger(), range.getMaximumInteger());
            } else {
                LOGGER.error("cardinality for this column does not exist : " + column);
                throw new RuntimeException("cardinality for this column does not exist");
            }
            generator.init();
            this.generators.put(column, generator);
        }
    }

    public void generateAvro(long totalDocs, int numFiles) throws IOException {
        int numPerFiles = (int)(totalDocs / (long)numFiles);
        for (int i = 0; i < numFiles; ++i) {
            try (AvroWriter writer = new AvroWriter(this.outDir, i, this.generators, this.fetchSchema());){
                for (int j = 0; j < numPerFiles; ++j) {
                    writer.writeNext();
                }
                continue;
            }
        }
    }

    public void generateCsv(long totalDocs, int numFiles) throws IOException {
        int numPerFiles = (int)(totalDocs / (long)numFiles);
        for (int i = 0; i < numFiles; ++i) {
            try (FileWriter writer = new FileWriter(new File(this.outDir, String.format("output_%d.csv", i)));){
                writer.append(StringUtils.join(this.genSpec.getColumns(), (String)",")).append('\n');
                for (int j = 0; j < numPerFiles; ++j) {
                    Object[] values = new Object[this.genSpec.getColumns().size()];
                    for (int k = 0; k < this.genSpec.getColumns().size(); ++k) {
                        Object next = this.generators.get(this.genSpec.getColumns().get(k)).next();
                        values[k] = this.serializeIfMultiValue(next);
                    }
                    writer.append(StringUtils.join((Object[])values, (String)",")).append('\n');
                }
                continue;
            }
        }
    }

    private Object serializeIfMultiValue(Object obj) {
        if (obj instanceof List) {
            return StringUtils.join((Collection)((List)obj), (String)";");
        }
        return obj;
    }

    public Schema fetchSchema() {
        Schema schema = new Schema();
        for (String column : this.genSpec.getColumns()) {
            FieldSpec spec = this.buildSpec(this.genSpec, column);
            schema.addField(spec);
        }
        return schema;
    }

    private FieldSpec buildSpec(DataGeneratorSpec genSpec, String column) {
        DimensionFieldSpec spec;
        FieldSpec.DataType dataType = genSpec.getDataTypesMap().get(column);
        FieldSpec.FieldType fieldType = genSpec.getFieldTypesMap().get(column);
        switch (fieldType) {
            case DIMENSION: {
                spec = new DimensionFieldSpec();
                break;
            }
            case METRIC: {
                spec = new MetricFieldSpec();
                break;
            }
            case TIME: {
                spec = new TimeFieldSpec(new TimeGranularitySpec(dataType, genSpec.getTimeUnitMap().get(column), column));
                break;
            }
            default: {
                throw new RuntimeException("Invalid Field type.");
            }
        }
        spec.setName(column);
        spec.setDataType(dataType);
        spec.setSingleValueField(true);
        return spec;
    }

    public static void main(String[] args) throws IOException {
        HashMap<String, FieldSpec.DataType> dataTypes = new HashMap<String, FieldSpec.DataType>();
        HashMap<String, FieldSpec.FieldType> fieldTypes = new HashMap<String, FieldSpec.FieldType>();
        HashMap<String, TimeUnit> timeUnits = new HashMap<String, TimeUnit>();
        HashMap<String, Integer> cardinality = new HashMap<String, Integer>();
        HashMap<String, IntRange> range = new HashMap<String, IntRange>();
        HashMap<String, Map<String, Object>> template = new HashMap<String, Map<String, Object>>();
        HashMap<String, Double> mvCountMap = new HashMap<String, Double>();
        HashMap<String, Integer> lengthMap = new HashMap<String, Integer>();
        ArrayList<String> columnNames = new ArrayList<String>();
        int cardinalityValue = 5;
        int strLength = 5;
        Object colName = "colInt";
        dataTypes.put((String)colName, FieldSpec.DataType.INT);
        fieldTypes.put((String)colName, FieldSpec.FieldType.DIMENSION);
        cardinality.put((String)colName, cardinalityValue);
        columnNames.add((String)colName);
        mvCountMap.put((String)colName, 3.7);
        String colName2 = "colFloat";
        dataTypes.put(colName2, FieldSpec.DataType.FLOAT);
        fieldTypes.put(colName2, FieldSpec.FieldType.DIMENSION);
        cardinality.put(colName2, cardinalityValue);
        columnNames.add(colName2);
        mvCountMap.put(colName2, 3.7);
        String colName3 = "colString";
        dataTypes.put(colName3, FieldSpec.DataType.STRING);
        fieldTypes.put(colName3, FieldSpec.FieldType.DIMENSION);
        cardinality.put(colName3, cardinalityValue);
        columnNames.add(colName3);
        mvCountMap.put(colName3, 3.7);
        lengthMap.put(colName3, strLength);
        String colName4 = "metric";
        dataTypes.put(colName4, FieldSpec.DataType.DOUBLE);
        fieldTypes.put(colName4, FieldSpec.FieldType.METRIC);
        cardinality.put(colName4, cardinalityValue);
        columnNames.add(colName4);
        String colName5 = "colBytes";
        dataTypes.put(colName5, FieldSpec.DataType.BYTES);
        fieldTypes.put(colName5, FieldSpec.FieldType.DIMENSION);
        cardinality.put(colName5, cardinalityValue);
        columnNames.add(colName5);
        mvCountMap.put(colName5, 3.7);
        lengthMap.put(colName5, strLength + 1);
        for (int i = 0; i < 2; ++i) {
            colName = "colString" + (i + 2);
            dataTypes.put((String)colName, FieldSpec.DataType.STRING);
            fieldTypes.put((String)colName, FieldSpec.FieldType.DIMENSION);
            cardinality.put((String)colName, cardinalityValue);
            columnNames.add((String)colName);
            lengthMap.put((String)colName, strLength + i + 2);
        }
        String outputDir = Paths.get(System.getProperty("java.io.tmpdir"), "csv-data").toString();
        DataGeneratorSpec spec = new DataGeneratorSpec(columnNames, cardinality, range, template, mvCountMap, lengthMap, dataTypes, fieldTypes, timeUnits, FileFormat.CSV, outputDir, true);
        DataGenerator gen = new DataGenerator();
        gen.init(spec);
        gen.generateCsv(100L, 1);
        System.out.println("CSV data is generated under: " + outputDir);
    }
}

