/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.recommender.data.generator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.math.IntRange;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.readers.FileFormat;

public class DataGeneratorSpec {
    private final List<String> columns;
    private final Map<String, Integer> cardinalityMap;
    private final Map<String, IntRange> rangeMap;
    private final Map<String, Map<String, Object>> patternMap;
    private final Map<String, Double> mvCountMap;
    private final Map<String, Integer> lengthMap;
    private final Map<String, FieldSpec.DataType> dataTypesMap;
    private final Map<String, FieldSpec.FieldType> fieldTypesMap;
    private final Map<String, TimeUnit> timeUnitMap;
    private final FileFormat outputFileFormat;
    private final String outputDir;
    private final boolean overrideOutDir;

    public DataGeneratorSpec() {
        this(new ArrayList<String>(), new HashMap<String, Integer>(), new HashMap<String, IntRange>(), new HashMap<String, Map<String, Object>>(), new HashMap<String, Double>(), new HashMap<String, Integer>(), new HashMap<String, FieldSpec.DataType>(), new HashMap<String, FieldSpec.FieldType>(), new HashMap<String, TimeUnit>(), FileFormat.AVRO, "/tmp/dataGen", true);
    }

    public DataGeneratorSpec(List<String> columns, Map<String, Integer> cardinalityMap, Map<String, IntRange> rangeMap, Map<String, Map<String, Object>> patternMap, Map<String, Double> mvCountMap, Map<String, Integer> lengthMap, Map<String, FieldSpec.DataType> dataTypesMap, Map<String, FieldSpec.FieldType> fieldTypesMap, Map<String, TimeUnit> timeUnitMap, FileFormat format, String outputDir, boolean override) {
        this.columns = columns;
        this.cardinalityMap = cardinalityMap;
        this.rangeMap = rangeMap;
        this.patternMap = patternMap;
        this.mvCountMap = mvCountMap;
        this.lengthMap = lengthMap;
        this.outputFileFormat = format;
        this.outputDir = outputDir;
        this.overrideOutDir = override;
        this.dataTypesMap = dataTypesMap;
        this.fieldTypesMap = fieldTypesMap;
        this.timeUnitMap = timeUnitMap;
    }

    public Map<String, FieldSpec.DataType> getDataTypesMap() {
        return this.dataTypesMap;
    }

    public Map<String, FieldSpec.FieldType> getFieldTypesMap() {
        return this.fieldTypesMap;
    }

    public Map<String, TimeUnit> getTimeUnitMap() {
        return this.timeUnitMap;
    }

    public boolean isOverrideOutDir() {
        return this.overrideOutDir;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public Map<String, Integer> getCardinalityMap() {
        return this.cardinalityMap;
    }

    public Map<String, IntRange> getRangeMap() {
        return this.rangeMap;
    }

    public Map<String, Map<String, Object>> getPatternMap() {
        return this.patternMap;
    }

    public Map<String, Double> getMvCountMap() {
        return this.mvCountMap;
    }

    public Map<String, Integer> getLengthMap() {
        return this.lengthMap;
    }

    public FileFormat getOutputFileFormat() {
        return this.outputFileFormat;
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (String column : this.columns) {
            if (this.cardinalityMap.get(column) != null) {
                builder.append(column + " : " + this.cardinalityMap.get(column) + " : " + this.dataTypesMap.get(column));
                continue;
            }
            if (this.rangeMap.get(column) != null) {
                builder.append(column + " : " + this.rangeMap.get(column) + " : " + this.dataTypesMap.get(column));
                continue;
            }
            builder.append(column + " : " + this.patternMap.get(column));
        }
        builder.append("output file format : " + this.outputFileFormat);
        builder.append("output file format : " + this.outputDir);
        return builder.toString();
    }
}

