/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.recommender.data.generator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.pinot.controller.recommender.data.generator.Generator;
import org.apache.pinot.controller.recommender.data.generator.GeneratorFactory;
import org.apache.pinot.controller.recommender.data.generator.PatternType;

public class PatternMixtureGenerator
implements Generator {
    private final List<List<Generator>> generatorBins;
    private long step = -1L;

    public PatternMixtureGenerator(Map<String, Object> templateConfig) {
        this(PatternMixtureGenerator.toGeneratorBins((List)templateConfig.get("generatorBins"), (Map)templateConfig.get("defaults")));
    }

    public PatternMixtureGenerator(List<List<Generator>> generatorBins) {
        this.generatorBins = generatorBins;
    }

    private static List<List<Generator>> toGeneratorBins(List<List<Map<String, Object>>> templateConfigBins, Map<String, Object> defaults) {
        ArrayList safeBins = templateConfigBins == null ? new ArrayList() : templateConfigBins;
        HashMap safeDefaults = defaults == null ? new HashMap() : defaults;
        return safeBins.stream().map(conf -> PatternMixtureGenerator.toGenerators(conf, safeDefaults)).collect(Collectors.toList());
    }

    private static List<Generator> toGenerators(List<Map<String, Object>> templateConfigs, Map<String, Object> defaults) {
        return templateConfigs.stream().map(conf -> {
            HashMap<String, Object> augmentedConf = new HashMap<String, Object>(defaults);
            augmentedConf.putAll((Map<String, Object>)conf);
            return PatternMixtureGenerator.toGenerator(augmentedConf);
        }).collect(Collectors.toList());
    }

    private static Generator toGenerator(Map<String, Object> templateConfig) {
        PatternType type = PatternType.valueOf(templateConfig.get("type").toString());
        return GeneratorFactory.getGeneratorFor(type, templateConfig);
    }

    @Override
    public void init() {
    }

    @Override
    public Object next() {
        ++this.step;
        int bin = (int)this.step % this.generatorBins.size();
        long output = 0L;
        for (Generator gen : this.generatorBins.get(bin)) {
            output += ((Long)gen.next()).longValue();
        }
        return output;
    }
}

