/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.recommender.data.generator;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.PropertyConverter;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well19937c;
import org.apache.pinot.controller.recommender.data.generator.Generator;

public class PatternSeasonalGenerator
implements Generator {
    private final double trend;
    private final double wavelength;
    private final double amplitude;
    private final double[] scalingFactors;
    private final double offset;
    private final NormalDistribution generator;
    private long step = -1L;

    public PatternSeasonalGenerator(Map<String, Object> templateConfig) {
        this(PropertyConverter.toDouble((Object)templateConfig.getOrDefault("mean", 0)), PropertyConverter.toDouble((Object)templateConfig.getOrDefault("sigma", 0)), PropertyConverter.toDouble((Object)templateConfig.getOrDefault("trend", 0)), PropertyConverter.toDouble((Object)templateConfig.getOrDefault("wavelength", 0)), PropertyConverter.toDouble((Object)templateConfig.getOrDefault("amplitude", 0)), PropertyConverter.toDouble((Object)templateConfig.getOrDefault("offset", 0)), PropertyConverter.toInteger((Object)templateConfig.getOrDefault("seed", 0)), PatternSeasonalGenerator.toDoubleArray(templateConfig.get("scalingFactors"), 1.0));
    }

    public PatternSeasonalGenerator(double mean, double sigma, double trend, double wavelength, double amplitude, double offset, int seed, double[] scalingFactors) {
        this.trend = trend;
        this.wavelength = wavelength;
        this.amplitude = amplitude;
        this.offset = offset;
        this.scalingFactors = scalingFactors;
        this.generator = new NormalDistribution((RandomGenerator)new Well19937c(seed), mean, sigma, 1.0E-9);
    }

    @Override
    public void init() {
    }

    @Override
    public Object next() {
        ++this.step;
        return (long)Math.max((this.generator.sample() + this.trend * (double)this.step + (this.wavelength == 0.0 ? 0.0 : Math.sin(((double)this.step / this.wavelength + this.offset) * 2.0 * Math.PI) * this.amplitude)) * this.makeScalingFactor(this.step), 0.0);
    }

    private double makeScalingFactor(long step) {
        double offset = (double)step / this.wavelength - 0.5 + (double)this.scalingFactors.length;
        int i = (int)Math.floor(offset) % this.scalingFactors.length;
        int j = (int)Math.ceil(offset) % this.scalingFactors.length;
        double shift = offset - Math.floor(offset);
        return (1.0 - shift) * this.scalingFactors[i] + shift * this.scalingFactors[j];
    }

    private static double[] toDoubleArray(Object obj, double defaultValue) {
        if (obj == null) {
            double[] values = new double[1];
            Arrays.fill(values, defaultValue);
            return values;
        }
        List userValues = (List)obj;
        double[] values = new double[userValues.size()];
        for (int i = 0; i < userValues.size(); ++i) {
            values[i] = (Double)userValues.get(i);
        }
        return values;
    }
}

