/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.recommender.data.generator;

import java.util.Map;
import org.apache.commons.configuration.PropertyConverter;
import org.apache.pinot.controller.recommender.data.generator.Generator;

public class PatternSequenceGenerator
implements Generator {
    private final long start;
    private final long stepsize;
    private final long repetitions;
    private long step = -1L;

    public PatternSequenceGenerator(Map<String, Object> templateConfig) {
        this(PropertyConverter.toLong((Object)templateConfig.getOrDefault("start", 0)), PropertyConverter.toLong((Object)templateConfig.getOrDefault("stepsize", 1)), PropertyConverter.toLong((Object)templateConfig.getOrDefault("repetitions", 1)));
    }

    public PatternSequenceGenerator(long start, long stepsize, long repetitions) {
        this.start = start;
        this.stepsize = stepsize;
        this.repetitions = repetitions;
    }

    @Override
    public void init() {
    }

    @Override
    public Object next() {
        ++this.step;
        return this.start + this.step / this.repetitions * this.stepsize;
    }
}

