/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.recommender.data.generator;

import java.util.Map;
import org.apache.commons.configuration.PropertyConverter;
import org.apache.commons.math3.distribution.AbstractRealDistribution;
import org.apache.commons.math3.distribution.ExponentialDistribution;
import org.apache.commons.math3.distribution.LogNormalDistribution;
import org.apache.commons.math3.distribution.UniformRealDistribution;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well19937c;
import org.apache.pinot.controller.recommender.data.generator.Generator;

public class PatternSpikeGenerator
implements Generator {
    private final double baseline;
    private final double smoothing;
    private final AbstractRealDistribution arrivalGenerator;
    private final AbstractRealDistribution magnitudeGenerator;
    private long step = -1L;
    private long nextArrival;
    private double lastValue;

    public PatternSpikeGenerator(Map<String, Object> templateConfig) {
        this(PropertyConverter.toDouble((Object)templateConfig.getOrDefault("baseline", 0)), DistributionType.valueOf(templateConfig.getOrDefault("arrivalType", "lognormal").toString().toUpperCase()), PropertyConverter.toDouble((Object)templateConfig.getOrDefault("arrivalMean", 2)), PropertyConverter.toDouble((Object)templateConfig.getOrDefault("arrivalSigma", 1)), DistributionType.valueOf(templateConfig.getOrDefault("magnitudeType", "lognormal").toString().toUpperCase()), PropertyConverter.toDouble((Object)templateConfig.getOrDefault("magnitudeMean", 2)), PropertyConverter.toDouble((Object)templateConfig.getOrDefault("magnitudeSigma", 1)), PropertyConverter.toDouble((Object)templateConfig.getOrDefault("smoothing", 0)), PropertyConverter.toInteger((Object)templateConfig.getOrDefault("seed", 0)));
    }

    public PatternSpikeGenerator(double baseline, DistributionType arrivalType, double arrivalMean, double arrivalSigma, DistributionType magnitudeType, double magnitudeMean, double magnitudeSigma, double smoothing, int seed) {
        this.baseline = baseline;
        this.smoothing = smoothing;
        this.arrivalGenerator = PatternSpikeGenerator.makeDist(arrivalType, arrivalMean, arrivalSigma, seed);
        this.magnitudeGenerator = PatternSpikeGenerator.makeDist(magnitudeType, magnitudeMean, magnitudeSigma, seed);
        this.nextArrival = (long)this.arrivalGenerator.sample();
        this.lastValue = baseline;
    }

    private static AbstractRealDistribution makeDist(DistributionType type, double mean, double sigma, int seed) {
        switch (type) {
            case LOGNORMAL: {
                return new LogNormalDistribution((RandomGenerator)new Well19937c(seed), mean, sigma, 1.0E-9);
            }
            case EXPONENTIAL: {
                return new ExponentialDistribution((RandomGenerator)new Well19937c(seed), mean, 1.0E-9);
            }
            case UNIFORM: {
                return new UniformRealDistribution((RandomGenerator)new Well19937c(seed), mean - sigma, mean + sigma);
            }
            case FIXED: {
                return new UniformRealDistribution((RandomGenerator)new Well19937c(seed), mean, mean + 1.0E-9);
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported distribution type '%s", new Object[]{type}));
    }

    @Override
    public void init() {
    }

    @Override
    public Object next() {
        ++this.step;
        if (this.step < this.nextArrival) {
            this.lastValue = (1.0 - this.smoothing) * this.baseline + this.smoothing * this.lastValue;
            return (long)this.lastValue;
        }
        this.nextArrival += (long)this.arrivalGenerator.sample();
        this.lastValue = this.baseline + this.magnitudeGenerator.sample();
        return (long)this.lastValue;
    }

    static enum DistributionType {
        LOGNORMAL,
        EXPONENTIAL,
        UNIFORM,
        FIXED;

    }
}

