/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.recommender.data.generator;

import com.google.common.annotations.VisibleForTesting;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.pinot.controller.recommender.data.generator.Generator;
import org.apache.pinot.controller.recommender.data.generator.NumberGenerator;
import org.apache.pinot.spi.data.FieldSpec;

public class TimeGenerator
implements Generator {
    private static final double DEFAULT_NUMBER_OF_VALUES_PER_ENTRY = 1.0;
    private final NumberGenerator _numberGenerator;
    private final FieldSpec.DataType _dataType;
    private final Number _initialValue;

    public TimeGenerator(Integer cardinality, FieldSpec.DataType dataType, TimeUnit timeUnit) {
        this._numberGenerator = new NumberGenerator(cardinality, dataType, 1.0);
        this._dataType = dataType;
        Date now = new Date();
        this._initialValue = TimeGenerator.convert(now, timeUnit, dataType);
    }

    @Override
    public void init() {
        this._numberGenerator.init();
    }

    @Override
    public Object next() {
        Object next = this._numberGenerator.next();
        if (this._dataType == FieldSpec.DataType.LONG) {
            return (Long)next + this._initialValue.longValue();
        }
        return (Integer)next + this._initialValue.intValue();
    }

    @VisibleForTesting
    static Number convert(Date date, TimeUnit timeUnit, FieldSpec.DataType dataType) {
        long convertedTime = timeUnit.convert(date.getTime(), TimeUnit.MILLISECONDS);
        if (dataType == FieldSpec.DataType.LONG) {
            return convertedTime;
        }
        if (dataType == FieldSpec.DataType.INT) {
            return (int)convertedTime;
        }
        throw new IllegalArgumentException("Time column can be only INT or LONG: " + dataType);
    }
}

