/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.recommender.io;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.pinot.common.request.BrokerRequest;
import org.apache.pinot.common.request.PinotQuery;
import org.apache.pinot.controller.recommender.exceptions.InvalidInputException;
import org.apache.pinot.controller.recommender.io.ConfigManager;
import org.apache.pinot.controller.recommender.io.metadata.FieldMetadata;
import org.apache.pinot.controller.recommender.io.metadata.SchemaWithMetaData;
import org.apache.pinot.controller.recommender.rules.RulesToExecute;
import org.apache.pinot.controller.recommender.rules.io.params.BloomFilterRuleParams;
import org.apache.pinot.controller.recommender.rules.io.params.FlagQueryRuleParams;
import org.apache.pinot.controller.recommender.rules.io.params.InvertedSortedIndexJointRuleParams;
import org.apache.pinot.controller.recommender.rules.io.params.NoDictionaryOnHeapDictionaryJointRuleParams;
import org.apache.pinot.controller.recommender.rules.io.params.PartitionRuleParams;
import org.apache.pinot.controller.recommender.rules.io.params.RangeIndexRuleParams;
import org.apache.pinot.controller.recommender.rules.io.params.RealtimeProvisioningRuleParams;
import org.apache.pinot.controller.recommender.rules.io.params.SegmentSizeRuleParams;
import org.apache.pinot.core.query.optimizer.QueryOptimizer;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.request.context.utils.BrokerRequestToQueryContextConverter;
import org.apache.pinot.core.requesthandler.PinotQueryParserFactory;
import org.apache.pinot.parsers.QueryCompiler;
import org.apache.pinot.spi.data.DateTimeFieldSpec;
import org.apache.pinot.spi.data.DimensionFieldSpec;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.MetricFieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.sql.parsers.SqlCompilationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
public class InputManager {
    private final Logger LOGGER = LoggerFactory.getLogger(InputManager.class);
    public Long _qps = 5L;
    public Long _numMessagesPerSecInKafkaTopic = 250L;
    public Long _numRecordsPerPush = 10000L;
    public Long _latencySLA = 500L;
    public RulesToExecute _rulesToExecute = new RulesToExecute();
    public Schema _schema = new Schema();
    public SchemaWithMetaData _schemaWithMetaData = new SchemaWithMetaData();
    public String _queryType = "sql";
    public Map<String, Double> _queryWeightMap = new HashMap<String, Double>();
    public String _tableType = "offline";
    public int _numKafkaPartitions = 0;
    public Integer _segmentFlushTime = 86400;
    public PartitionRuleParams _partitionRuleParams = new PartitionRuleParams();
    public InvertedSortedIndexJointRuleParams _invertedSortedIndexJointRuleParams = new InvertedSortedIndexJointRuleParams();
    public BloomFilterRuleParams _bloomFilterRuleParams = new BloomFilterRuleParams();
    public RangeIndexRuleParams _rangeIndexRuleParams = new RangeIndexRuleParams();
    public NoDictionaryOnHeapDictionaryJointRuleParams _noDictionaryOnHeapDictionaryJointRuleParams = new NoDictionaryOnHeapDictionaryJointRuleParams();
    public FlagQueryRuleParams _flagQueryRuleParams = new FlagQueryRuleParams();
    public RealtimeProvisioningRuleParams _realtimeProvisioningRuleParams;
    public SegmentSizeRuleParams _segmentSizeRuleParams = new SegmentSizeRuleParams();
    public ConfigManager _overWrittenConfigs = new ConfigManager();
    public Map<String, FieldMetadata> _metaDataMap = new HashMap<String, FieldMetadata>();
    long _sizePerRecord = 0L;
    Map<String, FieldSpec.DataType> _colNameFieldTypeMap = new HashMap<String, FieldSpec.DataType>();
    Set<String> _dimNames = null;
    Set<String> _metricNames = null;
    Set<String> _dateTimeNames = null;
    Set<String> _columnNamesInvertedSortedIndexApplicable = null;
    Map<String, Integer> _colNameToIntMap = null;
    String[] _intToColNameMap = null;
    Map<String, Triple<Double, BrokerRequest, QueryContext>> _parsedQueries = new HashMap<String, Triple<Double, BrokerRequest, QueryContext>>();
    Map<FieldSpec.DataType, Integer> _dataTypeSizeMap = new HashMap<FieldSpec.DataType, Integer>(){
        {
            this.put(FieldSpec.DataType.INT, 4);
            this.put(FieldSpec.DataType.LONG, 8);
            this.put(FieldSpec.DataType.FLOAT, 4);
            this.put(FieldSpec.DataType.DOUBLE, 8);
            this.put(FieldSpec.DataType.BYTES, 1);
            this.put(FieldSpec.DataType.STRING, 2);
            this.put(null, 0);
        }
    };
    protected final QueryOptimizer _queryOptimizer = new QueryOptimizer();

    public void init() throws InvalidInputException {
        this.LOGGER.info("Preprocessing Input:");
        this.reorderDimsAndBuildMap();
        this.registerColNameFieldType();
        this.validateQueries();
    }

    public void capCardinalities(int numRecordsInSegment) {
        this._metaDataMap.keySet().forEach(colName -> {
            int cardinality = Math.min(numRecordsInSegment, this._metaDataMap.get(colName).getCardinality());
            this._metaDataMap.get(colName).setCardinality(cardinality);
        });
    }

    private void validateQueries() {
        LinkedList<String> invalidQueries = new LinkedList<String>();
        QueryCompiler compiler = PinotQueryParserFactory.get((String)this.getQueryType());
        for (String queryString : this._queryWeightMap.keySet()) {
            try {
                BrokerRequest brokerRequest = compiler.compileToBrokerRequest(queryString);
                PinotQuery pinotQuery = brokerRequest.getPinotQuery();
                if (pinotQuery != null) {
                    this._queryOptimizer.optimize(pinotQuery, this._schema);
                } else {
                    this._queryOptimizer.optimize(brokerRequest, this._schema);
                }
                QueryContext queryContext = BrokerRequestToQueryContextConverter.convert((BrokerRequest)brokerRequest);
                this._parsedQueries.put(queryString, (Triple<Double, BrokerRequest, QueryContext>)Triple.of((Object)this._queryWeightMap.get(queryString), (Object)brokerRequest, (Object)queryContext));
            }
            catch (SqlCompilationException e) {
                invalidQueries.add(queryString);
                this._overWrittenConfigs.getFlaggedQueries().add(queryString, "Error: Invalid query syntax. Please fix the query");
            }
        }
        invalidQueries.forEach(this._queryWeightMap::remove);
    }

    private void registerColNameFieldType() {
        for (DimensionFieldSpec dimensionFieldSpec : this._schema.getDimensionFieldSpecs()) {
            this._colNameFieldTypeMap.put(dimensionFieldSpec.getName(), dimensionFieldSpec.getDataType());
        }
        for (MetricFieldSpec metricFieldSpec : this._schema.getMetricFieldSpecs()) {
            this._colNameFieldTypeMap.put(metricFieldSpec.getName(), metricFieldSpec.getDataType());
        }
        for (DateTimeFieldSpec dateTimeFieldSpec : this._schema.getDateTimeFieldSpecs()) {
            this._colNameFieldTypeMap.put(dateTimeFieldSpec.getName(), dateTimeFieldSpec.getDataType());
        }
        if (this._schemaWithMetaData.getTimeFieldSpec() != null) {
            this._colNameFieldTypeMap.put(this._schema.getTimeFieldSpec().getName(), this._schema.getTimeFieldSpec().getDataType());
        }
    }

    private void reorderDimsAndBuildMap() throws InvalidInputException {
        String sortedColumn = this._overWrittenConfigs.getIndexConfig().getSortedColumn();
        Set<String> invertedIndexColumns = this._overWrittenConfigs.getIndexConfig().getInvertedIndexColumns();
        Set<String> rangeIndexColumns = this._overWrittenConfigs.getIndexConfig().getRangeIndexColumns();
        Set<String> noDictionaryColumns = this._overWrittenConfigs.getIndexConfig().getNoDictionaryColumns();
        HashSet<String> dimNamesWithAnyIndex = new HashSet<String>();
        dimNamesWithAnyIndex.add(sortedColumn);
        dimNamesWithAnyIndex.addAll(invertedIndexColumns);
        dimNamesWithAnyIndex.addAll(rangeIndexColumns);
        for (String colName : noDictionaryColumns) {
            if (!dimNamesWithAnyIndex.contains(colName)) continue;
            throw new InvalidInputException("Column {0} presents in both overwritten indices and overwritten no dictionary columns", colName);
        }
        for (String colName : noDictionaryColumns) {
            if (this.isSingleValueColumn(colName)) continue;
            throw new InvalidInputException("Column {0} is Multi-Value column and should not be used as NoDictionaryColumns", colName);
        }
        this._dimNames = new HashSet<String>(this._schema.getDimensionNames());
        this._metricNames = new HashSet<String>(this._schema.getMetricNames());
        this._dateTimeNames = new HashSet<String>(this._schema.getDateTimeNames());
        if (this._schema.getTimeFieldSpec() != null) {
            this._dateTimeNames.add(this._schema.getTimeFieldSpec().getName());
        }
        this._intToColNameMap = new String[this._dimNames.size() + this._metricNames.size() + this._dateTimeNames.size()];
        this._colNameToIntMap = new HashMap<String, Integer>();
        this._columnNamesInvertedSortedIndexApplicable = new HashSet<String>(this._dimNames);
        this._columnNamesInvertedSortedIndexApplicable.addAll(this._metricNames);
        this._columnNamesInvertedSortedIndexApplicable.addAll(this._dateTimeNames);
        AtomicInteger counter = new AtomicInteger(0);
        this._columnNamesInvertedSortedIndexApplicable.forEach(name -> {
            this._intToColNameMap[counter.get()] = name;
            this._colNameToIntMap.put((String)name, counter.getAndIncrement());
        });
        this._columnNamesInvertedSortedIndexApplicable.remove(sortedColumn);
        this._columnNamesInvertedSortedIndexApplicable.removeAll(invertedIndexColumns);
        this._columnNamesInvertedSortedIndexApplicable.removeAll(noDictionaryColumns);
        this.LOGGER.debug("_columnNamesInvertedSortedIndexApplicable {}", this._columnNamesInvertedSortedIndexApplicable);
        this.LOGGER.debug("_dimNames{}", this._dimNames);
        this.LOGGER.debug("_metricNames{}", this._metricNames);
        this.LOGGER.debug("_dateTimeNames{}", this._dateTimeNames);
        this.LOGGER.info("*Num dims we can apply index on: {}", (Object)this.getNumColumnsInvertedSortedApplicable());
        this.LOGGER.info("*Col name to int map {} _intToColNameMap {}", this._colNameToIntMap, (Object)this._intToColNameMap);
    }

    @JsonSetter(nulls=Nulls.SKIP)
    public void setSegmentFlushTime(Integer segmentFlushTime) {
        this._segmentFlushTime = segmentFlushTime;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    public void setFlagQueryRuleParams(FlagQueryRuleParams flagQueryRuleParams) {
        this._flagQueryRuleParams = flagQueryRuleParams;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    public void setNumKafkaPartitions(int numKafkaPartitions) {
        this._numKafkaPartitions = numKafkaPartitions;
    }

    @JsonSetter(value="queriesWithWeights", nulls=Nulls.SKIP)
    public void setQueryWeightMap(Map<String, Double> queryWeightMap) {
        this._queryWeightMap = queryWeightMap;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    public void setNoDictionaryOnHeapDictionaryJointRuleParams(NoDictionaryOnHeapDictionaryJointRuleParams noDictionaryOnHeapDictionaryJointRuleParams) {
        this._noDictionaryOnHeapDictionaryJointRuleParams = noDictionaryOnHeapDictionaryJointRuleParams;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    public void setLatencySLA(Long latencySLA) {
        this._latencySLA = latencySLA;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    public void setQps(long qps) {
        this._qps = qps;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    public void setBloomFilterRuleParams(BloomFilterRuleParams bloomFilterRuleParams) {
        this._bloomFilterRuleParams = bloomFilterRuleParams;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    public void setRealtimeProvisioningRuleParams(RealtimeProvisioningRuleParams realtimeProvisioningRuleParams) {
        this._realtimeProvisioningRuleParams = realtimeProvisioningRuleParams;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    public void setPartitionRuleParams(PartitionRuleParams partitionRuleParams) {
        this._partitionRuleParams = partitionRuleParams;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    public void setTableType(String tableType) {
        this._tableType = tableType;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    public void setNumMessagesPerSecInKafkaTopic(long numMessagesPerSecInKafkaTopic) {
        this._numMessagesPerSecInKafkaTopic = numMessagesPerSecInKafkaTopic;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    public void setNumRecordsPerPush(long numRecordsPerPush) {
        this._numRecordsPerPush = numRecordsPerPush;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    public void setRulesToExecute(RulesToExecute rulesToExecute) {
        this._rulesToExecute = rulesToExecute;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    public void setSchema(JsonNode jsonNode) throws IOException {
        ObjectReader reader = new ObjectMapper().readerFor(Schema.class);
        this._schema = (Schema)reader.readValue(jsonNode);
        reader = new ObjectMapper().readerFor(SchemaWithMetaData.class);
        this._schemaWithMetaData = (SchemaWithMetaData)reader.readValue(jsonNode);
        this._schemaWithMetaData.getDimensionFieldSpecs().forEach(fieldMetadata -> this._metaDataMap.put(fieldMetadata.getName(), (FieldMetadata)((Object)fieldMetadata)));
        this._schemaWithMetaData.getMetricFieldSpecs().forEach(fieldMetadata -> this._metaDataMap.put(fieldMetadata.getName(), (FieldMetadata)((Object)fieldMetadata)));
        this._schemaWithMetaData.getDateTimeFieldSpecs().forEach(fieldMetadata -> this._metaDataMap.put(fieldMetadata.getName(), (FieldMetadata)((Object)fieldMetadata)));
        if (this._schemaWithMetaData.getTimeFieldSpec() != null) {
            this._metaDataMap.put(this._schemaWithMetaData.getTimeFieldSpec().getName(), this._schemaWithMetaData.getTimeFieldSpec());
        }
    }

    @JsonIgnore
    public void setMetaDataMap(Map<String, FieldMetadata> metaDataMap) {
        this._metaDataMap = metaDataMap;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    public void setQueryType(String queryType) {
        this._queryType = queryType;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    public void setInvertedSortedIndexJointRuleParams(InvertedSortedIndexJointRuleParams invertedSortedIndexJointRuleParams) {
        this._invertedSortedIndexJointRuleParams = invertedSortedIndexJointRuleParams;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    public void setOverWrittenConfigs(ConfigManager overWrittenConfigs) {
        this._overWrittenConfigs = overWrittenConfigs;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    public void setSegmentSizeRuleParams(SegmentSizeRuleParams segmentSizeRuleParams) {
        this._segmentSizeRuleParams = segmentSizeRuleParams;
    }

    public Set<String> getParsedQueries() {
        return this._parsedQueries.keySet();
    }

    public QueryContext getQueryContext(String query) {
        return (QueryContext)this._parsedQueries.get(query).getRight();
    }

    public BrokerRequest getQueryRequest(String query) {
        return (BrokerRequest)this._parsedQueries.get(query).getMiddle();
    }

    public Double getQueryWeight(String query) {
        return (Double)this._parsedQueries.get(query).getLeft();
    }

    public FlagQueryRuleParams getFlagQueryRuleParams() {
        return this._flagQueryRuleParams;
    }

    @VisibleForTesting
    public FieldSpec.DataType getFieldType(String colName) {
        return this._colNameFieldTypeMap.getOrDefault(colName, null);
    }

    public Map<String, Integer> getColNameToIntMap() {
        return this._colNameToIntMap;
    }

    public Integer getSegmentFlushTime() {
        return this._segmentFlushTime;
    }

    public int getNumColumnsInvertedSortedApplicable() {
        return this._columnNamesInvertedSortedIndexApplicable.size();
    }

    public NoDictionaryOnHeapDictionaryJointRuleParams getNoDictionaryOnHeapDictionaryJointRuleParams() {
        return this._noDictionaryOnHeapDictionaryJointRuleParams;
    }

    public int getNumDims() {
        return this._dimNames.size();
    }

    public int getNumCols() {
        return this._colNameToIntMap.size();
    }

    public Set<String> getTimeColumns() {
        return this._dateTimeNames;
    }

    public Set<String> getColNamesNoDictionary() {
        return this._overWrittenConfigs.getIndexConfig().getNoDictionaryColumns();
    }

    public long getLatencySLA() {
        return this._latencySLA;
    }

    public long getQps() {
        return this._qps;
    }

    public BloomFilterRuleParams getBloomFilterRuleParams() {
        return this._bloomFilterRuleParams;
    }

    public RangeIndexRuleParams getRangeIndexRuleParams() {
        return this._rangeIndexRuleParams;
    }

    public RealtimeProvisioningRuleParams getRealtimeProvisioningRuleParams() {
        return this._realtimeProvisioningRuleParams;
    }

    public PartitionRuleParams getPartitionRuleParams() {
        return this._partitionRuleParams;
    }

    public String getTableType() {
        return this._tableType;
    }

    public long getNumMessagesPerSecInKafkaTopic() {
        return this._numMessagesPerSecInKafkaTopic;
    }

    public long getNumRecordsPerPush() {
        return this._numRecordsPerPush;
    }

    public RulesToExecute getRulesToExecute() {
        return this._rulesToExecute;
    }

    public Schema getSchema() {
        return this._schema;
    }

    public SchemaWithMetaData getSchemaWithMetadata() {
        return this._schemaWithMetaData;
    }

    @JsonIgnore
    public Map<String, FieldMetadata> getMetaDataMap() {
        return this._metaDataMap;
    }

    public String getQueryType() {
        return this._queryType;
    }

    public InvertedSortedIndexJointRuleParams getInvertedSortedIndexJointRuleParams() {
        return this._invertedSortedIndexJointRuleParams;
    }

    public ConfigManager getOverWrittenConfigs() {
        return this._overWrittenConfigs;
    }

    public SegmentSizeRuleParams getSegmentSizeRuleParams() {
        return this._segmentSizeRuleParams;
    }

    public long getSizePerRecord() {
        return this._sizePerRecord;
    }

    public double getCardinality(String columnName) {
        return Math.max((double)this._metaDataMap.getOrDefault(columnName, new FieldMetadata()).getCardinality(), 1.0);
    }

    public double getNumValuesPerEntry(String columnName) {
        return this._metaDataMap.getOrDefault(columnName, new FieldMetadata()).getNumValuesPerEntry();
    }

    public int getAverageDataLen(String columnName) {
        return this._metaDataMap.getOrDefault(columnName, new FieldMetadata()).getAverageLength();
    }

    public int getNumKafkaPartitions() {
        return this._numKafkaPartitions;
    }

    public boolean isIndexableDim(String colName) {
        return this._columnNamesInvertedSortedIndexApplicable.contains(colName);
    }

    public boolean isSingleValueColumn(String colName) {
        FieldMetadata fieldMetadata = this._metaDataMap.getOrDefault(colName, new FieldMetadata());
        return fieldMetadata.isSingleValueField() && fieldMetadata.getNumValuesPerEntry() < 1.0001;
    }

    public int colNameToInt(String colName) {
        return this._colNameToIntMap.getOrDefault(colName, -1);
    }

    public String intToColName(int colID) {
        return this._intToColNameMap[colID];
    }

    public boolean isDim(String colName) {
        return this._dimNames.contains(colName);
    }

    public boolean isTimeOrDateTimeColumn(String colName) {
        return colName != null && this.getTimeColumns().stream().anyMatch(d -> colName.equalsIgnoreCase((String)d));
    }

    public void estimateSizePerRecord() throws InvalidInputException {
        for (String colName : this._colNameFieldTypeMap.keySet()) {
            this._sizePerRecord += this.getColDataSizeWithDictionaryConfig(colName);
            this.LOGGER.debug("{} {}", (Object)colName, (Object)this.getColDataSizeWithDictionaryConfig(colName));
        }
        this.LOGGER.info("*Estimated size per record {} bytes", (Object)this._sizePerRecord);
    }

    public long getColRawSizePerDoc(String colName) throws InvalidInputException {
        FieldSpec.DataType dataType = this.getFieldType(colName);
        if (dataType == FieldSpec.DataType.STRUCT || dataType == FieldSpec.DataType.MAP || dataType == FieldSpec.DataType.LIST) {
            return 0L;
        }
        if (!this.isSingleValueColumn(colName)) {
            throw new InvalidInputException("Column {0} is MV column should not have raw encoding!", colName);
        }
        if (dataType == FieldSpec.DataType.BYTES || dataType == FieldSpec.DataType.STRING) {
            return this._dataTypeSizeMap.get(dataType) * this.getAverageDataLen(colName);
        }
        return this._dataTypeSizeMap.get(dataType).intValue();
    }

    public long getColDataSizeWithDictionaryConfig(String colName) throws InvalidInputException {
        FieldSpec.DataType dataType = this.getFieldType(colName);
        double numValuesPerEntry = this.getNumValuesPerEntry(colName);
        if (dataType == FieldSpec.DataType.STRUCT || dataType == FieldSpec.DataType.MAP || dataType == FieldSpec.DataType.LIST) {
            return 0L;
        }
        if (this._overWrittenConfigs.getIndexConfig().getNoDictionaryColumns().contains(colName) && this.isSingleValueColumn(colName)) {
            return this.getColRawSizePerDoc(colName);
        }
        return (long)Math.ceil((double)this.getDictionaryEncodedForwardIndexSize(colName) * numValuesPerEntry);
    }

    public int getDictionaryEncodedForwardIndexSize(String colName) {
        return Math.max((int)Math.ceil(Math.log(this.getCardinality(colName)) / (8.0 * Math.log(2.0))), 1);
    }

    public long getDictionarySize(String colName) {
        FieldSpec.DataType dataType = this.getFieldType(colName);
        if (dataType == FieldSpec.DataType.STRUCT || dataType == FieldSpec.DataType.MAP || dataType == FieldSpec.DataType.LIST) {
            return 0L;
        }
        if (dataType == FieldSpec.DataType.BYTES || dataType == FieldSpec.DataType.STRING) {
            return (long)Math.ceil(this.getCardinality(colName) * (double)(this._dataTypeSizeMap.get(dataType) * this.getAverageDataLen(colName)));
        }
        return (long)Math.ceil(this.getCardinality(colName) * (double)this._dataTypeSizeMap.get(dataType).intValue());
    }
}

