/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.recommender.realtime.provisioning;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.math.IntRange;
import org.apache.pinot.common.metadata.segment.RealtimeSegmentZKMetadata;
import org.apache.pinot.controller.recommender.data.generator.DataGenerator;
import org.apache.pinot.controller.recommender.data.generator.DataGeneratorSpec;
import org.apache.pinot.controller.recommender.io.metadata.DateTimeFieldSpecMetadata;
import org.apache.pinot.controller.recommender.io.metadata.FieldMetadata;
import org.apache.pinot.controller.recommender.io.metadata.SchemaWithMetaData;
import org.apache.pinot.controller.recommender.io.metadata.TimeFieldSpecMetadata;
import org.apache.pinot.controller.recommender.io.metadata.TimeGranularitySpecMetadata;
import org.apache.pinot.segment.local.indexsegment.immutable.ImmutableSegmentLoader;
import org.apache.pinot.segment.local.indexsegment.mutable.MutableSegmentImpl;
import org.apache.pinot.segment.local.io.readerwriter.PinotDataBufferMemoryManager;
import org.apache.pinot.segment.local.io.writer.impl.DirectMemoryManager;
import org.apache.pinot.segment.local.realtime.impl.RealtimeSegmentConfig;
import org.apache.pinot.segment.local.realtime.impl.RealtimeSegmentStatsHistory;
import org.apache.pinot.segment.local.segment.creator.impl.SegmentIndexCreationDriverImpl;
import org.apache.pinot.segment.local.segment.readers.PinotSegmentRecordReader;
import org.apache.pinot.segment.spi.ImmutableSegment;
import org.apache.pinot.segment.spi.creator.SegmentGeneratorConfig;
import org.apache.pinot.segment.spi.index.metadata.SegmentMetadataImpl;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.DateTimeFormatSpec;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.FileFormat;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.utils.DataSizeUtils;
import org.apache.pinot.spi.utils.ReadMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryEstimator {
    private static final String NOT_APPLICABLE = "NA";
    private static final String STATS_FILE_NAME = "stats.ser";
    private static final String STATS_FILE_COPY_NAME = "stats.copy.ser";
    private final TableConfig _tableConfig;
    private final String _tableNameWithType;
    private final File _sampleCompletedSegment;
    private final long _sampleSegmentConsumedSeconds;
    private final int _totalDocsInSampleSegment;
    private final long _maxUsableHostMemory;
    private final int _tableRetentionHours;
    private SegmentMetadataImpl _segmentMetadata;
    private long _sampleCompletedSegmentSizeBytes;
    private Set<String> _invertedIndexColumns = new HashSet<String>();
    private Set<String> _noDictionaryColumns = new HashSet<String>();
    private Set<String> _varLengthDictionaryColumns = new HashSet<String>();
    int _avgMultiValues;
    private File _workingDir;
    private String[][] _activeMemoryPerHost;
    private String[][] _optimalSegmentSize;
    private String[][] _consumingMemoryPerHost;
    private String[][] _numSegmentsQueriedPerHost;

    public MemoryEstimator(TableConfig tableConfig, File sampleCompletedSegment, int ingestionRatePerPartition, long maxUsableHostMemory, int tableRetentionHours, File workingDir) {
        this._maxUsableHostMemory = maxUsableHostMemory;
        this._tableConfig = tableConfig;
        this._tableNameWithType = tableConfig.getTableName();
        this._sampleCompletedSegment = sampleCompletedSegment;
        this._tableRetentionHours = tableRetentionHours;
        this._sampleCompletedSegmentSizeBytes = FileUtils.sizeOfDirectory((File)this._sampleCompletedSegment);
        try {
            this._segmentMetadata = new SegmentMetadataImpl(this._sampleCompletedSegment);
        }
        catch (Exception e) {
            throw new RuntimeException("Caught exception when reading segment index dir", e);
        }
        this._totalDocsInSampleSegment = this._segmentMetadata.getTotalDocs();
        this._sampleSegmentConsumedSeconds = this._totalDocsInSampleSegment / ingestionRatePerPartition;
        if (CollectionUtils.isNotEmpty((Collection)this._tableConfig.getIndexingConfig().getNoDictionaryColumns())) {
            this._noDictionaryColumns.addAll(this._tableConfig.getIndexingConfig().getNoDictionaryColumns());
        }
        if (CollectionUtils.isNotEmpty((Collection)this._tableConfig.getIndexingConfig().getVarLengthDictionaryColumns())) {
            this._varLengthDictionaryColumns.addAll(this._tableConfig.getIndexingConfig().getVarLengthDictionaryColumns());
        }
        if (CollectionUtils.isNotEmpty((Collection)this._tableConfig.getIndexingConfig().getInvertedIndexColumns())) {
            this._invertedIndexColumns.addAll(this._tableConfig.getIndexingConfig().getInvertedIndexColumns());
        }
        this._avgMultiValues = this.getAvgMultiValues();
        this._workingDir = workingDir;
    }

    public MemoryEstimator(TableConfig tableConfig, Schema schema, SchemaWithMetaData schemaWithMetadata, int numberOfRows, int ingestionRatePerPartition, long maxUsableHostMemory, int tableRetentionHours, File workingDir) {
        this(tableConfig, MemoryEstimator.generateCompletedSegment(schemaWithMetadata, schema, tableConfig, numberOfRows, workingDir), ingestionRatePerPartition, maxUsableHostMemory, tableRetentionHours, workingDir);
    }

    public File initializeStatsHistory() {
        RealtimeSegmentStatsHistory sampleStatsHistory;
        File statsFile = new File(this._workingDir, STATS_FILE_NAME);
        try {
            sampleStatsHistory = RealtimeSegmentStatsHistory.deserialzeFrom((File)statsFile);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException("Exception when deserializing stats history from stats file " + statsFile.getAbsolutePath(), e);
        }
        DirectMemoryManager memoryManager = new DirectMemoryManager(this._segmentMetadata.getName());
        RealtimeSegmentZKMetadata segmentZKMetadata = this.getRealtimeSegmentZKMetadata(this._segmentMetadata, this._segmentMetadata.getTotalDocs());
        RealtimeSegmentConfig.Builder realtimeSegmentConfigBuilder = new RealtimeSegmentConfig.Builder().setTableNameWithType(this._tableNameWithType).setSegmentName(this._segmentMetadata.getName()).setStreamName(this._tableNameWithType).setSchema(this._segmentMetadata.getSchema()).setCapacity(this._segmentMetadata.getTotalDocs()).setAvgNumMultiValues(this._avgMultiValues).setNoDictionaryColumns(this._noDictionaryColumns).setVarLengthDictionaryColumns(this._varLengthDictionaryColumns).setInvertedIndexColumns(this._invertedIndexColumns).setRealtimeSegmentZKMetadata(segmentZKMetadata).setOffHeap(true).setMemoryManager((PinotDataBufferMemoryManager)memoryManager).setStatsHistory(sampleStatsHistory);
        MutableSegmentImpl mutableSegmentImpl = new MutableSegmentImpl(realtimeSegmentConfigBuilder.build(), null);
        try (PinotSegmentRecordReader segmentRecordReader = new PinotSegmentRecordReader(this._sampleCompletedSegment);){
            GenericRow row = new GenericRow();
            while (segmentRecordReader.hasNext()) {
                row = segmentRecordReader.next(row);
                mutableSegmentImpl.index(row, null);
                row.clear();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Caught exception when indexing rows");
        }
        mutableSegmentImpl.destroy();
        return statsFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void estimateMemoryUsed(File statsFile, int[] numHosts, int[] numHours, int totalConsumingPartitions, int retentionHours) throws IOException {
        int i;
        this._activeMemoryPerHost = new String[numHours.length][numHosts.length];
        this._optimalSegmentSize = new String[numHours.length][numHosts.length];
        this._consumingMemoryPerHost = new String[numHours.length][numHosts.length];
        this._numSegmentsQueriedPerHost = new String[numHours.length][numHosts.length];
        for (i = 0; i < numHours.length; ++i) {
            for (int j = 0; j < numHosts.length; ++j) {
                this._activeMemoryPerHost[i][j] = NOT_APPLICABLE;
                this._consumingMemoryPerHost[i][j] = NOT_APPLICABLE;
                this._optimalSegmentSize[i][j] = NOT_APPLICABLE;
                this._numSegmentsQueriedPerHost[i][j] = NOT_APPLICABLE;
            }
        }
        try {
            for (i = 0; i < numHours.length; ++i) {
                int numHoursToConsume = numHours[i];
                if (numHoursToConsume > retentionHours) continue;
                long secondsToConsume = numHoursToConsume * 3600;
                long completedSegmentSizeBytes = (long)((double)secondsToConsume / (double)this._sampleSegmentConsumedSeconds * (double)this._sampleCompletedSegmentSizeBytes);
                int totalDocs = (int)((double)secondsToConsume / (double)this._sampleSegmentConsumedSeconds * (double)this._totalDocsInSampleSegment);
                long memoryForConsumingSegmentPerPartition = this.getMemoryForConsumingSegmentPerPartition(statsFile, totalDocs);
                memoryForConsumingSegmentPerPartition += this.getMemoryForInvertedIndex(memoryForConsumingSegmentPerPartition);
                int numActiveSegmentsPerPartition = (retentionHours + numHoursToConsume - 1) / numHoursToConsume;
                long activeMemoryForCompletedSegmentsPerPartition = completedSegmentSizeBytes * (long)(numActiveSegmentsPerPartition - 1);
                int numCompletedSegmentsPerPartition = (this._tableRetentionHours + numHoursToConsume - 1) / numHoursToConsume - 1;
                for (int j = 0; j < numHosts.length; ++j) {
                    int numHostsToProvision = numHosts[j];
                    int totalConsumingPartitionsPerHost = (totalConsumingPartitions + numHostsToProvision - 1) / numHostsToProvision;
                    long activeMemoryForCompletedSegmentsPerHost = activeMemoryForCompletedSegmentsPerPartition * (long)totalConsumingPartitionsPerHost;
                    long totalMemoryForConsumingSegmentsPerHost = memoryForConsumingSegmentPerPartition * (long)totalConsumingPartitionsPerHost;
                    long activeMemoryPerHostBytes = activeMemoryForCompletedSegmentsPerHost + totalMemoryForConsumingSegmentsPerHost;
                    long mappedMemoryPerHost = totalMemoryForConsumingSegmentsPerHost + (long)(numCompletedSegmentsPerPartition * totalConsumingPartitionsPerHost) * completedSegmentSizeBytes;
                    if (activeMemoryPerHostBytes > this._maxUsableHostMemory) continue;
                    this._activeMemoryPerHost[i][j] = DataSizeUtils.fromBytes((long)activeMemoryPerHostBytes) + "/" + DataSizeUtils.fromBytes((long)mappedMemoryPerHost);
                    this._consumingMemoryPerHost[i][j] = DataSizeUtils.fromBytes((long)totalMemoryForConsumingSegmentsPerHost);
                    this._optimalSegmentSize[i][j] = DataSizeUtils.fromBytes((long)completedSegmentSizeBytes);
                    this._numSegmentsQueriedPerHost[i][j] = String.valueOf(numActiveSegmentsPerPartition * totalConsumingPartitionsPerHost);
                }
            }
        }
        finally {
            FileUtils.deleteQuietly((File)this._workingDir);
        }
    }

    private long getMemoryForConsumingSegmentPerPartition(File statsFile, int totalDocs) throws IOException {
        RealtimeSegmentStatsHistory statsHistory;
        File statsFileCopy = new File(this._workingDir, STATS_FILE_COPY_NAME);
        FileUtils.copyFile((File)statsFile, (File)statsFileCopy);
        try {
            statsHistory = RealtimeSegmentStatsHistory.deserialzeFrom((File)statsFileCopy);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException("Exception when deserializing stats history from stats file " + statsFileCopy.getAbsolutePath(), e);
        }
        DirectMemoryManager memoryManager = new DirectMemoryManager(this._segmentMetadata.getName());
        RealtimeSegmentZKMetadata segmentZKMetadata = this.getRealtimeSegmentZKMetadata(this._segmentMetadata, totalDocs);
        RealtimeSegmentConfig.Builder realtimeSegmentConfigBuilder = new RealtimeSegmentConfig.Builder().setTableNameWithType(this._tableNameWithType).setSegmentName(this._segmentMetadata.getName()).setStreamName(this._tableNameWithType).setSchema(this._segmentMetadata.getSchema()).setCapacity(totalDocs).setAvgNumMultiValues(this._avgMultiValues).setNoDictionaryColumns(this._noDictionaryColumns).setVarLengthDictionaryColumns(this._varLengthDictionaryColumns).setInvertedIndexColumns(this._invertedIndexColumns).setRealtimeSegmentZKMetadata(segmentZKMetadata).setOffHeap(true).setMemoryManager((PinotDataBufferMemoryManager)memoryManager).setStatsHistory(statsHistory);
        MutableSegmentImpl mutableSegmentImpl = new MutableSegmentImpl(realtimeSegmentConfigBuilder.build(), null);
        long memoryForConsumingSegmentPerPartition = memoryManager.getTotalAllocatedBytes();
        mutableSegmentImpl.destroy();
        FileUtils.deleteQuietly((File)statsFileCopy);
        return memoryForConsumingSegmentPerPartition;
    }

    private int getAvgMultiValues() {
        int avgMultiValues = 0;
        Set multiValueColumns = this._segmentMetadata.getSchema().getAllFieldSpecs().stream().filter(fieldSpec -> !fieldSpec.isSingleValueField()).map(FieldSpec::getName).collect(Collectors.toSet());
        if (!multiValueColumns.isEmpty()) {
            int numValues = 0;
            long multiValuesSum = 0L;
            try {
                PinotSegmentRecordReader segmentRecordReader = new PinotSegmentRecordReader(this._sampleCompletedSegment);
                GenericRow row = new GenericRow();
                while (segmentRecordReader.hasNext()) {
                    row = segmentRecordReader.next(row);
                    for (String multiValueColumn : multiValueColumns) {
                        multiValuesSum += (long)((Object[])row.getValue(multiValueColumn)).length;
                        ++numValues;
                    }
                    row.clear();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Caught exception when calculating avg multi values");
            }
            avgMultiValues = (int)(((double)multiValuesSum + (double)numValues - 1.0) / (double)numValues);
        }
        return avgMultiValues;
    }

    private long getMemoryForInvertedIndex(long totalMemoryForConsumingSegment) {
        long totalInvertedIndexSizeBytes = 0L;
        if (!this._invertedIndexColumns.isEmpty()) {
            long memoryForEachColumn = totalMemoryForConsumingSegment / (long)this._segmentMetadata.getAllColumns().size();
            totalInvertedIndexSizeBytes = (long)((double)memoryForEachColumn * 0.3 * (double)this._invertedIndexColumns.size());
        }
        return totalInvertedIndexSizeBytes;
    }

    private RealtimeSegmentZKMetadata getRealtimeSegmentZKMetadata(SegmentMetadataImpl segmentMetadata, int totalDocs) {
        RealtimeSegmentZKMetadata realtimeSegmentZKMetadata = new RealtimeSegmentZKMetadata();
        realtimeSegmentZKMetadata.setStartTime(segmentMetadata.getStartTime());
        realtimeSegmentZKMetadata.setEndTime(segmentMetadata.getEndTime());
        realtimeSegmentZKMetadata.setCreationTime(segmentMetadata.getIndexCreationTime());
        realtimeSegmentZKMetadata.setSegmentName(segmentMetadata.getName());
        realtimeSegmentZKMetadata.setTimeUnit(segmentMetadata.getTimeUnit());
        realtimeSegmentZKMetadata.setTotalDocs((long)totalDocs);
        realtimeSegmentZKMetadata.setCrc(Long.parseLong(segmentMetadata.getCrc()));
        return realtimeSegmentZKMetadata;
    }

    private long calculateMemoryForCompletedSegmentsPerPartition(long completedSegmentSizeBytes, int numHoursToConsume, int retentionHours) {
        int numSegmentsInMemory = (retentionHours + numHoursToConsume - 1) / numHoursToConsume;
        return completedSegmentSizeBytes * (long)(numSegmentsInMemory - 1);
    }

    public String[][] getActiveMemoryPerHost() {
        return this._activeMemoryPerHost;
    }

    public String[][] getOptimalSegmentSize() {
        return this._optimalSegmentSize;
    }

    public String[][] getConsumingMemoryPerHost() {
        return this._consumingMemoryPerHost;
    }

    public String[][] getNumSegmentsQueriedPerHost() {
        return this._numSegmentsQueriedPerHost;
    }

    private static File generateCompletedSegment(SchemaWithMetaData schemaWithMetadata, Schema schema, TableConfig tableConfig, int numberOfRows, File workingDir) {
        return new SegmentGenerator(schemaWithMetadata, schema, tableConfig, numberOfRows, true, workingDir).generate();
    }

    public static class SegmentGenerator {
        private static final Logger LOGGER = LoggerFactory.getLogger(SegmentGenerator.class);
        private SchemaWithMetaData _schemaWithMetadata;
        private Schema _schema;
        private TableConfig _tableConfig;
        private int _numberOfRows;
        private boolean _deleteCsv;
        private File _workingDir;

        public SegmentGenerator(SchemaWithMetaData schemaWithMetadata, Schema schema, TableConfig tableConfig, int numberOfRows, boolean deleteCsv, File workingDir) {
            this._schemaWithMetadata = schemaWithMetadata;
            this._schema = schema;
            this._tableConfig = tableConfig;
            this._numberOfRows = numberOfRows;
            this._deleteCsv = deleteCsv;
            this._workingDir = workingDir;
        }

        public File generate() {
            File csvDataFile = this.generateData();
            File segment = this.createSegment(csvDataFile);
            if (this._deleteCsv) {
                File csvDir = csvDataFile.getParentFile();
                FileUtils.deleteQuietly((File)csvDir);
            }
            return segment;
        }

        private File generateData() {
            HashMap<String, Integer> lengths = new HashMap<String, Integer>();
            HashMap<String, Double> mvCounts = new HashMap<String, Double>();
            HashMap<String, Integer> cardinalities = new HashMap<String, Integer>();
            HashMap<String, FieldSpec.DataType> dataTypes = new HashMap<String, FieldSpec.DataType>();
            HashMap<String, FieldSpec.FieldType> fieldTypes = new HashMap<String, FieldSpec.FieldType>();
            HashMap<String, TimeUnit> timeUnits = new HashMap<String, TimeUnit>();
            ArrayList<String> colNames = new ArrayList<String>();
            List<FieldMetadata> dimensions = this._schemaWithMetadata.getDimensionFieldSpecs();
            List<FieldMetadata> metrics = this._schemaWithMetadata.getMetricFieldSpecs();
            List<DateTimeFieldSpecMetadata> dateTimes = this._schemaWithMetadata.getDateTimeFieldSpecs();
            Stream.concat(Stream.concat(dimensions.stream(), metrics.stream()), dateTimes.stream()).forEach(column -> {
                String name = column.getName();
                colNames.add(name);
                lengths.put(name, column.getAverageLength());
                mvCounts.put(name, column.getNumValuesPerEntry());
                cardinalities.put(name, column.getCardinality());
                dataTypes.put(name, column.getDataType());
                fieldTypes.put(name, column.getFieldType());
            });
            dateTimes.forEach(dateTimeColumn -> {
                TimeUnit timeUnit = new DateTimeFormatSpec(dateTimeColumn.getFormat()).getColumnUnit();
                timeUnits.put(dateTimeColumn.getName(), timeUnit);
            });
            TimeFieldSpecMetadata timeSpec = this._schemaWithMetadata.getTimeFieldSpec();
            if (timeSpec != null) {
                String name = timeSpec.getName();
                colNames.add(name);
                cardinalities.put(name, timeSpec.getCardinality());
                dataTypes.put(name, timeSpec.getDataType());
                fieldTypes.put(name, timeSpec.getFieldType());
                TimeGranularitySpecMetadata timeGranSpec = timeSpec.getOutgoingGranularitySpec() != null ? timeSpec.getOutgoingGranularitySpec() : timeSpec.getIncomingGranularitySpec();
                timeUnits.put(name, timeGranSpec.getTimeType());
            }
            String outputDir = new File(this._workingDir, "csv").getAbsolutePath();
            DataGeneratorSpec spec = new DataGeneratorSpec(colNames, cardinalities, new HashMap<String, IntRange>(), new HashMap<String, Map<String, Object>>(), mvCounts, lengths, dataTypes, fieldTypes, timeUnits, FileFormat.CSV, outputDir, true);
            DataGenerator dataGenerator = new DataGenerator();
            try {
                dataGenerator.init(spec);
                dataGenerator.generateCsv(this._numberOfRows, 1);
                File outputFile = Paths.get(outputDir, "output_0.csv").toFile();
                LOGGER.info("Successfully generated data file: {}", (Object)outputFile);
                return outputFile;
            }
            catch (Exception e) {
                FileUtils.deleteQuietly((File)new File(outputDir));
                throw new RuntimeException(e);
            }
        }

        private File createSegment(File csvDataFile) {
            ImmutableSegment segment;
            LOGGER.info("Started creating segment from file: {}", (Object)csvDataFile);
            String outDir = new File(this._workingDir, "segment").getAbsolutePath();
            SegmentGeneratorConfig segmentGeneratorConfig = this.getSegmentGeneratorConfig(csvDataFile, outDir);
            SegmentIndexCreationDriverImpl driver = new SegmentIndexCreationDriverImpl();
            try {
                driver.init(segmentGeneratorConfig);
                driver.build();
            }
            catch (Exception e) {
                FileUtils.deleteQuietly((File)new File(outDir));
                File csvDir = csvDataFile.getParentFile();
                FileUtils.deleteQuietly((File)csvDir);
                throw new RuntimeException("Caught exception while generating segment from file: " + csvDataFile, e);
            }
            String segmentName = driver.getSegmentName();
            File indexDir = new File(outDir, segmentName);
            LOGGER.info("Successfully created segment: {} at directory: {}", (Object)segmentName, (Object)indexDir);
            LOGGER.info("Verifying the segment by loading it");
            try {
                segment = ImmutableSegmentLoader.load((File)indexDir, (ReadMode)ReadMode.mmap);
            }
            catch (Exception e) {
                throw new RuntimeException("Caught exception while verifying the created segment", e);
            }
            LOGGER.info("Successfully loaded segment: {} of size: {} bytes", (Object)segmentName, (Object)segment.getSegmentSizeBytes());
            segment.destroy();
            return indexDir;
        }

        private SegmentGeneratorConfig getSegmentGeneratorConfig(File csvDataFile, String outDir) {
            SegmentGeneratorConfig segmentGeneratorConfig = new SegmentGeneratorConfig(this._tableConfig, this._schema);
            segmentGeneratorConfig.setInputFilePath(csvDataFile.getPath());
            segmentGeneratorConfig.setFormat(FileFormat.CSV);
            segmentGeneratorConfig.setOutDir(outDir);
            segmentGeneratorConfig.setTableName(this._tableConfig.getTableName());
            segmentGeneratorConfig.setSequenceId(0);
            return segmentGeneratorConfig;
        }
    }
}

