/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.recommender.rules;

import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import org.apache.pinot.controller.recommender.io.ConfigManager;
import org.apache.pinot.controller.recommender.io.InputManager;
import org.apache.pinot.controller.recommender.rules.AbstractRule;
import org.apache.pinot.controller.recommender.rules.impl.AggregateMetricsRule;
import org.apache.pinot.controller.recommender.rules.impl.BloomFilterRule;
import org.apache.pinot.controller.recommender.rules.impl.FlagQueryRule;
import org.apache.pinot.controller.recommender.rules.impl.InvertedSortedIndexJointRule;
import org.apache.pinot.controller.recommender.rules.impl.KafkaPartitionRule;
import org.apache.pinot.controller.recommender.rules.impl.NoDictionaryOnHeapDictionaryJointRule;
import org.apache.pinot.controller.recommender.rules.impl.PinotTablePartitionRule;
import org.apache.pinot.controller.recommender.rules.impl.RangeIndexRule;
import org.apache.pinot.controller.recommender.rules.impl.RealtimeProvisioningRule;
import org.apache.pinot.controller.recommender.rules.impl.SegmentSizeRule;
import org.apache.pinot.controller.recommender.rules.impl.VariedLengthDictionaryRule;

public class RulesToExecute {
    boolean _recommendSegmentSize = true;
    boolean _recommendKafkaPartition = true;
    boolean _recommendPinotTablePartition = true;
    boolean _recommendInvertedSortedIndexJoint = true;
    boolean _recommendBloomFilter = true;
    boolean _recommendRangeIndex = true;
    boolean _recommendNoDictionaryOnHeapDictionaryJoint = true;
    boolean _recommendVariedLengthDictionary = true;
    boolean _recommendFlagQuery = true;
    boolean _recommendAggregateMetrics = true;
    boolean _recommendRealtimeProvisioning = true;

    @JsonSetter(nulls=Nulls.SKIP)
    public void setRecommendVariedLengthDictionary(boolean recommendVariedLengthDictionary) {
        this._recommendVariedLengthDictionary = recommendVariedLengthDictionary;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    public void setRecommendFlagQuery(boolean recommendFlagQuery) {
        this._recommendFlagQuery = recommendFlagQuery;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    public void setRecommendNoDictionaryOnHeapDictionaryJoint(boolean recommendNoDictionaryOnHeapDictionaryJoint) {
        this._recommendNoDictionaryOnHeapDictionaryJoint = recommendNoDictionaryOnHeapDictionaryJoint;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    public void setRecommendKafkaPartition(boolean recommendKafkaPartition) {
        this._recommendKafkaPartition = recommendKafkaPartition;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    public void setRecommendInvertedSortedIndexJoint(boolean recommendInvertedSortedIndexJoint) {
        this._recommendInvertedSortedIndexJoint = recommendInvertedSortedIndexJoint;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    public void setRecommendPinotTablePartition(boolean recommendPinotTablePartition) {
        this._recommendPinotTablePartition = recommendPinotTablePartition;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    public void setRecommendBloomFilter(boolean recommendBloomFilter) {
        this._recommendBloomFilter = recommendBloomFilter;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    public void setRecommendRangeIndex(boolean recommendRangeIndex) {
        this._recommendRangeIndex = recommendRangeIndex;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    public void setRecommendAggregateMetrics(boolean aggregateMetrics) {
        this._recommendAggregateMetrics = aggregateMetrics;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    public void setRecommendRealtimeProvisioning(boolean recommendRealtimeProvisioning) {
        this._recommendRealtimeProvisioning = recommendRealtimeProvisioning;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    public void setRecommendSegmentSize(boolean recommendSegmentSize) {
        this._recommendSegmentSize = recommendSegmentSize;
    }

    public boolean isRecommendVariedLengthDictionary() {
        return this._recommendVariedLengthDictionary;
    }

    public boolean isRecommendFlagQuery() {
        return this._recommendFlagQuery;
    }

    public boolean isRecommendNoDictionaryOnHeapDictionaryJoint() {
        return this._recommendNoDictionaryOnHeapDictionaryJoint;
    }

    public boolean isRecommendKafkaPartition() {
        return this._recommendKafkaPartition;
    }

    public boolean isRecommendInvertedSortedIndexJoint() {
        return this._recommendInvertedSortedIndexJoint;
    }

    public boolean isRecommendPinotTablePartition() {
        return this._recommendPinotTablePartition;
    }

    public boolean isRecommendBloomFilter() {
        return this._recommendBloomFilter;
    }

    public boolean isRecommendRangeIndex() {
        return this._recommendRangeIndex;
    }

    public boolean isRecommendAggregateMetrics() {
        return this._recommendAggregateMetrics;
    }

    public boolean isRecommendRealtimeProvisioning() {
        return this._recommendRealtimeProvisioning;
    }

    public boolean isRecommendSegmentSize() {
        return this._recommendSegmentSize;
    }

    public static enum Rule {
        SegmentSizeRule,
        FlagQueryRule,
        KafkaPartitionRule,
        InvertedSortedIndexJointRule,
        NoDictionaryOnHeapDictionaryJointRule,
        VariedLengthDictionaryRule,
        PinotTablePartitionRule,
        BloomFilterRule,
        RangeIndexRule,
        AggregateMetricsRule,
        RealtimeProvisioningRule;

    }

    public static class RuleFactory {
        public static AbstractRule getRule(Rule rule, InputManager inputManager, ConfigManager outputManager) {
            switch (rule) {
                case SegmentSizeRule: {
                    return new SegmentSizeRule(inputManager, outputManager);
                }
                case FlagQueryRule: {
                    return new FlagQueryRule(inputManager, outputManager);
                }
                case InvertedSortedIndexJointRule: {
                    return new InvertedSortedIndexJointRule(inputManager, outputManager);
                }
                case KafkaPartitionRule: {
                    return new KafkaPartitionRule(inputManager, outputManager);
                }
                case PinotTablePartitionRule: {
                    return new PinotTablePartitionRule(inputManager, outputManager);
                }
                case BloomFilterRule: {
                    return new BloomFilterRule(inputManager, outputManager);
                }
                case RangeIndexRule: {
                    return new RangeIndexRule(inputManager, outputManager);
                }
                case NoDictionaryOnHeapDictionaryJointRule: {
                    return new NoDictionaryOnHeapDictionaryJointRule(inputManager, outputManager);
                }
                case VariedLengthDictionaryRule: {
                    return new VariedLengthDictionaryRule(inputManager, outputManager);
                }
                case AggregateMetricsRule: {
                    return new AggregateMetricsRule(inputManager, outputManager);
                }
                case RealtimeProvisioningRule: {
                    return new RealtimeProvisioningRule(inputManager, outputManager);
                }
            }
            return null;
        }
    }
}

