/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.recommender.rules.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.FunctionContext;
import org.apache.pinot.controller.recommender.exceptions.InvalidInputException;
import org.apache.pinot.controller.recommender.io.ConfigManager;
import org.apache.pinot.controller.recommender.io.InputManager;
import org.apache.pinot.controller.recommender.rules.AbstractRule;
import org.apache.pinot.core.query.request.context.QueryContext;

public class AggregateMetricsRule
extends AbstractRule {
    public AggregateMetricsRule(InputManager input, ConfigManager output) {
        super(input, output);
    }

    @Override
    public void run() throws InvalidInputException {
        String tableType = this._input.getTableType();
        if (tableType.equalsIgnoreCase("realtime") || tableType.equalsIgnoreCase("hybrid")) {
            this._output.setAggregateMetrics(this.shouldAggregate(this._input));
        }
    }

    private boolean shouldAggregate(InputManager inputManager) {
        HashSet<String> metricNames = new HashSet<String>(inputManager.getSchema().getMetricNames());
        for (String query : inputManager.getParsedQueries()) {
            QueryContext queryContext = inputManager.getQueryContext(query);
            Set<ExpressionContext> groupByExprs = this.getGroupByExpressions(queryContext);
            for (ExpressionContext selectExpr : queryContext.getSelectExpressions()) {
                if (groupByExprs.contains(selectExpr)) continue;
                FunctionContext funcCtx = selectExpr.getFunction();
                if (selectExpr.getType() == ExpressionContext.Type.FUNCTION && funcCtx.getFunctionName().equalsIgnoreCase("SUM") && !this.hasNonMetricArguments(funcCtx.getArguments(), metricNames)) continue;
                return false;
            }
        }
        return true;
    }

    private Set<ExpressionContext> getGroupByExpressions(QueryContext queryContext) {
        List groupByExprs = queryContext.getGroupByExpressions();
        if (groupByExprs == null) {
            return Collections.emptySet();
        }
        return new HashSet<ExpressionContext>(groupByExprs);
    }

    private boolean hasNonMetricArguments(List<ExpressionContext> arguments, Set<String> metricNames) {
        for (ExpressionContext arg : arguments) {
            if (!(arg.getType() == ExpressionContext.Type.IDENTIFIER ? !metricNames.contains(arg.getIdentifier()) : arg.getType() == ExpressionContext.Type.FUNCTION && this.hasNonMetricArguments(arg.getFunction().getArguments(), metricNames))) continue;
            return true;
        }
        return false;
    }
}

