/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.recommender.rules.impl;

import com.google.common.util.concurrent.AtomicDouble;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.FilterContext;
import org.apache.pinot.common.request.context.predicate.Predicate;
import org.apache.pinot.controller.recommender.io.ConfigManager;
import org.apache.pinot.controller.recommender.io.InputManager;
import org.apache.pinot.controller.recommender.rules.AbstractRule;
import org.apache.pinot.controller.recommender.rules.io.params.BloomFilterRuleParams;
import org.apache.pinot.controller.recommender.rules.utils.FixedLenBitset;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BloomFilterRule
extends AbstractRule {
    private final Logger LOGGER = LoggerFactory.getLogger(BloomFilterRule.class);
    private final BloomFilterRuleParams _params;

    public BloomFilterRule(InputManager input, ConfigManager output) {
        super(input, output);
        this._params = input.getBloomFilterRuleParams();
    }

    @Override
    public void run() {
        int numCols = this._input.getNumCols();
        double[] weights = new double[numCols];
        AtomicDouble totalWeight = new AtomicDouble(0.0);
        this._input.getParsedQueries().forEach(query -> {
            Double weight = this._input.getQueryWeight((String)query);
            totalWeight.addAndGet(weight.doubleValue());
            FixedLenBitset fixedLenBitset = this.parseQuery(this._input.getQueryContext((String)query));
            this.LOGGER.debug("fixedLenBitset {}", (Object)fixedLenBitset);
            for (Integer i : fixedLenBitset.getOffsets()) {
                int n = i;
                weights[n] = weights[n] + weight;
            }
        });
        this.LOGGER.debug("Weight: {}, Total {}", (Object)weights, (Object)totalWeight);
        for (int i = 0; i < numCols; ++i) {
            String dimName = this._input.intToColName(i);
            if (!(weights[i] / totalWeight.get() > this._params.THRESHOLD_MIN_PERCENT_EQ_BLOOMFILTER) || !(this._input.getCardinality(dimName) < (double)this._params.THRESHOLD_MAX_CARDINALITY_BLOOMFILTER.longValue())) continue;
            this._output.getIndexConfig().getBloomFilterColumns().add(dimName);
        }
    }

    public FixedLenBitset parseQuery(QueryContext queryContext) {
        if (queryContext.getFilter() == null) {
            return FixedLenBitset.IMMUTABLE_EMPTY_SET;
        }
        this.LOGGER.trace("Parsing Where Clause: {}", (Object)queryContext.getFilter().toString());
        return this.parsePredicateList(queryContext.getFilter());
    }

    private FixedLenBitset parsePredicateList(FilterContext filterContext) {
        FilterContext.Type type = filterContext.getType();
        FixedLenBitset ret = this.MUTABLE_EMPTY_SET();
        if (type == FilterContext.Type.AND) {
            for (int i = 0; i < filterContext.getChildren().size(); ++i) {
                FixedLenBitset childResult = this.parsePredicateList((FilterContext)filterContext.getChildren().get(i));
                ret.union(childResult);
            }
        } else if (type == FilterContext.Type.OR) {
            for (int i = 0; i < filterContext.getChildren().size(); ++i) {
                FixedLenBitset childResult = this.parsePredicateList((FilterContext)filterContext.getChildren().get(i));
                ret.union(childResult);
            }
        } else {
            ExpressionContext lhs = filterContext.getPredicate().getLhs();
            String colName = lhs.toString();
            if (lhs.getType() == ExpressionContext.Type.FUNCTION) {
                this.LOGGER.trace("Skipping the function {}", (Object)colName);
            } else if (filterContext.getPredicate().getType() == Predicate.Type.EQ) {
                ret.add(this._input.colNameToInt(colName));
            }
        }
        return ret;
    }

    private FixedLenBitset MUTABLE_EMPTY_SET() {
        return new FixedLenBitset(this._input.getNumCols());
    }
}

