/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.recommender.rules.impl;

import java.util.HashSet;
import java.util.Set;
import org.apache.pinot.controller.recommender.io.ConfigManager;
import org.apache.pinot.controller.recommender.io.InputManager;
import org.apache.pinot.controller.recommender.rules.AbstractRule;
import org.apache.pinot.controller.recommender.rules.io.params.FlagQueryRuleParams;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlagQueryRule
extends AbstractRule {
    private final Logger LOGGER = LoggerFactory.getLogger(FlagQueryRule.class);
    private final FlagQueryRuleParams _params;

    public FlagQueryRule(InputManager input, ConfigManager output) {
        super(input, output);
        this._params = input.getFlagQueryRuleParams();
    }

    @Override
    public void run() {
        for (String query : this._input.getParsedQueries()) {
            this.LOGGER.debug("Parsing query: {}", (Object)query);
            QueryContext queryContext = this._input.getQueryContext(query);
            if ((long)queryContext.getLimit() > this._params.THRESHOLD_MAX_LIMIT_SIZE) {
                this._output.getFlaggedQueries().add(query, "Warning: Please verify if you need to pull out huge number of records for this query. Consider using smaller limit than 100000");
            }
            if (queryContext.getFilter() == null) {
                this._output.getFlaggedQueries().add(query, "Warning: Query seems to scan the entire table. No filters are used in the query. Please verify if filters are not needed.");
                continue;
            }
            HashSet usedCols = new HashSet();
            queryContext.getFilter().getColumns(usedCols);
            Set<String> timeCols = this._input.getTimeColumns();
            if (timeCols.isEmpty()) continue;
            usedCols.retainAll(timeCols);
            if (!usedCols.isEmpty()) continue;
            this._output.getFlaggedQueries().add(query, "Warning: No time column used in filter in the query. Table with time columns typically use it in filters to make the queries more selective.");
        }
    }
}

