/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.recommender.rules.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pinot.controller.recommender.io.ConfigManager;
import org.apache.pinot.controller.recommender.io.InputManager;
import org.apache.pinot.controller.recommender.rules.AbstractRule;
import org.apache.pinot.controller.recommender.rules.io.params.InvertedSortedIndexJointRuleParams;
import org.apache.pinot.controller.recommender.rules.utils.FixedLenBitset;
import org.apache.pinot.controller.recommender.rules.utils.PredicateParseResult;
import org.apache.pinot.controller.recommender.rules.utils.QueryInvertedSortedIndexRecommender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvertedSortedIndexJointRule
extends AbstractRule {
    private final Logger LOGGER = LoggerFactory.getLogger(InvertedSortedIndexJointRule.class);
    InvertedSortedIndexJointRuleParams _params;
    Double _totalNESI;

    public InvertedSortedIndexJointRule(InputManager input, ConfigManager config) {
        super(input, config);
        this._params = input.getInvertedSortedIndexJointRuleParams();
    }

    @Override
    public void run() {
        QueryInvertedSortedIndexRecommender totalNESICounter = QueryInvertedSortedIndexRecommender.QueryInvertedSortedIndexRecommenderBuilder.aQueryInvertedSortedIndexRecommender().setInputManager(this._input).setInvertedSortedIndexJointRuleParams(this._params).setUseOverwrittenIndices(false).build();
        List perQueryNESI = this._input.getParsedQueries().stream().flatMap(query -> totalNESICounter.parseQuery(this._input.getQueryContext((String)query), this._input.getQueryWeight((String)query)).stream()).map(exclusiveRecommendations -> ((PredicateParseResult)exclusiveRecommendations.get(0)).getnESI()).collect(Collectors.toList());
        this._totalNESI = perQueryNESI.stream().reduce(Double::sum).orElse(0.0);
        this.LOGGER.debug("totalNESI without any indices {}", (Object)this._totalNESI);
        this.LOGGER.debug("perQueryNESI {}", perQueryNESI);
        QueryInvertedSortedIndexRecommender perQueryRecommender = QueryInvertedSortedIndexRecommender.QueryInvertedSortedIndexRecommenderBuilder.aQueryInvertedSortedIndexRecommender().setInputManager(this._input).setInvertedSortedIndexJointRuleParams(this._params).setUseOverwrittenIndices(true).build();
        List parsedQueries = this._input.getParsedQueries().stream().map(query -> perQueryRecommender.parseQuery(this._input.getQueryContext((String)query), this._input.getQueryWeight((String)query))).collect(Collectors.toList());
        List<List<PredicateParseResult>> flattenedResults = parsedQueries.stream().flatMap(Collection::stream).collect(Collectors.toList());
        PredicateParseResult optimalCombination = this.findOptimalCombination(flattenedResults);
        this.LOGGER.debug("flattenedResults: {}", flattenedResults);
        this.LOGGER.debug("optimalCombination: {}", (Object)optimalCombination);
        List perQuerySelectedCandidate = flattenedResults.stream().map(exclusiveRecommendations -> exclusiveRecommendations.stream().filter(predicateParseResult -> optimalCombination.getCandidateDims().contains(predicateParseResult.getCandidateDims())).min(Comparator.comparing(PredicateParseResult::getnESIWithIdx)).get()).collect(Collectors.toList());
        this.LOGGER.debug("perQuerySelectedCandidate: {}", perQuerySelectedCandidate);
        int numColumnsIndexApplicable = this._input.getNumColumnsInvertedSortedApplicable();
        double[] weights = new double[numColumnsIndexApplicable];
        for (int i = 0; i < perQueryNESI.size(); ++i) {
            double savedNESI = (Double)perQueryNESI.get(i) - ((PredicateParseResult)perQuerySelectedCandidate.get(i)).getnESIWithIdx();
            double share = savedNESI / (double)((PredicateParseResult)perQuerySelectedCandidate.get(i)).getCandidateDims().getCardinality();
            this.LOGGER.trace("getOffsets: {}", (Object)((PredicateParseResult)perQuerySelectedCandidate.get(i)).getCandidateDims());
            for (Integer j : ((PredicateParseResult)perQuerySelectedCandidate.get(i)).getCandidateDims().getOffsets()) {
                int n = j;
                weights[n] = weights[n] + share;
            }
        }
        ArrayList<Pair> colNameWeightPairRank = new ArrayList<Pair>(numColumnsIndexApplicable);
        for (int i = 0; i < numColumnsIndexApplicable; ++i) {
            if (!(weights[i] > 0.0)) continue;
            colNameWeightPairRank.add(Pair.of((Object)this._input.intToColName(i), (Object)weights[i]));
        }
        if (!colNameWeightPairRank.isEmpty()) {
            if (this._input.getOverWrittenConfigs().getIndexConfig().isSortedColumnOverwritten()) {
                colNameWeightPairRank.forEach(pair -> this._output.getIndexConfig().getInvertedIndexColumns().add((String)pair.getLeft()));
            } else {
                colNameWeightPairRank.sort((a, b) -> ((Double)b.getRight()).compareTo((Double)a.getRight()));
                this.LOGGER.debug("colWeightsRank: {}", colNameWeightPairRank);
                Double weightThresholdForTopCandidates = (Double)((Pair)colNameWeightPairRank.get(0)).getRight() * this._params.THRESHOLD_RATIO_MIN_NESI_FOR_TOP_CANDIDATES;
                Optional<Pair> sortedColumn = colNameWeightPairRank.stream().filter(pair -> (Double)pair.getRight() >= weightThresholdForTopCandidates).filter(pair -> this._input.isSingleValueColumn((String)pair.getLeft())).max(Comparator.comparing(pair -> this._input.getCardinality((String)pair.getLeft())));
                if (sortedColumn.isPresent()) {
                    this._output.getIndexConfig().setSortedColumn((String)sortedColumn.get().getLeft());
                    colNameWeightPairRank.stream().filter(pair -> pair != sortedColumn.get()).forEach(pair -> this._output.getIndexConfig().getInvertedIndexColumns().add((String)pair.getLeft()));
                } else {
                    colNameWeightPairRank.forEach(pair -> this._output.getIndexConfig().getInvertedIndexColumns().add((String)pair.getLeft()));
                }
            }
        }
    }

    public PredicateParseResult findOptimalCombination(List<List<PredicateParseResult>> parsedQuery) {
        int n = this._input.getNumColumnsInvertedSortedApplicable();
        int iterationsWithoutGain = 0;
        PredicateParseResult optimalCombinationResult = this.evaluateCombination(n, 1, parsedQuery);
        this.LOGGER.debug("findOptimalCombination: currentOptimalCombinationResult: {}", (Object)optimalCombinationResult);
        for (int r = 2; r <= n; ++r) {
            PredicateParseResult currentCombination = this.evaluateCombination(n, r, parsedQuery);
            this.LOGGER.debug("findOptimalCombination: currentCombination: {}", (Object)currentCombination);
            double ratio = (optimalCombinationResult.getnESIWithIdx() - currentCombination.getnESIWithIdx()) / this._totalNESI;
            this.LOGGER.debug("ratio {}", (Object)ratio);
            if (ratio > this._params.THRESHOLD_RATIO_MIN_GAIN_DIFF_BETWEEN_ITERATION) {
                optimalCombinationResult = currentCombination;
                iterationsWithoutGain = 0;
            } else if (++iterationsWithoutGain >= this._params.MAX_NUM_ITERATION_WITHOUT_GAIN) break;
            this.LOGGER.debug("findOptimalCombination: currentOptimalCombinationResult: {}", (Object)optimalCombinationResult);
        }
        return optimalCombinationResult;
    }

    public PredicateParseResult evaluateCombination(int n, int r, List<List<PredicateParseResult>> parsedQuery) {
        FixedLenBitset usedCols = new FixedLenBitset(n);
        parsedQuery.forEach(list -> list.stream().filter(predicateParseResult -> predicateParseResult.getCandidateDims().getCardinality() <= r).forEach(predicateParseResult -> usedCols.union(predicateParseResult.getCandidateDims())));
        this.LOGGER.debug("totalUsed {}", (Object)usedCols.getCardinality());
        List<Integer> usedColIDs = usedCols.getOffsets();
        int nCapped = usedColIDs.size();
        int rCapped = Math.min(r, nCapped);
        int[] idToColID = new int[nCapped];
        for (int i = 0; i < nCapped; ++i) {
            idToColID[i] = usedColIDs.get(i);
        }
        List<int[]> combinationIntArrays = InvertedSortedIndexJointRule.generateCombinations(nCapped, rCapped);
        Optional<Pair> optimal = combinationIntArrays.parallelStream().map(combinationIntArray -> {
            FixedLenBitset fixedLenBitset = new FixedLenBitset(n);
            for (int j = 0; j < rCapped; ++j) {
                fixedLenBitset.add(idToColID[combinationIntArray[j]]);
            }
            double nESIWithIdx = 0.0;
            for (List exclusiveRecommendations : parsedQuery) {
                double bestNESIWithIdx = ((PredicateParseResult)exclusiveRecommendations.get(0)).getnESI();
                for (PredicateParseResult predicateParseResult : exclusiveRecommendations) {
                    if (!fixedLenBitset.contains(predicateParseResult.getCandidateDims())) continue;
                    bestNESIWithIdx = Math.min(bestNESIWithIdx, predicateParseResult.getnESIWithIdx());
                }
                nESIWithIdx += bestNESIWithIdx;
            }
            return Pair.of((Object)nESIWithIdx, (Object)fixedLenBitset);
        }).min(Comparator.comparing(Pair::getLeft));
        if (optimal.isPresent()) {
            return PredicateParseResult.PredicateParseResultBuilder.aPredicateParseResult().setCandidateDims((FixedLenBitset)optimal.get().getRight()).setIteratorEvalPriorityEnum(QueryInvertedSortedIndexRecommender.IteratorEvalPriorityEnum.INDEXED).setRecommendationPriorityEnum(QueryInvertedSortedIndexRecommender.RecommendationPriorityEnum.BITMAP).setnESI(this._totalNESI).setPercentSelected(0.0).setnESIWithIdx((Double)optimal.get().getLeft()).build();
        }
        return PredicateParseResult.PredicateParseResultBuilder.aPredicateParseResult().setCandidateDims(new FixedLenBitset(n)).setIteratorEvalPriorityEnum(QueryInvertedSortedIndexRecommender.IteratorEvalPriorityEnum.INDEXED).setRecommendationPriorityEnum(QueryInvertedSortedIndexRecommender.RecommendationPriorityEnum.BITMAP).setnESI(this._totalNESI).setPercentSelected(0.0).setnESIWithIdx(this._totalNESI).build();
    }

    public static List<int[]> generateCombinations(int n, int r) {
        ArrayList<int[]> combinations = new ArrayList<int[]>();
        if (r == 0) {
            return combinations;
        }
        int[] combination = new int[r];
        for (int i = 0; i < r; ++i) {
            combination[i] = i;
        }
        while (combination[r - 1] < n) {
            int t;
            combinations.add((int[])combination.clone());
            for (t = r - 1; t != 0 && combination[t] == n - r + t; --t) {
            }
            int n2 = t;
            combination[n2] = combination[n2] + 1;
            for (int i = t + 1; i < r; ++i) {
                combination[i] = combination[i - 1] + 1;
            }
        }
        return combinations;
    }
}

