/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.recommender.rules.impl;

import com.google.common.util.concurrent.AtomicDouble;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.FilterContext;
import org.apache.pinot.common.request.context.predicate.Predicate;
import org.apache.pinot.controller.recommender.exceptions.InvalidInputException;
import org.apache.pinot.controller.recommender.io.ConfigManager;
import org.apache.pinot.controller.recommender.io.InputManager;
import org.apache.pinot.controller.recommender.rules.AbstractRule;
import org.apache.pinot.controller.recommender.rules.io.params.NoDictionaryOnHeapDictionaryJointRuleParams;
import org.apache.pinot.controller.recommender.rules.utils.FixedLenBitset;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoDictionaryOnHeapDictionaryJointRule
extends AbstractRule {
    private final Logger LOGGER = LoggerFactory.getLogger(NoDictionaryOnHeapDictionaryJointRule.class);
    private final NoDictionaryOnHeapDictionaryJointRuleParams _params;

    public NoDictionaryOnHeapDictionaryJointRule(InputManager input, ConfigManager output) {
        super(input, output);
        this._params = input.getNoDictionaryOnHeapDictionaryJointRuleParams();
    }

    @Override
    public void run() {
        this.LOGGER.info("Recommending no dictionary and on-heap dictionaries");
        int numCols = this._input.getNumCols();
        HashMap filterGroupByWeights = new HashMap();
        HashMap selectionWeights = new HashMap();
        AtomicDouble totalWeight = new AtomicDouble(0.0);
        this._input.getParsedQueries().forEach(query -> {
            Double weight = this._input.getQueryWeight((String)query);
            this.parseQuery(this._input.getQueryContext((String)query), weight, filterGroupByWeights, selectionWeights);
            totalWeight.addAndGet(weight.doubleValue());
        });
        HashSet<String> noDictCols = new HashSet<String>(this._input.getColNameToIntMap().keySet());
        noDictCols.removeAll(this._output.getIndexConfig().getInvertedIndexColumns());
        noDictCols.remove(this._output.getIndexConfig().getSortedColumn());
        noDictCols.removeAll(this._output.getIndexConfig().getRangeIndexColumns());
        this.LOGGER.debug("noDictCols {}", noDictCols);
        noDictCols.removeIf(colName -> !this._input.isSingleValueColumn((String)colName));
        noDictCols.removeIf(colName -> {
            double filterGroupByFreq = filterGroupByWeights.getOrDefault(colName, 0.0) / totalWeight.get();
            return filterGroupByFreq > this._params.THRESHOLD_MIN_FILTER_FREQ_DICTIONARY;
        });
        this.LOGGER.debug("filterGroupByWeights {}, selectionWeights{}, totalWeight{} ", new Object[]{filterGroupByWeights, selectionWeights, totalWeight});
        this.LOGGER.debug("noDictCols {}", noDictCols);
        noDictCols.removeIf(colName -> {
            double selectionFreq = selectionWeights.getOrDefault(colName, 0.0) / totalWeight.get();
            if (selectionFreq > this._params.THRESHOLD_MIN_SELECTION_FREQ_NO_DICTIONARY) {
                return false;
            }
            long svColRawSizePerDoc = 0L;
            try {
                svColRawSizePerDoc = this._input.getColRawSizePerDoc((String)colName);
            }
            catch (InvalidInputException e) {
                return true;
            }
            double numValuesPerEntry = this._input.getNumValuesPerEntry((String)colName);
            int dictionaryEncodedForwardIndexSize = this._input.getDictionaryEncodedForwardIndexSize((String)colName);
            long dictionarySize = this._input.getDictionarySize((String)colName);
            this.LOGGER.debug("svColRawSizePerDoc {}", (Object)svColRawSizePerDoc);
            this.LOGGER.debug("dictionaryEncodedForwardIndexSize {}", (Object)dictionaryEncodedForwardIndexSize);
            this.LOGGER.debug("dictionarySize {}", (Object)dictionarySize);
            this.LOGGER.debug("numValuesPerEntry {}", (Object)numValuesPerEntry);
            long numRecordsPerPush = this._input.getTableType().equalsIgnoreCase("realtime") ? this._input.getNumMessagesPerSecInKafkaTopic() * (long)this._input.getSegmentFlushTime().intValue() : this._input.getNumRecordsPerPush();
            double noDictSize = numRecordsPerPush * svColRawSizePerDoc;
            double withDictSize = (double)(numRecordsPerPush * (long)dictionaryEncodedForwardIndexSize) + (double)dictionarySize * this._params.DICTIONARY_COEFFICIENT;
            double storageSaved = (noDictSize - withDictSize) / noDictSize;
            this.LOGGER.debug("colName {}, noDictSize {}, withDictSize{}, storageSaved{}", new Object[]{colName, noDictSize, withDictSize, storageSaved});
            return storageSaved > this._params.THRESHOLD_MIN_PERCENT_DICTIONARY_STORAGE_SAVE;
        });
        this._output.getIndexConfig().getNoDictionaryColumns().addAll(noDictCols);
        if (this._input.getQps() > this._params.THRESHOLD_MIN_QPS_ON_HEAP) {
            for (String colName2 : this._input.getColNameToIntMap().keySet()) {
                if (this._output.getIndexConfig().getNoDictionaryColumns().contains(colName2)) continue;
                long dictionarySize = this._input.getDictionarySize(colName2);
                double filterGroupByFreq = filterGroupByWeights.getOrDefault(colName2, 0.0) / totalWeight.get();
                if (!(filterGroupByFreq > this._params.THRESHOLD_MIN_FILTER_FREQ_ON_HEAP) || dictionarySize >= this._params.THRESHOLD_MAX_DICTIONARY_SIZE_ON_HEAP) continue;
                this._output.getIndexConfig().getOnHeapDictionaryColumns().add(colName2);
            }
        }
    }

    public void parseQuery(QueryContext queryContext, double weight, Map<String, Double> filterGroupByWeights, Map<String, Double> selectionWeights) {
        if (queryContext.getSelectExpressions() != null) {
            queryContext.getSelectExpressions().forEach(selectExpression -> {
                HashSet colNames = new HashSet();
                selectExpression.getColumns(colNames);
                colNames.forEach(colName -> selectionWeights.merge((String)colName, weight, Double::sum));
            });
        }
        FixedLenBitset fixedLenBitsetFilterGroupBy = this.MUTABLE_EMPTY_SET();
        if (queryContext.getGroupByExpressions() != null) {
            queryContext.getGroupByExpressions().forEach(groupByExpression -> {
                HashSet colNames = new HashSet();
                groupByExpression.getColumns(colNames);
                colNames.forEach(colName -> fixedLenBitsetFilterGroupBy.add(this._input.colNameToInt((String)colName)));
            });
        }
        if (queryContext.getFilter() != null) {
            fixedLenBitsetFilterGroupBy.union(this.parsePredicateList(queryContext.getFilter()));
        }
        for (Integer colId : fixedLenBitsetFilterGroupBy.getOffsets()) {
            filterGroupByWeights.merge(this._input.intToColName(colId), weight, Double::sum);
        }
    }

    public FixedLenBitset parsePredicateList(FilterContext filterContext) {
        FilterContext.Type type = filterContext.getType();
        FixedLenBitset ret = this.MUTABLE_EMPTY_SET();
        if (type == FilterContext.Type.AND) {
            for (int i = 0; i < filterContext.getChildren().size(); ++i) {
                FixedLenBitset childResult = this.parsePredicateList((FilterContext)filterContext.getChildren().get(i));
                if (childResult == null) continue;
                ret.union(childResult);
            }
        } else if (type == FilterContext.Type.OR) {
            for (int i = 0; i < filterContext.getChildren().size(); ++i) {
                FixedLenBitset childResult = this.parsePredicateList((FilterContext)filterContext.getChildren().get(i));
                if (childResult == null) continue;
                ret.union(childResult);
            }
        } else {
            Predicate predicate = filterContext.getPredicate();
            ExpressionContext lhs = predicate.getLhs();
            String colName = lhs.toString();
            if (lhs.getType() == ExpressionContext.Type.FUNCTION || this._input.isTimeOrDateTimeColumn(colName)) {
                this.LOGGER.trace("Skipping this column {}", (Object)colName);
            } else if (!this._input.isDim(colName)) {
                this.LOGGER.error("Error: Column {} should not appear in filter", (Object)colName);
            } else {
                ret.add(this._input.colNameToInt(colName));
            }
        }
        return ret;
    }

    private FixedLenBitset MUTABLE_EMPTY_SET() {
        return new FixedLenBitset(this._input.getNumCols());
    }
}

