/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.recommender.rules.impl;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.FilterContext;
import org.apache.pinot.common.request.context.predicate.InPredicate;
import org.apache.pinot.common.request.context.predicate.Predicate;
import org.apache.pinot.controller.recommender.exceptions.InvalidInputException;
import org.apache.pinot.controller.recommender.io.ConfigManager;
import org.apache.pinot.controller.recommender.io.InputManager;
import org.apache.pinot.controller.recommender.rules.AbstractRule;
import org.apache.pinot.controller.recommender.rules.io.params.PartitionRuleParams;
import org.apache.pinot.controller.recommender.rules.utils.FixedLenBitset;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PinotTablePartitionRule
extends AbstractRule {
    private final Logger LOGGER = LoggerFactory.getLogger(PinotTablePartitionRule.class);
    PartitionRuleParams _params;

    public PinotTablePartitionRule(InputManager input, ConfigManager output) {
        super(input, output);
        this._params = input.getPartitionRuleParams();
    }

    @Override
    public void run() throws InvalidInputException {
        this.LOGGER.info("Recommending partition configurations");
        if (this._input.getQps() < this._params.THRESHOLD_MIN_QPS_PARTITION) {
            this.LOGGER.info("*Input QPS {} < threshold {}, no partition needed", (Object)this._input.getQps(), (Object)this._params.THRESHOLD_MIN_QPS_PARTITION);
            return;
        }
        if (this._input.getLatencySLA() > this._params.THRESHOLD_MAX_LATENCY_SLA_PARTITION) {
            this.LOGGER.info("*Input SLA {} > threshold {}, no partition needed", (Object)this._input.getLatencySLA(), (Object)this._params.THRESHOLD_MAX_LATENCY_SLA_PARTITION);
            return;
        }
        this.LOGGER.info("*Recommending number of partitions ");
        int numKafkaPartitions = this._output.getPartitionConfig().getNumKafkaPartitions();
        boolean isRealtimeTable = this._input.getTableType().equalsIgnoreCase("realtime");
        boolean isHybridTable = this._input.getTableType().equalsIgnoreCase("hybrid");
        boolean isOfflineTable = this._input.getTableType().equalsIgnoreCase("offline");
        if ((isRealtimeTable || isHybridTable) && !this._input.getOverWrittenConfigs().getPartitionConfig().isNumPartitionsRealtimeOverwritten()) {
            this._output.getPartitionConfig().setNumPartitionsRealtime(numKafkaPartitions);
        }
        if ((isOfflineTable || isHybridTable) && !this._input.getOverWrittenConfigs().getPartitionConfig().isNumPartitionsOfflineOverwritten()) {
            int optimalOfflinePartitions = (int)this._output.getSegmentSizeRecommendations().getNumSegments();
            this._output.getPartitionConfig().setNumPartitionsOffline(optimalOfflinePartitions);
        }
        if (this._input.getOverWrittenConfigs().getPartitionConfig().isPartitionDimensionOverwritten()) {
            return;
        }
        this.LOGGER.info("*Recommending column to partition");
        double[] weights = new double[this._input.getNumDims()];
        this._input.getParsedQueries().forEach(query -> {
            Double weight = this._input.getQueryWeight((String)query);
            FixedLenBitset fixedLenBitset = this.parseQuery(this._input.getQueryContext((String)query));
            this.LOGGER.debug("fixedLenBitset:{}", (Object)fixedLenBitset);
            if (fixedLenBitset != null) {
                for (Integer i : fixedLenBitset.getOffsets()) {
                    int n = i;
                    weights[n] = weights[n] + weight;
                }
            }
        });
        ArrayList<Pair<String, Double>> columnNameToWeightPairs = new ArrayList<Pair<String, Double>>();
        for (int i = 0; i < this._input.getNumDims(); ++i) {
            if (!(weights[i] > 0.0)) continue;
            columnNameToWeightPairs.add(Pair.of((Object)this._input.intToColName(i), (Object)weights[i]));
        }
        if (columnNameToWeightPairs.isEmpty()) {
            return;
        }
        this.LOGGER.info("**Goodness of column to partition {}", columnNameToWeightPairs);
        int numPartitions = isOfflineTable || isHybridTable ? this._output.getPartitionConfig().getNumPartitionsOffline() : this._output.getPartitionConfig().getNumPartitionsRealtime();
        Optional<String> colNameOpt = PinotTablePartitionRule.findBestColumnForPartitioning(columnNameToWeightPairs, this._input::getCardinality, this._params.THRESHOLD_RATIO_MIN_DIMENSION_PARTITION_TOP_CANDIDATES, numPartitions);
        colNameOpt.ifPresent(colName -> this._output.getPartitionConfig().setPartitionDimension((String)colName));
    }

    @VisibleForTesting
    static Optional<String> findBestColumnForPartitioning(List<Pair<String, Double>> columnNameToWeightPairs, Function<String, Double> cardinalityExtractor, double topCandidateRatio, int numPartitions) {
        return columnNameToWeightPairs.stream().filter(colToWeight -> (Double)cardinalityExtractor.apply((String)colToWeight.getLeft()) > (double)numPartitions * 0.7).max(Comparator.comparingDouble(Pair::getRight)).map(Pair::getRight).flatMap(maxWeight -> {
            double topCandidatesThreshold = maxWeight * topCandidateRatio;
            return columnNameToWeightPairs.stream().filter(colToWeight -> (Double)colToWeight.getRight() > topCandidatesThreshold).max(Comparator.comparingDouble(colToWeight -> (Double)cardinalityExtractor.apply((String)colToWeight.getLeft()))).map(Pair::getLeft);
        });
    }

    public FixedLenBitset parseQuery(QueryContext queryContext) {
        if (queryContext.getFilter() == null) {
            return FixedLenBitset.IMMUTABLE_EMPTY_SET;
        }
        this.LOGGER.trace("Parsing Where Clause: {}", (Object)queryContext.getFilter().toString());
        return this.parsePredicateList(queryContext.getFilter());
    }

    public FixedLenBitset parsePredicateList(FilterContext filterContext) {
        FixedLenBitset ret;
        FilterContext.Type type = filterContext.getType();
        if (type == FilterContext.Type.AND) {
            ret = this.MUTABLE_EMPTY_SET();
            for (int i = 0; i < filterContext.getChildren().size(); ++i) {
                FixedLenBitset childResult = this.parsePredicateList((FilterContext)filterContext.getChildren().get(i));
                if (childResult == null) continue;
                ret.union(childResult);
            }
        } else if (type == FilterContext.Type.OR) {
            ret = null;
            for (int i = 0; i < filterContext.getChildren().size(); ++i) {
                FixedLenBitset childResult = this.parsePredicateList((FilterContext)filterContext.getChildren().get(i));
                if (childResult == null) continue;
                ret = ret == null ? childResult : ret.intersect(childResult);
            }
        } else {
            ret = this.MUTABLE_EMPTY_SET();
            Predicate predicate = filterContext.getPredicate();
            Predicate.Type predicateType = predicate.getType();
            ExpressionContext lhs = predicate.getLhs();
            String colName = lhs.toString();
            if (lhs.getType() == ExpressionContext.Type.FUNCTION) {
                this.LOGGER.trace("Skipping the function {}", (Object)colName);
            } else {
                if (this._input.isTimeOrDateTimeColumn(colName)) {
                    this.LOGGER.trace("Skipping the DateTime column {}", (Object)colName);
                    return null;
                }
                if (!this._input.isDim(colName)) {
                    this.LOGGER.error("Error: Column {} should not appear in filter, ignoring this", (Object)colName);
                    return null;
                }
                if (!this._input.isSingleValueColumn(colName)) {
                    this.LOGGER.trace("Skipping the MV column {}", (Object)colName);
                } else if (predicateType == Predicate.Type.IN) {
                    InPredicate inPredicate = (InPredicate)predicate;
                    boolean isFirst = false;
                    List values = inPredicate.getValues();
                    int numValuesSelected = values.size() == 1 ? 1 : (((String)values.get(0)).equals("#VALUES") || (isFirst = ((String)values.get(1)).equals("#VALUES")) ? Integer.parseInt((String)values.get(isFirst ? 0 : 1)) : values.size());
                    if (numValuesSelected <= this._params.THRESHOLD_MAX_IN_LENGTH) {
                        ret.add(this._input.colNameToInt(colName));
                    }
                } else if (predicateType == Predicate.Type.EQ) {
                    ret.add(this._input.colNameToInt(colName));
                }
            }
        }
        this.LOGGER.debug("ret {}", (Object)ret.toString());
        return ret;
    }

    private FixedLenBitset MUTABLE_EMPTY_SET() {
        return new FixedLenBitset(this._input.getNumDims());
    }
}

