/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.recommender.rules.impl;

import com.google.common.io.Files;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.pinot.controller.recommender.exceptions.InvalidInputException;
import org.apache.pinot.controller.recommender.io.ConfigManager;
import org.apache.pinot.controller.recommender.io.InputManager;
import org.apache.pinot.controller.recommender.realtime.provisioning.MemoryEstimator;
import org.apache.pinot.controller.recommender.rules.AbstractRule;
import org.apache.pinot.controller.recommender.rules.io.configs.IndexConfig;
import org.apache.pinot.controller.recommender.rules.io.params.RealtimeProvisioningRuleParams;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.utils.DataSizeUtils;
import org.apache.pinot.spi.utils.builder.TableConfigBuilder;

public class RealtimeProvisioningRule
extends AbstractRule {
    public static String OPTIMAL_SEGMENT_SIZE = "Optimal Segment Size";
    public static String CONSUMING_MEMORY_PER_HOST = "Consuming Memory per Host";
    public static String TOTAL_MEMORY_USED_PER_HOST = "Total Memory Used per Host";
    private final RealtimeProvisioningRuleParams _params;

    public RealtimeProvisioningRule(InputManager input, ConfigManager output) {
        super(input, output);
        this._params = input.getRealtimeProvisioningRuleParams();
    }

    @Override
    public void run() throws InvalidInputException {
        if (this._params == null) {
            return;
        }
        TableConfig tableConfig = this.createTableConfig(this._output.getIndexConfig(), this._input.getSchema(), this._output.isAggregateMetrics());
        long maxUsableHostMemoryByte = DataSizeUtils.toBytes((String)this._params.getMaxUsableHostMemory());
        int totalConsumingPartitions = this._params.getNumPartitions() * this._params.getNumReplicas();
        int ingestionRatePerPartition = (int)this._input.getNumMessagesPerSecInKafkaTopic() / this._params.getNumPartitions();
        int retentionHours = this._params.getRealtimeTableRetentionHours();
        int[] numHosts = this._params.getNumHosts();
        int[] numHours = this._params.getNumHours();
        File workingDir = Files.createTempDir();
        MemoryEstimator memoryEstimator = new MemoryEstimator(tableConfig, this._input.getSchema(), this._input.getSchemaWithMetadata(), this._params.getNumRowsInGeneratedSegment(), ingestionRatePerPartition, maxUsableHostMemoryByte, retentionHours, workingDir);
        try {
            File statsFile = memoryEstimator.initializeStatsHistory();
            memoryEstimator.estimateMemoryUsed(statsFile, numHosts, numHours, totalConsumingPartitions, retentionHours);
            this.extractResults(memoryEstimator, numHosts, numHours, this._output.getRealtimeProvisioningRecommendations());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private TableConfig createTableConfig(IndexConfig indexConfig, Schema schema, boolean aggregateMetrics) {
        TableConfigBuilder tableConfigBuilder = new TableConfigBuilder(TableType.REALTIME);
        tableConfigBuilder.setTableName(schema.getSchemaName());
        tableConfigBuilder.setLoadMode("MMAP");
        this.setIfNotEmpty(indexConfig.getSortedColumn(), arg_0 -> ((TableConfigBuilder)tableConfigBuilder).setSortedColumn(arg_0));
        this.setIfNotEmpty(indexConfig.getBloomFilterColumns(), arg_0 -> ((TableConfigBuilder)tableConfigBuilder).setBloomFilterColumns(arg_0));
        this.setIfNotEmpty(indexConfig.getNoDictionaryColumns(), arg_0 -> ((TableConfigBuilder)tableConfigBuilder).setNoDictionaryColumns(arg_0));
        this.setIfNotEmpty(indexConfig.getInvertedIndexColumns(), arg_0 -> ((TableConfigBuilder)tableConfigBuilder).setInvertedIndexColumns(arg_0));
        this.setIfNotEmpty(indexConfig.getOnHeapDictionaryColumns(), arg_0 -> ((TableConfigBuilder)tableConfigBuilder).setOnHeapDictionaryColumns(arg_0));
        this.setIfNotEmpty(indexConfig.getVariedLengthDictionaryColumns(), arg_0 -> ((TableConfigBuilder)tableConfigBuilder).setVarLengthDictionaryColumns(arg_0));
        TableConfig tableConfig = tableConfigBuilder.build();
        tableConfig.getIndexingConfig().setAggregateMetrics(aggregateMetrics);
        return tableConfig;
    }

    private void setIfNotEmpty(String colName, Consumer<String> func) {
        if (colName != null && !colName.isEmpty()) {
            func.accept(colName);
        }
    }

    private void setIfNotEmpty(Set<String> colNames, Consumer<List<String>> func) {
        if (colNames != null && !colNames.isEmpty()) {
            func.accept(new ArrayList<String>(colNames));
        }
    }

    private void extractResults(MemoryEstimator memoryEstimator, int[] numHosts, int[] numHours, Map<String, Map<String, String>> rtProvRecommendations) {
        Map<String, String> segmentSizes = this.makeMatrix(memoryEstimator.getOptimalSegmentSize(), numHosts, numHours);
        Map<String, String> consumingMemory = this.makeMatrix(memoryEstimator.getConsumingMemoryPerHost(), numHosts, numHours);
        Map<String, String> totalMemory = this.makeMatrix(memoryEstimator.getActiveMemoryPerHost(), numHosts, numHours, element -> element.substring(0, element.indexOf(47)));
        rtProvRecommendations.put(OPTIMAL_SEGMENT_SIZE, segmentSizes);
        rtProvRecommendations.put(CONSUMING_MEMORY_PER_HOST, consumingMemory);
        rtProvRecommendations.put(TOTAL_MEMORY_USED_PER_HOST, totalMemory);
    }

    private Map<String, String> makeMatrix(String[][] elements, int[] numHosts, int[] numHours) {
        return this.makeMatrix(elements, numHosts, numHours, Function.identity());
    }

    private Map<String, String> makeMatrix(String[][] elements, int[] numHosts, int[] numHours, Function<String, String> elementTrimmingFunc) {
        LinkedHashMap<String, String> output = new LinkedHashMap<String, String>();
        String cellFormat = "%-10s";
        String numHostsValues = Arrays.stream(numHosts).mapToObj(n -> String.format(cellFormat, n)).collect(Collectors.joining());
        output.put("numHosts -   ", numHostsValues);
        for (int i = 0; i < elements.length; ++i) {
            String[] rowElements = elements[i];
            String rowKey = String.format("numHours - %2d", numHours[i]);
            String rowValues = Arrays.stream(rowElements).map(elementTrimmingFunc).map(e -> String.format(cellFormat, e)).collect(Collectors.joining());
            output.put(rowKey, rowValues);
        }
        return output;
    }
}

