/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.recommender.rules.io.configs;

import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import java.util.HashSet;
import java.util.Set;

public class IndexConfig {
    Set<String> _invertedIndexColumns = new HashSet<String>();
    Set<String> _rangeIndexColumns = new HashSet<String>();
    String _sortedColumn = "";
    Set<String> _bloomFilterColumns = new HashSet<String>();
    Set<String> _noDictionaryColumns = new HashSet<String>();
    Set<String> _onHeapDictionaryColumns = new HashSet<String>();
    Set<String> _variedLengthDictionaryColumns = new HashSet<String>();
    boolean _isSortedColumnOverwritten = false;

    @JsonSetter(nulls=Nulls.SKIP)
    public void setVariedLengthDictionaryColumns(Set<String> variedLengthDictionaryColumns) {
        this._variedLengthDictionaryColumns = variedLengthDictionaryColumns;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    public void setBloomFilterColumns(Set<String> bloomFilterColumns) {
        this._bloomFilterColumns = bloomFilterColumns;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    public void setNoDictionaryColumns(Set<String> noDictionaryColumns) {
        this._noDictionaryColumns = noDictionaryColumns;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    public void setOnHeapDictionaryColumns(Set<String> onHeapDictionaryColumns) {
        this._onHeapDictionaryColumns = onHeapDictionaryColumns;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    public void setInvertedIndexColumns(Set<String> invertedIndexColumns) {
        this._invertedIndexColumns = invertedIndexColumns;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    public void setSortedColumn(String sortedColumn) {
        this._sortedColumn = sortedColumn;
        this._isSortedColumnOverwritten = true;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    public void setRangeIndexColumns(Set<String> rangeIndexColumns) {
        this._rangeIndexColumns = rangeIndexColumns;
    }

    public boolean isSortedColumnOverwritten() {
        return this._isSortedColumnOverwritten;
    }

    public void setSortedColumnOverwritten(boolean sortedColumnOverwritten) {
        this._isSortedColumnOverwritten = sortedColumnOverwritten;
    }

    public Set<String> getVariedLengthDictionaryColumns() {
        return this._variedLengthDictionaryColumns;
    }

    public Set<String> getBloomFilterColumns() {
        return this._bloomFilterColumns;
    }

    public Set<String> getNoDictionaryColumns() {
        return this._noDictionaryColumns;
    }

    public Set<String> getOnHeapDictionaryColumns() {
        return this._onHeapDictionaryColumns;
    }

    public Set<String> getInvertedIndexColumns() {
        return this._invertedIndexColumns;
    }

    public String getSortedColumn() {
        return this._sortedColumn;
    }

    public Set<String> getRangeIndexColumns() {
        return this._rangeIndexColumns;
    }

    public boolean hasInvertedIndex(String colname) {
        return this._invertedIndexColumns.contains(colname);
    }

    public boolean hasSortedIndex(String colName) {
        return this._sortedColumn.equals(colName);
    }

    public boolean hasRangeIndex(String colName) {
        return this._rangeIndexColumns.contains(colName);
    }

    public boolean hasAnyIndex() {
        return !this._sortedColumn.isEmpty() || !this._rangeIndexColumns.isEmpty() || !this._invertedIndexColumns.isEmpty();
    }
}

