/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.recommender.rules.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.FilterContext;
import org.apache.pinot.common.request.context.predicate.InPredicate;
import org.apache.pinot.common.request.context.predicate.NotInPredicate;
import org.apache.pinot.common.request.context.predicate.Predicate;
import org.apache.pinot.controller.recommender.io.InputManager;
import org.apache.pinot.controller.recommender.rules.io.configs.IndexConfig;
import org.apache.pinot.controller.recommender.rules.io.params.InvertedSortedIndexJointRuleParams;
import org.apache.pinot.controller.recommender.rules.utils.FixedLenBitset;
import org.apache.pinot.controller.recommender.rules.utils.PredicateParseResult;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryInvertedSortedIndexRecommender {
    private final Logger LOGGER = LoggerFactory.getLogger(QueryInvertedSortedIndexRecommender.class);
    private static final int NESTED_TOP_LEVEL = 0;
    private static final int NESTED_SECOND_LEVEL = 1;
    public static final List<List<PredicateParseResult>> EMPTY_PARSE_RESULT = Collections.singletonList(Collections.singletonList(PredicateParseResult.EMPTY_PREDICATE_PARSE_RESULT()));
    private InputManager _inputManager;
    private boolean _useOverwrittenIndices;
    private IndexConfig _indexOverwritten;
    private InvertedSortedIndexJointRuleParams _params;
    private int _numColumnsIndexApplicable;
    private String _queryType;

    public List<List<PredicateParseResult>> parseQuery(QueryContext queryContext, double queryWeight) {
        if (queryContext.getFilter() == null) {
            return EMPTY_PARSE_RESULT;
        }
        this.LOGGER.trace("Parsing Where Clause: {}", (Object)queryContext.getFilter().toString());
        return this.parseTopLevel(queryContext.getFilter(), queryWeight);
    }

    private List<PredicateParseResult> reorderAndPredicateList(List<PredicateParseResult> childResults) {
        if (childResults.stream().anyMatch(predicateParseResult -> predicateParseResult.getIteratorEvalPriority() == IteratorEvalPriorityEnum.INDEXED)) {
            Map<IteratorEvalPriorityEnum, List<PredicateParseResult>> groupedPredicates = childResults.stream().collect(Collectors.groupingBy(PredicateParseResult::getIteratorEvalPriority));
            List ret = groupedPredicates.getOrDefault((Object)IteratorEvalPriorityEnum.INDEXED, new ArrayList());
            ret.addAll(groupedPredicates.getOrDefault((Object)IteratorEvalPriorityEnum.SCAN, Collections.emptyList()));
            ret.addAll(groupedPredicates.getOrDefault((Object)IteratorEvalPriorityEnum.AND, Collections.emptyList()));
            ret.addAll(groupedPredicates.getOrDefault((Object)IteratorEvalPriorityEnum.OR, Collections.emptyList()));
            ret.addAll(groupedPredicates.getOrDefault((Object)IteratorEvalPriorityEnum.EXPRESSION, Collections.emptyList()));
            return ret;
        }
        childResults.sort(Comparator.comparing(PredicateParseResult::getIteratorEvalPriority));
        return childResults;
    }

    private List<List<PredicateParseResult>> parseTopLevel(FilterContext filterContextTopLevel, double queryWeight) {
        this.LOGGER.debug("parseTopLevel: Parsing top level predicate list: {}", (Object)filterContextTopLevel.toString());
        FilterContext.Type type = filterContextTopLevel.getType();
        if (type == FilterContext.Type.AND) {
            List<PredicateParseResult> childResults = new ArrayList<PredicateParseResult>();
            for (int i = 0; i < filterContextTopLevel.getChildren().size(); ++i) {
                PredicateParseResult childResult = this.parsePredicateList((FilterContext)filterContextTopLevel.getChildren().get(i), 1);
                if (childResult == null) continue;
                childResults.add(childResult);
            }
            if (childResults.isEmpty()) {
                return EMPTY_PARSE_RESULT;
            }
            childResults = this.reorderAndPredicateList(childResults);
            this.LOGGER.debug("parseTopLevel: AND: Reordered child results: {}", childResults);
            ArrayList<PredicateParseResult> ret = new ArrayList<PredicateParseResult>();
            double[] cache = new double[childResults.size()];
            double percentSelected = 1.0;
            double totalNESI = 0.0;
            for (int i = 0; i < childResults.size(); ++i) {
                cache[i] = childResults.get(i).getnESI() * percentSelected;
                totalNESI += cache[i];
                percentSelected *= childResults.get(i).getPercentSelected();
            }
            this.LOGGER.debug("parseTopLevel: AND: Cache: {} perQuerytTotalNESI:{} percentSelected:{}", new Object[]{cache, totalNESI, percentSelected});
            LinkedList<Pair> totalNESIWithIdxSorted = new LinkedList<Pair>();
            for (int i = 0; i < childResults.size(); ++i) {
                int j;
                if (!childResults.get(i).hasCandidateDim()) continue;
                double tmpNESIWithIdx = 0.0;
                for (j = 0; j < i; ++j) {
                    tmpNESIWithIdx += childResults.get((int)i)._percentSelected * cache[j];
                }
                ++j;
                while (j < childResults.size()) {
                    tmpNESIWithIdx += cache[j];
                    ++j;
                }
                totalNESIWithIdxSorted.add(Pair.of((Object)(tmpNESIWithIdx += childResults.get((int)i)._nESIWithIdx), (Object)childResults.get(i)));
            }
            if (totalNESIWithIdxSorted.isEmpty()) {
                ret.add(PredicateParseResult.PredicateParseResultBuilder.aPredicateParseResult().setCandidateDims(FixedLenBitset.IMMUTABLE_EMPTY_SET).setIteratorEvalPriorityEnum(IteratorEvalPriorityEnum.AND).setRecommendationPriorityEnum(RecommendationPriorityEnum.NESTED).setnESI(totalNESI).setPercentSelected(percentSelected).setnESIWithIdx(totalNESI).setQueryWeight(queryWeight).build());
            } else {
                totalNESIWithIdxSorted.sort(Comparator.comparing(Pair::getLeft));
                this.LOGGER.debug("parseTopLevel: AND: totalNESIWithIdxSorted {}", totalNESIWithIdxSorted);
                double threshold = this._params.THRESHOLD_RATIO_MIN_AND_PREDICATE_TOP_CANDIDATES * (totalNESI - (Double)((Pair)totalNESIWithIdxSorted.get(0)).getLeft());
                this.LOGGER.debug("threshold {}", (Object)threshold);
                for (Pair pair : totalNESIWithIdxSorted) {
                    if (!(totalNESI - (Double)pair.getLeft() >= threshold)) continue;
                    ret.add(PredicateParseResult.PredicateParseResultBuilder.aPredicateParseResult().setCandidateDims(((PredicateParseResult)pair.getRight()).getCandidateDims()).setIteratorEvalPriorityEnum(IteratorEvalPriorityEnum.AND).setRecommendationPriorityEnum(RecommendationPriorityEnum.BITMAP).setnESI(totalNESI).setPercentSelected(percentSelected).setnESIWithIdx((Double)pair.getLeft()).setQueryWeight(queryWeight).build());
                }
                Pair previousPair = (Pair)totalNESIWithIdxSorted.remove(0);
                childResults.remove(previousPair.getRight());
                double previousTotalNESIWithIdx = (Double)previousPair.getLeft();
                double percentForCandidates = ((PredicateParseResult)previousPair.getRight()).getPercentSelected();
                double nESIWithIdx = ((PredicateParseResult)previousPair.getRight()).getnESIWithIdx();
                FixedLenBitset candidateDims = this.MUTABLE_EMPTY_SET().union(((PredicateParseResult)previousPair.getRight()).getCandidateDims());
                while (totalNESIWithIdxSorted.size() > 0) {
                    previousPair = (Pair)totalNESIWithIdxSorted.remove(0);
                    childResults.remove(previousPair.getRight());
                    candidateDims.union(((PredicateParseResult)previousPair.getRight()).getCandidateDims());
                    this.LOGGER.debug("childResults {}", childResults);
                    this.LOGGER.debug("nESIWithIdx {}", (Object)(nESIWithIdx += ((PredicateParseResult)previousPair.getRight()).getnESIWithIdx()));
                    double tmpTotalNESIWithIdx = nESIWithIdx;
                    double tmpPercentSelected = percentForCandidates *= ((PredicateParseResult)previousPair.getRight()).getPercentSelected();
                    for (PredicateParseResult childResult : childResults) {
                        tmpTotalNESIWithIdx += childResult.getnESI() * tmpPercentSelected;
                        tmpPercentSelected *= childResult.getPercentSelected();
                    }
                    this.LOGGER.debug("tmpTotalNESIWithIdx {}", (Object)tmpTotalNESIWithIdx);
                    if (!(previousTotalNESIWithIdx - tmpTotalNESIWithIdx > this._params.THRESHOLD_MIN_AND_PREDICATE_INCREMENTAL_VOTE)) break;
                    ret.add(PredicateParseResult.PredicateParseResultBuilder.aPredicateParseResult().setCandidateDims(candidateDims).setIteratorEvalPriorityEnum(IteratorEvalPriorityEnum.AND).setRecommendationPriorityEnum(RecommendationPriorityEnum.BITMAP).setnESI(totalNESI).setPercentSelected(tmpPercentSelected).setnESIWithIdx(tmpTotalNESIWithIdx).setQueryWeight(queryWeight).build());
                    previousTotalNESIWithIdx = tmpTotalNESIWithIdx;
                }
            }
            ret.add(PredicateParseResult.PredicateParseResultBuilder.aPredicateParseResult().setCandidateDims(FixedLenBitset.IMMUTABLE_EMPTY_SET).setIteratorEvalPriorityEnum(IteratorEvalPriorityEnum.AND).setRecommendationPriorityEnum(RecommendationPriorityEnum.NESTED).setnESI(totalNESI).setPercentSelected(percentSelected).setnESIWithIdx(totalNESI).setQueryWeight(queryWeight).build());
            return Collections.singletonList(ret);
        }
        if (type == FilterContext.Type.OR) {
            ArrayList<List<PredicateParseResult>> childResults = new ArrayList<List<PredicateParseResult>>();
            for (int i = 0; i < filterContextTopLevel.getChildren().size(); ++i) {
                List<List<PredicateParseResult>> childResult = this.parseTopLevel((FilterContext)filterContextTopLevel.getChildren().get(i), queryWeight);
                if (childResult == null) continue;
                childResults.addAll(childResult);
            }
            this.LOGGER.debug("parseTopLevel: OR: Child results: {}", childResults);
            if (childResults.isEmpty()) {
                return EMPTY_PARSE_RESULT;
            }
            return childResults;
        }
        PredicateParseResult predicateParseResult = this.parseLeafPredicate(filterContextTopLevel, 0);
        ArrayList<PredicateParseResult> ret = new ArrayList<PredicateParseResult>();
        if (predicateParseResult == null) {
            return EMPTY_PARSE_RESULT;
        }
        ret.add(PredicateParseResult.PredicateParseResultBuilder.aPredicateParseResult().setCandidateDims(FixedLenBitset.IMMUTABLE_EMPTY_SET).setIteratorEvalPriorityEnum(predicateParseResult._iteratorEvalPriorityEnum).setRecommendationPriorityEnum(predicateParseResult._recommendationPriorityEnum).setnESI(predicateParseResult._nESI).setPercentSelected(predicateParseResult._percentSelected).setnESIWithIdx(predicateParseResult._nESI).setQueryWeight(queryWeight).build());
        ret.add(predicateParseResult.multiplyWeight(queryWeight));
        this.LOGGER.debug("parseTopLevel: LEAF: Child results: {}", ret);
        return Collections.singletonList(ret);
    }

    private PredicateParseResult parsePredicateList(FilterContext predicateList, int depth) {
        this.LOGGER.debug("parsePredicateList: Parsing predicate list: {}", (Object)predicateList.toString());
        FilterContext.Type type = predicateList.getType();
        if (type == FilterContext.Type.AND) {
            this.LOGGER.trace("parsePredicateList: Parsing AND list {}", (Object)predicateList.toString());
            FixedLenBitset candidateDims = this.MUTABLE_EMPTY_SET();
            double nESI = 0.0;
            double percentSelected = 1.0;
            List<PredicateParseResult> childResults = new ArrayList<PredicateParseResult>();
            boolean isPureBitmap = false;
            for (int i = 0; i < predicateList.getChildren().size(); ++i) {
                PredicateParseResult childResult = this.parsePredicateList((FilterContext)predicateList.getChildren().get(i), depth + 1);
                if (childResult == null) continue;
                childResults.add(childResult);
            }
            childResults = this.reorderAndPredicateList(childResults);
            this.LOGGER.debug("parsePredicateList: AND: Reordered child results: {}", childResults);
            if (childResults.get(childResults.size() - 1).getIteratorEvalPriority().compareTo(IteratorEvalPriorityEnum.INDEXED) <= 0) {
                isPureBitmap = true;
            }
            for (PredicateParseResult childResult : childResults) {
                nESI += childResult.getnESI() * percentSelected;
                percentSelected *= childResult.getPercentSelected();
            }
            if (isPureBitmap) {
                return PredicateParseResult.PredicateParseResultBuilder.aPredicateParseResult().setCandidateDims(FixedLenBitset.IMMUTABLE_EMPTY_SET).setIteratorEvalPriorityEnum(IteratorEvalPriorityEnum.INDEXED).setRecommendationPriorityEnum(RecommendationPriorityEnum.BITMAP).setnESI(nESI).setPercentSelected(percentSelected).setnESIWithIdx(nESI).build();
            }
            Map groupedPredicates = childResults.stream().collect(Collectors.groupingBy(PredicateParseResult::getRecommendationPriorityEnum, Collectors.toList()));
            if (groupedPredicates.containsKey((Object)RecommendationPriorityEnum.NESTED) || !groupedPredicates.containsKey((Object)RecommendationPriorityEnum.BITMAP) && !groupedPredicates.containsKey((Object)RecommendationPriorityEnum.CANDIDATE_SCAN)) {
                return PredicateParseResult.PredicateParseResultBuilder.aPredicateParseResult().setCandidateDims(FixedLenBitset.IMMUTABLE_EMPTY_SET).setIteratorEvalPriorityEnum(IteratorEvalPriorityEnum.AND).setRecommendationPriorityEnum(RecommendationPriorityEnum.NESTED).setnESI(nESI).setPercentSelected(percentSelected).setnESIWithIdx(nESI).build();
            }
            Optional<PredicateParseResult> newCandidateOptional = groupedPredicates.getOrDefault((Object)RecommendationPriorityEnum.CANDIDATE_SCAN, Collections.emptyList()).stream().filter(PredicateParseResult::hasCandidateDim).min(Comparator.comparing(PredicateParseResult::getPercentSelected));
            double bitmapPercentSelected = 1.0;
            double bitmapNESIWithIdx = 0.0;
            for (PredicateParseResult predicateParseResult2 : groupedPredicates.getOrDefault((Object)RecommendationPriorityEnum.BITMAP, Collections.emptyList())) {
                bitmapPercentSelected *= predicateParseResult2.getPercentSelected();
                bitmapNESIWithIdx += predicateParseResult2.getnESIWithIdx();
                candidateDims.union(predicateParseResult2.getCandidateDims());
            }
            if (depth > 1) {
                if (groupedPredicates.containsKey((Object)RecommendationPriorityEnum.BITMAP)) {
                    newCandidateOptional = Optional.empty();
                }
            } else if (newCandidateOptional.isPresent() && newCandidateOptional.get().getPercentSelected() > bitmapPercentSelected) {
                newCandidateOptional = Optional.empty();
            }
            newCandidateOptional.ifPresent(predicateParseResult -> candidateDims.union(predicateParseResult.getCandidateDims()));
            double percentSelectedWithIdx = newCandidateOptional.map(PredicateParseResult::getPercentSelected).orElse(1.0);
            double nESIWithIdx = newCandidateOptional.map(PredicateParseResult::getnESIWithIdx).orElse(0.0);
            percentSelectedWithIdx *= bitmapPercentSelected;
            nESIWithIdx += bitmapNESIWithIdx;
            for (PredicateParseResult predicateParseResult3 : groupedPredicates.getOrDefault((Object)RecommendationPriorityEnum.CANDIDATE_SCAN, Collections.emptyList())) {
                if (predicateParseResult3 == newCandidateOptional.orElse(null)) continue;
                nESIWithIdx += predicateParseResult3.getnESI() * percentSelectedWithIdx;
                percentSelectedWithIdx *= predicateParseResult3.getPercentSelected();
            }
            for (PredicateParseResult predicateParseResult3 : groupedPredicates.getOrDefault((Object)RecommendationPriorityEnum.NON_CANDIDATE_SCAN, Collections.emptyList())) {
                nESIWithIdx += predicateParseResult3.getnESI() * percentSelectedWithIdx;
                percentSelectedWithIdx *= predicateParseResult3.getPercentSelected();
            }
            return PredicateParseResult.PredicateParseResultBuilder.aPredicateParseResult().setCandidateDims(candidateDims).setIteratorEvalPriorityEnum(IteratorEvalPriorityEnum.AND).setRecommendationPriorityEnum(RecommendationPriorityEnum.BITMAP).setnESI(nESI).setPercentSelected(percentSelected).setnESIWithIdx(nESIWithIdx).build();
        }
        if (type == FilterContext.Type.OR) {
            this.LOGGER.trace("parsePredicateList: OR Parsing  list: {}", (Object)predicateList.toString());
            ArrayList<PredicateParseResult> childResults = new ArrayList<PredicateParseResult>();
            FixedLenBitset candidateDims = this.MUTABLE_EMPTY_SET();
            double nESI = 0.0;
            double nESIWithIdx = 0.0;
            double percentSelected = 0.0;
            boolean isPureBitmap = true;
            boolean isBitmapConvertable = true;
            for (int i = 0; i < predicateList.getChildren().size(); ++i) {
                PredicateParseResult childResult = this.parsePredicateList((FilterContext)predicateList.getChildren().get(i), depth + 1);
                if (childResult == null) continue;
                childResults.add(childResult);
            }
            this.LOGGER.debug("parsePredicateList: OR: childResults {}", childResults);
            for (PredicateParseResult childResult : childResults) {
                nESI += childResult.getnESI();
                percentSelected += childResult.getPercentSelected();
                nESIWithIdx += childResult.getnESIWithIdx();
                candidateDims.union(childResult.getCandidateDims());
                if (!childResult.isBitmapConvertable()) {
                    isBitmapConvertable = false;
                }
                if (childResult.getIteratorEvalPriority().compareTo(IteratorEvalPriorityEnum.INDEXED) <= 0) continue;
                isPureBitmap = false;
            }
            this.LOGGER.trace("parsePredicateList: OR: parsePredicateList(): isPureBitmap {} hasCandidateDim {}", (Object)isPureBitmap, (Object)isBitmapConvertable);
            percentSelected = Math.min(percentSelected, 1.0);
            if (isPureBitmap) {
                return PredicateParseResult.PredicateParseResultBuilder.aPredicateParseResult().setCandidateDims(candidateDims).setIteratorEvalPriorityEnum(IteratorEvalPriorityEnum.INDEXED).setRecommendationPriorityEnum(RecommendationPriorityEnum.BITMAP).setnESI(nESI).setPercentSelected(percentSelected).setnESIWithIdx(nESIWithIdx).build();
            }
            if (isBitmapConvertable) {
                return PredicateParseResult.PredicateParseResultBuilder.aPredicateParseResult().setCandidateDims(candidateDims).setIteratorEvalPriorityEnum(IteratorEvalPriorityEnum.OR).setRecommendationPriorityEnum(RecommendationPriorityEnum.BITMAP).setnESI(nESI).setPercentSelected(percentSelected).setnESIWithIdx(nESIWithIdx).build();
            }
            return PredicateParseResult.PredicateParseResultBuilder.aPredicateParseResult().setCandidateDims(FixedLenBitset.IMMUTABLE_EMPTY_SET).setIteratorEvalPriorityEnum(IteratorEvalPriorityEnum.OR).setRecommendationPriorityEnum(RecommendationPriorityEnum.NESTED).setnESI(nESI).setPercentSelected(percentSelected).setnESIWithIdx(nESI).build();
        }
        PredicateParseResult predicateParseResult4 = this.parseLeafPredicate(predicateList, depth);
        this.LOGGER.debug("parsePredicateList: Parsed a leaf predicate: {}", (Object)predicateParseResult4);
        return predicateParseResult4;
    }

    private PredicateParseResult parseLeafPredicate(FilterContext leafPredicate, int depth) {
        this.LOGGER.trace("parseLeafPredicate: Parsing predicate: {}", (Object)leafPredicate.toString());
        Predicate predicate = leafPredicate.getPredicate();
        Predicate.Type type = predicate.getType();
        ExpressionContext lhs = predicate.getLhs();
        String colName = predicate.getLhs().toString();
        double numValuesPerEntry = this._inputManager.getNumValuesPerEntry(colName);
        if (lhs.getType() == ExpressionContext.Type.FUNCTION) {
            double nESI = this.flattenFunction(lhs);
            return PredicateParseResult.PredicateParseResultBuilder.aPredicateParseResult().setCandidateDims(FixedLenBitset.IMMUTABLE_EMPTY_SET).setIteratorEvalPriorityEnum(IteratorEvalPriorityEnum.SCAN).setRecommendationPriorityEnum(RecommendationPriorityEnum.NON_CANDIDATE_SCAN).setnESI(nESI).setPercentSelected(this._params.PERCENT_SELECT_FOR_FUNCTION).setnESIWithIdx(nESI).build();
        }
        if (type == Predicate.Type.RANGE) {
            this.LOGGER.trace("Entering RANGE clause: {}", (Object)leafPredicate);
            if (this._useOverwrittenIndices && (this._indexOverwritten.hasSortedIndex(colName) || this._indexOverwritten.hasRangeIndex(colName))) {
                return PredicateParseResult.PredicateParseResultBuilder.aPredicateParseResult().setCandidateDims(FixedLenBitset.IMMUTABLE_EMPTY_SET).setIteratorEvalPriorityEnum(IteratorEvalPriorityEnum.INDEXED).setRecommendationPriorityEnum(RecommendationPriorityEnum.BITMAP).setnESI(0.0).setPercentSelected(this._params.PERCENT_SELECT_FOR_RANGE).setnESIWithIdx(0.0).build();
            }
            return PredicateParseResult.PredicateParseResultBuilder.aPredicateParseResult().setCandidateDims(FixedLenBitset.IMMUTABLE_EMPTY_SET).setIteratorEvalPriorityEnum(IteratorEvalPriorityEnum.SCAN).setRecommendationPriorityEnum(RecommendationPriorityEnum.NON_CANDIDATE_SCAN).setnESI(numValuesPerEntry).setPercentSelected(this._params.PERCENT_SELECT_FOR_RANGE).setnESIWithIdx(numValuesPerEntry).build();
        }
        if (this._inputManager.getColNamesNoDictionary().contains(colName)) {
            return PredicateParseResult.PredicateParseResultBuilder.aPredicateParseResult().setCandidateDims(FixedLenBitset.IMMUTABLE_EMPTY_SET).setIteratorEvalPriorityEnum(IteratorEvalPriorityEnum.SCAN).setRecommendationPriorityEnum(RecommendationPriorityEnum.NON_CANDIDATE_SCAN).setnESI(numValuesPerEntry).setPercentSelected(this._params.PERCENT_SELECT_FOR_RANGE).setnESIWithIdx(numValuesPerEntry).build();
        }
        if (type == Predicate.Type.IN || type == Predicate.Type.NOT_IN) {
            List values;
            this.LOGGER.trace("Entering IN clause: {}", (Object)leafPredicate);
            double cardinality = this._inputManager.getCardinality(colName);
            this.LOGGER.trace("Cardinality: {} {}", (Object)colName, (Object)cardinality);
            FixedLenBitset candidateDims = this.MUTABLE_EMPTY_SET();
            candidateDims.add(this._inputManager.colNameToInt(colName));
            boolean isFirst = false;
            List list = values = type == Predicate.Type.IN ? ((InPredicate)predicate).getValues() : ((NotInPredicate)predicate).getValues();
            int numValuesSelected = values.size() == 1 ? 1 : (((String)values.get(0)).equals("#VALUES") || (isFirst = ((String)values.get(1)).equals("#VALUES")) ? Integer.parseInt((String)values.get(isFirst ? 0 : 1)) : values.size());
            Boolean isExclusive = leafPredicate.getPredicate().getType().isExclusive();
            this.LOGGER.debug("Length of in clause: {}", (Object)numValuesSelected);
            if (this._useOverwrittenIndices && (this._indexOverwritten.hasInvertedIndex(colName) || this._indexOverwritten.hasSortedIndex(colName))) {
                return PredicateParseResult.PredicateParseResultBuilder.aPredicateParseResult().setCandidateDims(FixedLenBitset.IMMUTABLE_EMPTY_SET).setIteratorEvalPriorityEnum(IteratorEvalPriorityEnum.INDEXED).setRecommendationPriorityEnum(RecommendationPriorityEnum.BITMAP).setnESI(0.0).setPercentSelected(QueryInvertedSortedIndexRecommender.percentSelected(isExclusive, cardinality, numValuesSelected, numValuesPerEntry)).setnESIWithIdx(0.0).build();
            }
            return PredicateParseResult.PredicateParseResultBuilder.aPredicateParseResult().setCandidateDims(candidateDims).setIteratorEvalPriorityEnum(IteratorEvalPriorityEnum.SCAN).setRecommendationPriorityEnum(RecommendationPriorityEnum.CANDIDATE_SCAN).setnESI(numValuesPerEntry).setPercentSelected(QueryInvertedSortedIndexRecommender.percentSelected(isExclusive, cardinality, numValuesSelected, numValuesPerEntry)).setnESIWithIdx(0.0).build();
        }
        if (type == Predicate.Type.EQ || type == Predicate.Type.NOT_EQ) {
            this.LOGGER.trace("Entering COMP clause: {}", (Object)leafPredicate);
            double cardinality = this._inputManager.getCardinality(colName);
            this.LOGGER.trace("Cardinality: {} {}", (Object)colName, (Object)cardinality);
            FixedLenBitset candidateDims = this.MUTABLE_EMPTY_SET();
            candidateDims.add(this._inputManager.colNameToInt(colName));
            Boolean isExclusive = leafPredicate.getPredicate().getType().isExclusive();
            if (this._useOverwrittenIndices && (this._indexOverwritten.hasInvertedIndex(colName) || this._indexOverwritten.hasSortedIndex(colName))) {
                return PredicateParseResult.PredicateParseResultBuilder.aPredicateParseResult().setCandidateDims(FixedLenBitset.IMMUTABLE_EMPTY_SET).setIteratorEvalPriorityEnum(IteratorEvalPriorityEnum.INDEXED).setRecommendationPriorityEnum(RecommendationPriorityEnum.BITMAP).setnESI(0.0).setPercentSelected(QueryInvertedSortedIndexRecommender.percentSelected(isExclusive, cardinality, 1, numValuesPerEntry)).setnESIWithIdx(0.0).build();
            }
            return PredicateParseResult.PredicateParseResultBuilder.aPredicateParseResult().setCandidateDims(candidateDims).setIteratorEvalPriorityEnum(IteratorEvalPriorityEnum.SCAN).setRecommendationPriorityEnum(RecommendationPriorityEnum.CANDIDATE_SCAN).setnESI(numValuesPerEntry).setPercentSelected(QueryInvertedSortedIndexRecommender.percentSelected(isExclusive, cardinality, 1, numValuesPerEntry)).setnESIWithIdx(0.0).build();
        }
        if (type == Predicate.Type.TEXT_MATCH) {
            return PredicateParseResult.PredicateParseResultBuilder.aPredicateParseResult().setCandidateDims(FixedLenBitset.IMMUTABLE_EMPTY_SET).setIteratorEvalPriorityEnum(IteratorEvalPriorityEnum.INDEXED).setRecommendationPriorityEnum(RecommendationPriorityEnum.BITMAP).setnESI(0.0).setPercentSelected(this._params.PERCENT_SELECT_FOR_TEXT_MATCH).setnESIWithIdx(0.0).build();
        }
        if (type == Predicate.Type.REGEXP_LIKE) {
            return PredicateParseResult.PredicateParseResultBuilder.aPredicateParseResult().setCandidateDims(FixedLenBitset.IMMUTABLE_EMPTY_SET).setIteratorEvalPriorityEnum(IteratorEvalPriorityEnum.SCAN).setRecommendationPriorityEnum(RecommendationPriorityEnum.NON_CANDIDATE_SCAN).setnESI(numValuesPerEntry).setPercentSelected(this._params.PERCENT_SELECT_FOR_REGEX).setnESIWithIdx(0.0).build();
        }
        if (type == Predicate.Type.IS_NOT_NULL || type == Predicate.Type.IS_NULL) {
            return PredicateParseResult.PredicateParseResultBuilder.aPredicateParseResult().setCandidateDims(FixedLenBitset.IMMUTABLE_EMPTY_SET).setIteratorEvalPriorityEnum(IteratorEvalPriorityEnum.INDEXED).setRecommendationPriorityEnum(RecommendationPriorityEnum.BITMAP).setnESI(0.0).setPercentSelected(this._params.PERCENT_SELECT_FOR_ISNULL).setnESIWithIdx(0.0).build();
        }
        return PredicateParseResult.PredicateParseResultBuilder.aPredicateParseResult().setCandidateDims(FixedLenBitset.IMMUTABLE_EMPTY_SET).setIteratorEvalPriorityEnum(IteratorEvalPriorityEnum.SCAN).setRecommendationPriorityEnum(RecommendationPriorityEnum.NON_CANDIDATE_SCAN).setnESI(numValuesPerEntry).setPercentSelected(this._params.PERCENT_SELECT_FOR_RANGE).setnESIWithIdx(numValuesPerEntry).build();
    }

    public static double percentSelected(Boolean invertSelection, double cardinality, int numSelectedValues, double numEntriesPerDoc) {
        double pInverted;
        int k = numSelectedValues;
        double r = numEntriesPerDoc;
        double n = cardinality;
        if ((double)k + r <= n) {
            if (r != 1.0 && k != 1) {
                pInverted = 1.0;
                for (int i = 0; i < k; ++i) {
                    pInverted *= (n - r - (double)i) / (n - (double)i);
                }
            } else {
                pInverted = 1.0 - Math.max((double)k, r) / n;
            }
        } else {
            pInverted = 0.0;
        }
        if (!invertSelection.booleanValue()) {
            return 1.0 - pInverted;
        }
        return pInverted;
    }

    private double flattenFunction(ExpressionContext expression) {
        double ret = 0.0;
        HashSet dimNames = new HashSet();
        expression.getColumns(dimNames);
        for (String dimName : dimNames) {
            if (!this._inputManager.isDim(dimName)) continue;
            ret += this._inputManager.getNumValuesPerEntry(dimName);
        }
        return ret;
    }

    private FixedLenBitset MUTABLE_EMPTY_SET() {
        return new FixedLenBitset(this._numColumnsIndexApplicable);
    }

    public static final class QueryInvertedSortedIndexRecommenderBuilder {
        private InputManager _inputManager;
        private boolean _useOverwrittenIndices = true;
        private InvertedSortedIndexJointRuleParams _invertedSortedIndexJointRuleParams;

        private QueryInvertedSortedIndexRecommenderBuilder() {
        }

        public static QueryInvertedSortedIndexRecommenderBuilder aQueryInvertedSortedIndexRecommender() {
            return new QueryInvertedSortedIndexRecommenderBuilder();
        }

        public QueryInvertedSortedIndexRecommenderBuilder setInputManager(InputManager inputManager) {
            this._inputManager = inputManager;
            return this;
        }

        public QueryInvertedSortedIndexRecommenderBuilder setUseOverwrittenIndices(boolean useOverwrittenIndices) {
            this._useOverwrittenIndices = useOverwrittenIndices;
            return this;
        }

        public QueryInvertedSortedIndexRecommenderBuilder setInvertedSortedIndexJointRuleParams(InvertedSortedIndexJointRuleParams invertedSortedIndexJointRuleParams) {
            this._invertedSortedIndexJointRuleParams = invertedSortedIndexJointRuleParams;
            return this;
        }

        public QueryInvertedSortedIndexRecommender build() {
            QueryInvertedSortedIndexRecommender queryInvertedSortedIndexRecommender = new QueryInvertedSortedIndexRecommender();
            queryInvertedSortedIndexRecommender._params = this._invertedSortedIndexJointRuleParams;
            queryInvertedSortedIndexRecommender._useOverwrittenIndices = this._useOverwrittenIndices;
            queryInvertedSortedIndexRecommender._inputManager = this._inputManager;
            queryInvertedSortedIndexRecommender._numColumnsIndexApplicable = this._inputManager.getNumColumnsInvertedSortedApplicable();
            queryInvertedSortedIndexRecommender._indexOverwritten = this._inputManager.getOverWrittenConfigs().getIndexConfig();
            queryInvertedSortedIndexRecommender._queryType = this._inputManager.getQueryType();
            return queryInvertedSortedIndexRecommender;
        }
    }

    public static enum RecommendationPriorityEnum {
        BITMAP,
        CANDIDATE_SCAN,
        NON_CANDIDATE_SCAN,
        NESTED;

    }

    public static enum IteratorEvalPriorityEnum {
        INDEXED,
        AND,
        OR,
        SCAN,
        EXPRESSION;

    }
}

