/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.util;

import com.google.common.collect.BiMap;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.pinot.common.restlet.resources.TableMetadataInfo;
import org.apache.pinot.controller.util.CompletionServiceHelper;
import org.apache.pinot.spi.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerSegmentMetadataReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerSegmentMetadataReader.class);
    private final Executor _executor;
    private final HttpConnectionManager _connectionManager;

    public ServerSegmentMetadataReader(Executor executor, HttpConnectionManager connectionManager) {
        this._executor = executor;
        this._connectionManager = connectionManager;
    }

    public TableMetadataInfo getAggregatedTableMetadataFromServer(String tableNameWithType, BiMap<String, String> serverEndPoints, List<String> columns, int numReplica, int timeoutMs) {
        int numServers = serverEndPoints.size();
        LOGGER.info("Reading aggregated segment metadata from {} servers for table: {} with timeout: {}ms", new Object[]{numServers, tableNameWithType, timeoutMs});
        ArrayList<String> serverUrls = new ArrayList<String>(numServers);
        BiMap endpointsToServers = serverEndPoints.inverse();
        for (String endpoint : endpointsToServers.keySet()) {
            String serverUrl = this.generateAggregateSegmentMetadataServerURL(tableNameWithType, columns, endpoint);
            serverUrls.add(serverUrl);
        }
        CompletionServiceHelper completionServiceHelper = new CompletionServiceHelper(this._executor, this._connectionManager, (BiMap<String, String>)endpointsToServers);
        CompletionServiceHelper.CompletionServiceResponse serviceResponse = completionServiceHelper.doMultiGetRequest(serverUrls, tableNameWithType, false, timeoutMs);
        TableMetadataInfo aggregateTableMetadataInfo = new TableMetadataInfo();
        int totalNumSegments = 0;
        int failedParses = 0;
        for (Map.Entry<String, String> streamResponse : serviceResponse._httpResponses.entrySet()) {
            try {
                TableMetadataInfo tableMetadataInfo = (TableMetadataInfo)JsonUtils.stringToObject((String)streamResponse.getValue(), TableMetadataInfo.class);
                aggregateTableMetadataInfo.diskSizeInBytes += tableMetadataInfo.diskSizeInBytes;
                aggregateTableMetadataInfo.numRows += tableMetadataInfo.numRows;
                totalNumSegments = (int)((long)totalNumSegments + tableMetadataInfo.numSegments);
                tableMetadataInfo.columnLengthMap.forEach((k, v) -> aggregateTableMetadataInfo.columnLengthMap.merge(k, v, Double::sum));
                tableMetadataInfo.columnCardinalityMap.forEach((k, v) -> aggregateTableMetadataInfo.columnCardinalityMap.merge(k, v, Double::sum));
            }
            catch (IOException e) {
                ++failedParses;
                LOGGER.error("Unable to parse server {} response due to an error: ", (Object)streamResponse.getKey(), (Object)e);
            }
        }
        aggregateTableMetadataInfo.numSegments = totalNumSegments;
        aggregateTableMetadataInfo.columnLengthMap.replaceAll((k, v) -> v / (double)aggregateTableMetadataInfo.numSegments);
        aggregateTableMetadataInfo.columnCardinalityMap.replaceAll((k, v) -> v / (double)aggregateTableMetadataInfo.numSegments);
        aggregateTableMetadataInfo.diskSizeInBytes /= (long)numReplica;
        aggregateTableMetadataInfo.numRows /= (long)numReplica;
        aggregateTableMetadataInfo.numSegments /= (long)numReplica;
        if (failedParses != 0) {
            LOGGER.warn("Failed to parse {} / {} aggregated segment metadata responses from servers.", (Object)failedParses, (Object)serverUrls.size());
        }
        return aggregateTableMetadataInfo;
    }

    public List<String> getSegmentMetadataFromServer(String tableNameWithType, Map<String, List<String>> serversToSegmentsMap, BiMap<String, String> endpoints, List<String> columns, int timeoutMs) {
        LOGGER.debug("Reading segment metadata from servers for table {}.", (Object)tableNameWithType);
        ArrayList<String> serverURLs = new ArrayList<String>();
        for (Map.Entry<String, List<String>> serverToSegments : serversToSegmentsMap.entrySet()) {
            List<String> segments = serverToSegments.getValue();
            for (String segment : segments) {
                serverURLs.add(this.generateSegmentMetadataServerURL(tableNameWithType, segment, columns, (String)endpoints.get((Object)serverToSegments.getKey())));
            }
        }
        BiMap endpointsToServers = endpoints.inverse();
        CompletionServiceHelper completionServiceHelper = new CompletionServiceHelper(this._executor, this._connectionManager, (BiMap<String, String>)endpointsToServers);
        CompletionServiceHelper.CompletionServiceResponse serviceResponse = completionServiceHelper.doMultiGetRequest(serverURLs, tableNameWithType, true, timeoutMs);
        ArrayList<String> segmentsMetadata = new ArrayList<String>();
        int failedParses = 0;
        for (Map.Entry<String, String> streamResponse : serviceResponse._httpResponses.entrySet()) {
            try {
                String segmentMetadata = streamResponse.getValue();
                segmentsMetadata.add(segmentMetadata);
            }
            catch (Exception e) {
                ++failedParses;
                LOGGER.error("Unable to parse server {} response due to an error: ", (Object)streamResponse.getKey(), (Object)e);
            }
        }
        if (failedParses != 0) {
            LOGGER.error("Unable to parse server {} / {} response due to an error: ", (Object)failedParses, (Object)serverURLs.size());
        }
        LOGGER.debug("Retrieved segment metadata from servers.");
        return segmentsMetadata;
    }

    private String generateAggregateSegmentMetadataServerURL(String tableNameWithType, List<String> columns, String endpoint) {
        try {
            tableNameWithType = URLEncoder.encode(tableNameWithType, StandardCharsets.UTF_8.name());
            String paramsStr = "";
            if (columns != null) {
                ArrayList<String> params = new ArrayList<String>(columns.size());
                for (String column : columns) {
                    params.add(String.format("columns=%s", column));
                }
                paramsStr = String.join((CharSequence)"&", params);
            }
            return String.format("%s/tables/%s/metadata?%s", endpoint, tableNameWithType, paramsStr);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    private String generateSegmentMetadataServerURL(String tableNameWithType, String segmentName, List<String> columns, String endpoint) {
        try {
            tableNameWithType = URLEncoder.encode(tableNameWithType, StandardCharsets.UTF_8.name());
            segmentName = URLEncoder.encode(segmentName, StandardCharsets.UTF_8.name());
            String paramsStr = "";
            if (columns != null) {
                ArrayList<String> params = new ArrayList<String>(columns.size());
                for (String column : columns) {
                    params.add(String.format("columns=%s", column));
                }
                paramsStr = String.join((CharSequence)"&", params);
            }
            return String.format("%s/tables/%s/segments/%s/metadata?%s", endpoint, tableNameWithType, segmentName, paramsStr);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getCause());
        }
    }
}

