/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.util;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.ws.rs.core.Response;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.helix.task.TaskState;
import org.apache.pinot.controller.api.exception.ControllerApplicationException;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.controller.helix.core.minion.PinotHelixTaskResourceManager;
import org.apache.pinot.controller.util.ConsumingSegmentInfoReader;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.TableStatus;
import org.apache.pinot.spi.config.table.TableTaskConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableIngestionStatusHelper {
    public static Logger LOGGER = LoggerFactory.getLogger(TableIngestionStatusHelper.class);

    public static TableStatus.IngestionStatus getRealtimeTableIngestionStatus(String tableNameWithType, int timeoutMs, Executor executor, HttpConnectionManager connectionManager, PinotHelixResourceManager pinotHelixResourceManager) {
        ConsumingSegmentInfoReader consumingSegmentInfoReader = new ConsumingSegmentInfoReader(executor, connectionManager, pinotHelixResourceManager);
        return consumingSegmentInfoReader.getIngestionStatus(tableNameWithType, timeoutMs);
    }

    public static TableStatus.IngestionStatus getOfflineTableIngestionStatus(String tableNameWithType, PinotHelixResourceManager pinotHelixResourceManager, PinotHelixTaskResourceManager pinotHelixTaskResourceManager) {
        TableConfig tableConfig = pinotHelixResourceManager.getTableConfig(tableNameWithType);
        TableTaskConfig taskConfig = tableConfig.getTaskConfig();
        if (taskConfig == null || taskConfig.getConfigsForTaskType("SegmentGenerationAndPushTask") == null) {
            throw new ControllerApplicationException(LOGGER, "Cannot retrieve ingestion status for Table : " + tableNameWithType + " since it does not use the built-in SegmentGenerationAndPushTask task", Response.Status.BAD_REQUEST);
        }
        TableStatus.IngestionState ingestionState = TableStatus.IngestionState.HEALTHY;
        Object errorMessage = "";
        Map<String, TaskState> taskStateMap = pinotHelixTaskResourceManager.getTaskStatesByTable("SegmentGenerationAndPushTask", tableNameWithType);
        ArrayList<String> failedTasks = new ArrayList<String>();
        for (Map.Entry<String, TaskState> taskStateEntry : taskStateMap.entrySet()) {
            switch (taskStateEntry.getValue()) {
                case FAILED: 
                case ABORTED: {
                    failedTasks.add(taskStateEntry.getKey());
                }
            }
        }
        if (failedTasks.size() > 0) {
            ingestionState = TableStatus.IngestionState.UNHEALTHY;
            errorMessage = "Follow ingestion tasks have failed: " + ((Object)failedTasks).toString();
        }
        return new TableStatus.IngestionStatus(ingestionState.toString(), (String)errorMessage);
    }
}

