/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.model.validation;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.model.validation.RangerServiceDefHelper;
import org.apache.ranger.plugin.policyresourcematcher.RangerDefaultPolicyResourceMatcher;
import org.apache.ranger.plugin.policyresourcematcher.RangerPolicyResourceEvaluator;
import org.apache.ranger.plugin.policyresourcematcher.RangerPolicyResourceMatcher;
import org.apache.ranger.plugin.resourcematcher.RangerResourceMatcher;
import org.apache.ranger.plugin.util.ServiceDefUtil;

public class RangerZoneResourceMatcher
implements RangerPolicyResourceEvaluator {
    private static final Log LOG = LogFactory.getLog(RangerZoneResourceMatcher.class);
    private final String securityZoneName;
    private final Map<String, RangerPolicy.RangerPolicyResource> policyResource;
    private final RangerPolicyResourceMatcher policyResourceMatcher;
    private RangerServiceDef.RangerResourceDef leafResourceDef;

    public RangerZoneResourceMatcher(String securityZoneName, Map<String, RangerPolicy.RangerPolicyResource> policyResource, RangerServiceDef serviceDef) {
        RangerServiceDefHelper serviceDefHelper = new RangerServiceDefHelper(serviceDef);
        Set<String> resourceKeys = policyResource.keySet();
        RangerDefaultPolicyResourceMatcher matcher = new RangerDefaultPolicyResourceMatcher();
        matcher.setServiceDef(serviceDef);
        matcher.setServiceDefHelper(serviceDefHelper);
        boolean found = false;
        for (int policyType : RangerPolicy.POLICY_TYPES) {
            for (List<RangerServiceDef.RangerResourceDef> hierarchy : serviceDefHelper.getResourceHierarchies(policyType)) {
                if (!serviceDefHelper.hierarchyHasAllResources(hierarchy, resourceKeys)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Found hierarchy for resource-keys:[" + resourceKeys + "], policy-type:[" + policyType + "]"));
                }
                matcher.setPolicyResources(policyResource, policyType);
                found = true;
                break;
            }
            if (found) break;
        }
        if (found) {
            matcher.init();
        } else {
            LOG.error((Object)"Cannot initialize matcher for RangerZoneResourceMatcher");
        }
        this.securityZoneName = securityZoneName;
        this.policyResourceMatcher = matcher;
        this.policyResource = policyResource;
        this.leafResourceDef = ServiceDefUtil.getLeafResourceDef(serviceDef, this.getPolicyResource());
    }

    public String getSecurityZoneName() {
        return this.securityZoneName;
    }

    @Override
    public long getId() {
        return this.securityZoneName.hashCode();
    }

    @Override
    public RangerPolicyResourceMatcher getPolicyResourceMatcher() {
        return this.policyResourceMatcher;
    }

    @Override
    public Map<String, RangerPolicy.RangerPolicyResource> getPolicyResource() {
        return this.policyResource;
    }

    @Override
    public RangerResourceMatcher getResourceMatcher(String resourceName) {
        return this.policyResourceMatcher != null ? this.policyResourceMatcher.getResourceMatcher(resourceName) : null;
    }

    @Override
    public boolean isAncestorOf(RangerServiceDef.RangerResourceDef resourceDef) {
        return ServiceDefUtil.isAncestorOf(this.policyResourceMatcher.getServiceDef(), this.leafResourceDef, resourceDef);
    }

    public String toString() {
        return "{security-zone-name:[" + this.securityZoneName + "], policyResource=[" + this.policyResource + "]}";
    }
}

