/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.web.api.rest;

import javax.servlet.http.HttpServletResponse;
import org.apache.rave.portal.model.Page;
import org.apache.rave.portal.model.Region;
import org.apache.rave.portal.model.RegionWidget;
import org.apache.rave.portal.service.PageService;
import org.apache.rave.portal.web.api.rest.AbstractRestApi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="restPageApi")
@RequestMapping(value={"/api/rest/page/*"})
public class PageApi
extends AbstractRestApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private PageService pageService;

    @Autowired
    public PageApi(PageService pageService) {
        this.pageService = pageService;
    }

    @RequestMapping(value={"{pageId}"}, method={RequestMethod.DELETE})
    public void deletePage(@PathVariable long pageId, HttpServletResponse response) {
        this.logger.debug("DELETE received for /api/rest/page/" + pageId);
        this.pageService.deletePage(pageId);
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }

    @ResponseBody
    @RequestMapping(value={"{pageId}"}, method={RequestMethod.GET})
    public Page getPage(@PathVariable long pageId, @RequestParam(required=false) boolean export) {
        this.logger.debug("GET received for /api/rest/page/" + pageId);
        Page page = this.pageService.getPage(pageId);
        if (export) {
            PageApi.modifyForExport(page);
        }
        return page;
    }

    private static void modifyForExport(Page page) {
        page.setOwner(null);
        for (Region r : page.getRegions()) {
            PageApi.modifyForExport(r);
        }
    }

    private static void modifyForExport(Region r) {
        for (RegionWidget w : r.getRegionWidgets()) {
            w.setPreferences(null);
        }
    }
}

