/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.web.api.rest;

import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.rave.portal.model.Person;
import org.apache.rave.portal.model.Tag;
import org.apache.rave.portal.model.WidgetComment;
import org.apache.rave.portal.model.WidgetRating;
import org.apache.rave.portal.model.WidgetTag;
import org.apache.rave.portal.service.TagService;
import org.apache.rave.portal.service.UserService;
import org.apache.rave.portal.service.WidgetCommentService;
import org.apache.rave.portal.service.WidgetRatingService;
import org.apache.rave.portal.service.WidgetTagService;
import org.apache.rave.portal.web.api.rest.AbstractRestApi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/rest/widgets"})
public class WidgetApi
extends AbstractRestApi {
    private static Logger logger = LoggerFactory.getLogger(WidgetApi.class);
    private final WidgetCommentService widgetCommentService;
    private final WidgetRatingService widgetRatingService;
    private final UserService userService;
    private final TagService tagService;
    private final WidgetTagService widgetTagService;

    @Autowired
    public WidgetApi(WidgetRatingService widgetRatingService, WidgetCommentService widgetCommentService, UserService userService, TagService tagService, WidgetTagService widgetTagService) {
        this.widgetCommentService = widgetCommentService;
        this.widgetRatingService = widgetRatingService;
        this.userService = userService;
        this.tagService = tagService;
        this.widgetTagService = widgetTagService;
    }

    @RequestMapping(method={RequestMethod.GET})
    public void getAllWidgets() {
        logger.debug("GET received for all widgets");
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/{widgetId}/comments"})
    public void createWidgetComment(@PathVariable long widgetId, @RequestParam String text, HttpServletResponse response) {
        WidgetComment widgetComment = new WidgetComment();
        widgetComment.setWidgetId(Long.valueOf(widgetId));
        widgetComment.setUser(this.userService.getAuthenticatedUser());
        widgetComment.setText(text);
        widgetComment.setCreatedDate(new Date());
        widgetComment.setLastModifiedDate(new Date());
        this.widgetCommentService.saveWidgetComment(widgetComment);
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{widgetId}/comments/{widgetCommentId}"})
    public WidgetComment getWidgetComment(@PathVariable long widgetId, @PathVariable long widgetCommentId) {
        return this.widgetCommentService.getWidgetComment(Long.valueOf(widgetCommentId));
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/{widgetId}/comments/{widgetCommentId}"})
    public void updateWidgetComment(@PathVariable long widgetId, @PathVariable long widgetCommentId, @RequestParam String text, HttpServletResponse response) {
        WidgetComment widgetComment = this.widgetCommentService.getWidgetComment(Long.valueOf(widgetCommentId));
        if (widgetComment == null) {
            widgetComment = new WidgetComment();
            widgetComment.setWidgetId(Long.valueOf(widgetId));
            widgetComment.setUser(this.userService.getAuthenticatedUser());
            widgetComment.setCreatedDate(new Date());
            widgetComment.setLastModifiedDate(new Date());
        }
        widgetComment.setText(text);
        this.widgetCommentService.saveWidgetComment(widgetComment);
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/{widgetId}/comments/{widgetCommentId}"})
    public void deleteWidgetComment(@PathVariable long widgetId, @PathVariable long widgetCommentId, HttpServletResponse response) {
        this.widgetCommentService.removeWidgetComment(Long.valueOf(widgetCommentId));
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }

    @RequestMapping(value={"/{widgetId}/rating"}, method={RequestMethod.DELETE})
    public void deleteWidgetRating(@PathVariable long widgetId, HttpServletResponse response) {
        logger.debug("DELETE WidgetRating received for /api/rest/widgets/{}", (Object)widgetId);
        this.widgetRatingService.removeWidgetRating(Long.valueOf(widgetId), this.userService.getAuthenticatedUser().getEntityId());
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }

    @RequestMapping(value={"/{widgetId}/rating"}, method={RequestMethod.POST})
    public void setWidgetRating(@PathVariable long widgetId, @RequestParam(value="score") Integer score, HttpServletResponse response) {
        logger.debug("POST WidgetRating received for /api/rest/widgets/{} score: {}", (Object)widgetId, (Object)score);
        WidgetRating widgetRating = new WidgetRating();
        widgetRating.setScore(score);
        widgetRating.setUserId(this.userService.getAuthenticatedUser().getEntityId());
        widgetRating.setWidgetId(Long.valueOf(widgetId));
        this.widgetRatingService.saveWidgetRating(widgetRating);
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, value={"/{widgetId}/users"})
    public List<Person> getAllUsers(@PathVariable long widgetId) {
        return this.userService.getAllByAddedWidget(widgetId);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/{widgetId}/tags"})
    public void createWidgetTag(@PathVariable long widgetId, @RequestParam String tagText, HttpServletResponse response) {
        WidgetTag existed;
        logger.debug("add tags " + tagText + " to widget " + widgetId);
        if (tagText != null && !tagText.trim().isEmpty() && (existed = this.widgetTagService.getWidgetTagByWidgetIdAndKeyword(Long.valueOf(widgetId), tagText)) == null) {
            WidgetTag widgetTag = new WidgetTag();
            widgetTag.setWidgetId(Long.valueOf(widgetId));
            widgetTag.setUser(this.userService.getAuthenticatedUser());
            widgetTag.setCreatedDate(new Date());
            widgetTag.setTag(this.getTag(tagText));
            this.widgetTagService.saveWidgetTag(widgetTag);
            logger.debug("widget tag is saved.");
        }
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, value={"/{widgetId}/tags"})
    public List<Tag> getTags(@PathVariable long widgetId) {
        return this.tagService.getAvailableTagsByWidgetId(Long.valueOf(widgetId));
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, value={"/tags"})
    public List<Tag> getAllTags() {
        return this.tagService.getAllTags();
    }

    private Tag getTag(String keyword) {
        Tag tag = this.tagService.getTagByKeyword(keyword);
        if (tag == null) {
            tag = new Tag();
            tag.setKeyword(keyword);
        }
        return tag;
    }
}

