/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.web.controller;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringEscapeUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.i18n.AcceptHeaderLocaleResolver;

@Controller
@RequestMapping(value={"/messagebundle/*"})
public class MessageBundleController {
    private static final String CLIENT_MESSAGE_IDENTIFIER = "_rave_client.";
    private static final String CLIENT_MESSAGES_BUNDLE_NAME = "messages";
    private static final String JAVASCRIPT_CONTENT_TYPE = "text/javascript";
    private static final Integer CLIENT_MESSAGE_BUNDLE_CACHE_CONTROL_MAX_AGE = 86400;
    private Map<Locale, String> clientMessagesCache = new HashMap<Locale, String>();
    private AcceptHeaderLocaleResolver acceptHeaderLocaleResolver = new AcceptHeaderLocaleResolver();
    private HttpHeaders clientMessagesResponseHeaders = new HttpHeaders();

    public MessageBundleController() {
        this.clientMessagesResponseHeaders.setCacheControl("max-age=" + CLIENT_MESSAGE_BUNDLE_CACHE_CONTROL_MAX_AGE);
        this.clientMessagesResponseHeaders.setContentType(MediaType.parseMediaType((String)JAVASCRIPT_CONTENT_TYPE));
        Locale.setDefault(Locale.ENGLISH);
    }

    @RequestMapping(value={"/rave_client_messages.js"}, method={RequestMethod.GET})
    public ResponseEntity<String> getClientMessages(HttpServletRequest request) {
        return new ResponseEntity((Object)this.getClientMessagesJSForLocale(this.acceptHeaderLocaleResolver.resolveLocale(request)), (MultiValueMap)this.clientMessagesResponseHeaders, HttpStatus.OK);
    }

    private Map<String, String> convertResourceBundleToClientMessagesMap(ResourceBundle resourceBundle) {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration<String> keys = resourceBundle.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (!key.startsWith(CLIENT_MESSAGE_IDENTIFIER)) continue;
            map.put(key.replaceFirst(CLIENT_MESSAGE_IDENTIFIER, ""), StringEscapeUtils.escapeJavaScript((String)resourceBundle.getString(key)));
        }
        return map;
    }

    private String convertClientMessagesMapToJavaScriptOutput(Map<String, String> clientMessagesMap) {
        StringBuilder sb = new StringBuilder();
        String add_client_message = "rave.addClientMessage(\"";
        String key_value_separator = "\",\"";
        String message_suffix = "\");";
        for (Map.Entry<String, String> mapEntry : clientMessagesMap.entrySet()) {
            sb.append("rave.addClientMessage(\"").append(mapEntry.getKey()).append("\",\"");
            sb.append(mapEntry.getValue()).append("\");");
        }
        return sb.toString();
    }

    private String getClientMessagesJSForLocale(Locale locale) {
        String javascriptOutput = this.getClientMessagesJSFromCache(locale);
        if (javascriptOutput == null) {
            javascriptOutput = this.getClientMessagesJSFromBundle(locale);
        }
        return javascriptOutput;
    }

    private String getClientMessagesJSFromCache(Locale locale) {
        return this.clientMessagesCache.get(locale);
    }

    private String getClientMessagesJSFromBundle(Locale locale) {
        String javascriptOutput = this.convertClientMessagesMapToJavaScriptOutput(this.convertResourceBundleToClientMessagesMap(ResourceBundle.getBundle(CLIENT_MESSAGES_BUNDLE_NAME, locale)));
        this.cacheClientMessages(locale, javascriptOutput);
        return javascriptOutput;
    }

    private void cacheClientMessages(Locale locale, String javascriptOutput) {
        this.clientMessagesCache.put(locale, javascriptOutput);
    }
}

