/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.web.validator;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.EmailValidator;
import org.apache.rave.portal.model.User;
import org.apache.rave.portal.service.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.ObjectError;
import org.springframework.validation.Validator;

@Component
public class UserProfileValidator
implements Validator {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private UserService userService;
    private static final String FIELD_EMAIL = "email";

    @Autowired
    public UserProfileValidator(UserService userService) {
        this.userService = userService;
    }

    public boolean supports(Class<?> aClass) {
        return User.class.isAssignableFrom(aClass);
    }

    public void validate(Object obj, Errors errors) {
        this.logger.debug("Validator called");
        User user = (User)obj;
        if (StringUtils.isBlank((String)user.getPassword())) {
            errors.rejectValue("password", "password.required");
            this.logger.info("Password required");
        } else if (user.getPassword().length() < 4) {
            errors.rejectValue("password", "password.invalid.length");
            this.logger.info("Password must be at least 4 characters long");
        }
        if (StringUtils.isBlank((String)user.getConfirmPassword())) {
            errors.rejectValue("confirmPassword", "confirmPassword.required");
            this.logger.info("Confirm Password required");
        }
        if (user.getConfirmPassword() != null && !user.getConfirmPassword().equals(user.getPassword())) {
            errors.rejectValue("confirmPassword", "confirmPassword.mismatch");
            this.logger.info("Password mismatch");
        }
        this.validateEmail(errors, user);
        this.writeResultToLog(errors);
    }

    private void validateEmail(Errors errors, User user) {
        String email = user.getEmail();
        if (StringUtils.isBlank((String)email)) {
            errors.rejectValue(FIELD_EMAIL, "email.required");
        } else if (this.isInvalidEmailAddress(email)) {
            errors.rejectValue(FIELD_EMAIL, "email.invalid");
        } else if (this.isExistingEmailAddress(user, email)) {
            errors.rejectValue(FIELD_EMAIL, "email.exists");
        }
    }

    private boolean isInvalidEmailAddress(String emailAddress) {
        return !EmailValidator.getInstance().isValid(emailAddress);
    }

    private boolean isExistingEmailAddress(User user, String email) {
        User userByEmail = this.userService.getUserByEmail(email);
        return userByEmail != null && !userByEmail.equals((Object)user);
    }

    private void writeResultToLog(Errors errors) {
        if (errors.hasErrors()) {
            if (this.logger.isInfoEnabled()) {
                for (ObjectError error : errors.getAllErrors()) {
                    this.logger.info("Validation error: {}", (Object)error.toString());
                }
            }
        } else {
            this.logger.debug("Validation successful");
        }
    }
}

