/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.job.yarn;

import java.util.ArrayList;
import java.util.List;
import org.apache.samza.config.Config;

public class FileSystemImplConfig {
    private static final String FS_IMPL_PREFIX = "fs.";
    private static final String FS_IMPL_SUFFIX = ".impl";
    private static final String FS_IMPL_TEMPLATE = "fs.%s.impl";
    private final Config config;

    public FileSystemImplConfig(Config config) {
        if (null == config) {
            throw new IllegalArgumentException("config cannot be null");
        }
        this.config = config;
    }

    public List<String> getSchemes() {
        Config subConfig = this.config.subset(FS_IMPL_PREFIX, true);
        ArrayList<String> schemes = new ArrayList<String>();
        for (String key : subConfig.keySet()) {
            if (!key.endsWith(FS_IMPL_SUFFIX)) continue;
            schemes.add(key.substring(0, key.length() - FS_IMPL_SUFFIX.length()));
        }
        return schemes;
    }

    public Config getSchemeConfig(String scheme) {
        String fsSchemeImpl = String.format(FS_IMPL_TEMPLATE, scheme);
        Config schemeConfig = this.config.subset(fsSchemeImpl, false);
        return schemeConfig;
    }
}

