/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.job.yarn;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.Records;
import org.apache.samza.job.yarn.LocalizerResourceConfig;
import org.apache.samza.job.yarn.LocalizerResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalizerResourceMapper {
    private static final Logger log = LoggerFactory.getLogger(LocalizerResourceMapper.class);
    private final YarnConfiguration yarnConfiguration;
    private final LocalizerResourceConfig resourceConfig;
    private final Map<String, LocalResource> localResourceMap;

    public LocalizerResourceMapper(LocalizerResourceConfig resourceConfig, YarnConfiguration yarnConfiguration) {
        this.yarnConfiguration = yarnConfiguration;
        this.resourceConfig = resourceConfig;
        this.localResourceMap = this.buildResourceMapping();
    }

    private Map<String, LocalResource> buildResourceMapping() {
        ImmutableMap.Builder localResourceMapBuilder = ImmutableMap.builder();
        List<String> resourceNames = this.resourceConfig.getResourceNames();
        for (String resourceName : resourceNames) {
            String resourceLocalName = this.resourceConfig.getResourceLocalName(resourceName);
            LocalResourceType resourceType = this.resourceConfig.getResourceLocalType(resourceName);
            LocalResourceVisibility resourceVisibility = this.resourceConfig.getResourceLocalVisibility(resourceName);
            Path resourcePath = this.resourceConfig.getResourcePath(resourceName);
            LocalResource localResource = this.createLocalResource(resourcePath, resourceType, resourceVisibility);
            localResourceMapBuilder.put((Object)resourceLocalName, (Object)localResource);
            log.info("preparing local resource: {}", (Object)resourceLocalName);
        }
        return localResourceMapBuilder.build();
    }

    private LocalResource createLocalResource(Path resourcePath, LocalResourceType resourceType, LocalResourceVisibility resourceVisibility) {
        LocalResource localResource = (LocalResource)Records.newRecord(LocalResource.class);
        URL resourceUrl = ConverterUtils.getYarnUrlFromPath((Path)resourcePath);
        try {
            FileStatus resourceFileStatus = resourcePath.getFileSystem((Configuration)this.yarnConfiguration).getFileStatus(resourcePath);
            if (null == resourceFileStatus) {
                throw new LocalizerResourceException("Check getFileStatus implementation. getFileStatus gets unexpected null for resourcePath " + resourcePath);
            }
            localResource.setResource(resourceUrl);
            log.info("setLocalizerResource for {}", (Object)resourceUrl);
            localResource.setSize(resourceFileStatus.getLen());
            localResource.setTimestamp(resourceFileStatus.getModificationTime());
            localResource.setType(resourceType);
            localResource.setVisibility(resourceVisibility);
            return localResource;
        }
        catch (IOException ioe) {
            log.error("IO Exception when accessing the resource file status from the filesystem: " + resourcePath, (Throwable)ioe);
            throw new LocalizerResourceException("IO Exception when accessing the resource file status from the filesystem: " + resourcePath);
        }
    }

    public Map<String, LocalResource> getResourceMap() {
        return ImmutableMap.copyOf(this.localResourceMap);
    }
}

