/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.job.yarn;

import java.io.DataInputStream;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.samza.config.Config;
import org.apache.samza.config.YarnConfig;
import org.apache.samza.container.SecurityManager;
import org.apache.samza.job.yarn.SamzaContainerSecurityManager$;
import org.apache.samza.util.DaemonThreadFactory;
import org.apache.samza.util.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005mq!B\u0001\u0003\u0011\u0003i\u0011!H*b[j\f7i\u001c8uC&tWM]*fGV\u0014\u0018\u000e^=NC:\fw-\u001a:\u000b\u0005\r!\u0011\u0001B=be:T!!\u0002\u0004\u0002\u0007)|'M\u0003\u0002\b\u0011\u0005)1/Y7{C*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0001\"AD\b\u000e\u0003\t1Q\u0001\u0005\u0002\t\u0002E\u0011QdU1nu\u0006\u001cuN\u001c;bS:,'oU3dkJLG/_'b]\u0006<WM]\n\u0003\u001fI\u0001\"a\u0005\f\u000e\u0003QQ\u0011!F\u0001\u0006g\u000e\fG.Y\u0005\u0003/Q\u0011a!\u00118z%\u00164\u0007\"B\r\u0010\t\u0003Q\u0012A\u0002\u001fj]&$h\bF\u0001\u000e\u0011\u001darB1A\u0005\u0002u\ta\u0004V(L\u000b:{&+\u0012(F/~#\u0006JU#B\t~s\u0015)T#`!J+e)\u0013-\u0016\u0003y\u0001\"a\b\u0013\u000e\u0003\u0001R!!\t\u0012\u0002\t1\fgn\u001a\u0006\u0002G\u0005!!.\u0019<b\u0013\t)\u0003E\u0001\u0004TiJLgn\u001a\u0005\u0007O=\u0001\u000b\u0011\u0002\u0010\u0002?Q{5*\u0012(`%\u0016sUiV0U\u0011J+\u0015\tR0O\u00036+u\f\u0015*F\r&C\u0006\u0005C\u0004*\u001f\t\u0007I\u0011\u0001\u0016\u00021%s\u0015\nV%B\u0019~#U\tT!Z?&sulU#D\u001f:#5+F\u0001,!\t\u0019B&\u0003\u0002.)\t\u0019\u0011J\u001c;\t\r=z\u0001\u0015!\u0003,\u0003eIe*\u0013+J\u00032{F)\u0012'B3~KejX*F\u0007>sEi\u0015\u0011\u0007\tA\u0011\u0001!M\n\u0005aI*4\b\u0005\u0002 g%\u0011A\u0007\t\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005YJT\"A\u001c\u000b\u0005a2\u0011!C2p]R\f\u0017N\\3s\u0013\tQtGA\bTK\u000e,(/\u001b;z\u001b\u0006t\u0017mZ3s!\tat(D\u0001>\u0015\tqd!\u0001\u0003vi&d\u0017B\u0001!>\u0005\u001daunZ4j]\u001eD\u0001B\u0011\u0019\u0003\u0002\u0003\u0006IaQ\u0001\u0007G>tg-[4\u0011\u0005\u00113U\"A#\u000b\u0005\t3\u0011BA$F\u0005\u0019\u0019uN\u001c4jO\"A\u0011\n\rB\u0001B\u0003%!*\u0001\u0007iC\u0012|w\u000e]\"p]\u001aLw\r\u0005\u0002L!6\tAJ\u0003\u0002N\u001d\u0006!1m\u001c8g\u0015\ty\u0005\"\u0001\u0004iC\u0012|w\u000e]\u0005\u0003#2\u0013QbQ8oM&<WO]1uS>t\u0007\"B\r1\t\u0003\u0019Fc\u0001+V-B\u0011a\u0002\r\u0005\u0006\u0005J\u0003\ra\u0011\u0005\u0006\u0013J\u0003\rA\u0013\u0005\b1B\u0012\r\u0011\"\u0003Z\u0003I!xn[3o%\u0016tWm^#yK\u000e,Ho\u001c:\u0016\u0003i\u0003\"aW0\u000e\u0003qS!!\u00180\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002?E%\u0011\u0001\r\u0018\u0002\u0019'\u000eDW\rZ;mK\u0012,\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0007B\u000221A\u0003%!,A\nu_.,gNU3oK^,\u00050Z2vi>\u0014\b\u0005C\u0004ea\u0001\u0007I\u0011B3\u0002)1\f7\u000f\u001e*fMJ,7\u000f\u001b+j[\u0016\u001cH/Y7q+\u00051\u0007CA\nh\u0013\tAGC\u0001\u0003M_:<\u0007b\u000261\u0001\u0004%Ia[\u0001\u0019Y\u0006\u001cHOU3ge\u0016\u001c\b\u000eV5nKN$\u0018-\u001c9`I\u0015\fHC\u00017p!\t\u0019R.\u0003\u0002o)\t!QK\\5u\u0011\u001d\u0001\u0018.!AA\u0002\u0019\f1\u0001\u001f\u00132\u0011\u0019\u0011\b\u0007)Q\u0005M\u0006)B.Y:u%\u00164'/Z:i)&lWm\u001d;b[B\u0004\u0003\"\u0002;1\t\u0003)\u0018!B:uCJ$H#\u00017\t\u000b]\u0004D\u0011\u0002=\u0002-\u001d,Go\u0011:fI\u0016tG/[1mg\u001a\u0013x.\u001c%E\rN#B!_@\u0002\u000eA\u0011!0`\u0007\u0002w*\u0011APT\u0001\tg\u0016\u001cWO]5us&\u0011ap\u001f\u0002\f\u0007J,G-\u001a8uS\u0006d7\u000fC\u0004\u0002\u0002Y\u0004\r!a\u0001\u0002\u0005\u0019\u001c\b\u0003BA\u0003\u0003\u0013i!!a\u0002\u000b\u0007\u0005\u0005a*\u0003\u0003\u0002\f\u0005\u001d!A\u0003$jY\u0016\u001c\u0016p\u001d;f[\"9\u0011q\u0002<A\u0002\u0005E\u0011!\u0003;pW\u0016t\u0007+\u0019;i!\u0011\t)!a\u0005\n\t\u0005U\u0011q\u0001\u0002\u0005!\u0006$\b\u000e\u0003\u0004\u0002\u001aA\"\t!^\u0001\u0005gR|\u0007\u000f")
public class SamzaContainerSecurityManager
implements SecurityManager,
Logging {
    private final Config config;
    public final Configuration org$apache$samza$job$yarn$SamzaContainerSecurityManager$$hadoopConfig;
    private final ScheduledExecutorService org$apache$samza$job$yarn$SamzaContainerSecurityManager$$tokenRenewExecutor;
    private long org$apache$samza$job$yarn$SamzaContainerSecurityManager$$lastRefreshTimestamp;
    private final String loggerName;
    private final Logger logger;
    private final String startupLoggerName;
    private final Logger startupLogger;
    private volatile byte bitmap$0;

    public static int INITIAL_DELAY_IN_SECONDS() {
        return SamzaContainerSecurityManager$.MODULE$.INITIAL_DELAY_IN_SECONDS();
    }

    public static String TOKEN_RENEW_THREAD_NAME_PREFIX() {
        return SamzaContainerSecurityManager$.MODULE$.TOKEN_RENEW_THREAD_NAME_PREFIX();
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        SamzaContainerSecurityManager samzaContainerSecurityManager = this;
        synchronized (samzaContainerSecurityManager) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.logger$lzycompute() : this.logger;
    }

    public String startupLoggerName() {
        return this.startupLoggerName;
    }

    private Logger startupLogger$lzycompute() {
        SamzaContainerSecurityManager samzaContainerSecurityManager = this;
        synchronized (samzaContainerSecurityManager) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.startupLogger = Logging.class.startupLogger((Logging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.startupLogger;
        }
    }

    public Logger startupLogger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.startupLogger$lzycompute() : this.startupLogger;
    }

    public void org$apache$samza$util$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void org$apache$samza$util$Logging$_setter_$startupLoggerName_$eq(String x$1) {
        this.startupLoggerName = x$1;
    }

    public void startupLog(Function0<Object> message) {
        Logging.class.startupLog((Logging)this, message);
    }

    public void trace(Function0<Object> message) {
        Logging.class.trace((Logging)this, message);
    }

    public void trace(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, message, e);
    }

    public void debug(Function0<Object> message) {
        Logging.class.debug((Logging)this, message);
    }

    public void debug(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, message, e);
    }

    public void info(Function0<Object> message) {
        Logging.class.info((Logging)this, message);
    }

    public void info(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.info((Logging)this, message, e);
    }

    public void warn(Function0<Object> message) {
        Logging.class.warn((Logging)this, message);
    }

    public void warn(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, message, e);
    }

    public void error(Function0<Object> message) {
        Logging.class.error((Logging)this, message);
    }

    public void error(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.error((Logging)this, message, e);
    }

    public void putMDC(Function0<String> key, Function0<String> value) {
        Logging.class.putMDC((Logging)this, key, value);
    }

    public String getMDC(Function0<String> key) {
        return Logging.class.getMDC((Logging)this, key);
    }

    public void removeMDC(Function0<String> key) {
        Logging.class.removeMDC((Logging)this, key);
    }

    public void clearMDC() {
        Logging.class.clearMDC((Logging)this);
    }

    public ScheduledExecutorService org$apache$samza$job$yarn$SamzaContainerSecurityManager$$tokenRenewExecutor() {
        return this.org$apache$samza$job$yarn$SamzaContainerSecurityManager$$tokenRenewExecutor;
    }

    public long org$apache$samza$job$yarn$SamzaContainerSecurityManager$$lastRefreshTimestamp() {
        return this.org$apache$samza$job$yarn$SamzaContainerSecurityManager$$lastRefreshTimestamp;
    }

    public void org$apache$samza$job$yarn$SamzaContainerSecurityManager$$lastRefreshTimestamp_$eq(long x$1) {
        this.org$apache$samza$job$yarn$SamzaContainerSecurityManager$$lastRefreshTimestamp = x$1;
    }

    public void start() {
        YarnConfig yarnConfig = new YarnConfig(this.config);
        long renewalInterval = yarnConfig.getYarnTokenRenewalIntervalSeconds();
        Path tokenFilePath = new Path(yarnConfig.getYarnCredentialsFile());
        Runnable tokenRenewRunnable = new Runnable(this, renewalInterval, tokenFilePath){
            private final /* synthetic */ SamzaContainerSecurityManager $outer;
            public final long renewalInterval$1;
            private final Path tokenFilePath$1;

            public void run() {
                try {
                    FileSystem fs = FileSystem.get((Configuration)this.$outer.org$apache$samza$job$yarn$SamzaContainerSecurityManager$$hadoopConfig);
                    if (fs.exists(this.tokenFilePath$1)) {
                        FileStatus fileStatus = fs.getFileStatus(this.tokenFilePath$1);
                        if (this.$outer.org$apache$samza$job$yarn$SamzaContainerSecurityManager$$lastRefreshTimestamp() > fileStatus.getModificationTime()) {
                            this.$outer.info((Function0<Object>)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "Expecting to update delegation tokens, but AM has not updated credentials file yet, will retry in 5 minutes";
                                }
                            });
                            this.$outer.org$apache$samza$job$yarn$SamzaContainerSecurityManager$$tokenRenewExecutor().schedule(this, 5L, TimeUnit.MINUTES);
                        } else {
                            Credentials credentials = this.$outer.org$apache$samza$job$yarn$SamzaContainerSecurityManager$$getCredentialsFromHDFS(fs, this.tokenFilePath$1);
                            UserGroupInformation.getCurrentUser().addCredentials(credentials);
                            this.$outer.info((Function0<Object>)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "Successfully renewed tokens from credentials file";
                                }
                            });
                            this.$outer.org$apache$samza$job$yarn$SamzaContainerSecurityManager$$lastRefreshTimestamp_$eq(System.currentTimeMillis());
                            this.$outer.info((Function0<Object>)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anon$1 $outer;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Schedule the next fetch in ", " seconds"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.renewalInterval$1)}));
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                            this.$outer.org$apache$samza$job$yarn$SamzaContainerSecurityManager$$tokenRenewExecutor().schedule(this, this.renewalInterval$1, TimeUnit.SECONDS);
                        }
                    } else {
                        this.$outer.info((Function0<Object>)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anon$1 $outer;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Credentials file not found yet. Schedule the next fetch in ", " seconds"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.renewalInterval$1)}));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                        this.$outer.org$apache$samza$job$yarn$SamzaContainerSecurityManager$$tokenRenewExecutor().schedule(this, this.renewalInterval$1, TimeUnit.SECONDS);
                    }
                }
                catch (Exception exception) {
                    long retrySeconds = Math.min(this.renewalInterval$1, 3600L);
                    this.$outer.warn((Function0<Object>)new Serializable(this, retrySeconds){
                        public static final long serialVersionUID = 0L;
                        private final long retrySeconds$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to renew tokens, will retry in ", " seconds"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.retrySeconds$1)}));
                        }
                        {
                            this.retrySeconds$1 = retrySeconds$1;
                        }
                    }, (Function0<Throwable>)new Serializable(this, exception){
                        public static final long serialVersionUID = 0L;
                        private final Exception e$1;

                        public final Exception apply() {
                            return this.e$1;
                        }
                        {
                            this.e$1 = e$1;
                        }
                    });
                    this.$outer.org$apache$samza$job$yarn$SamzaContainerSecurityManager$$tokenRenewExecutor().schedule(this, retrySeconds, TimeUnit.SECONDS);
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.renewalInterval$1 = renewalInterval$1;
                this.tokenFilePath$1 = tokenFilePath$1;
            }
        };
        this.info((Function0<Object>)new Serializable(this, renewalInterval){
            public static final long serialVersionUID = 0L;
            private final long renewalInterval$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Schedule the next fetch in ", " seconds"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(this.renewalInterval$1 + (long)SamzaContainerSecurityManager$.MODULE$.INITIAL_DELAY_IN_SECONDS()))}));
            }
            {
                this.renewalInterval$1 = renewalInterval$1;
            }
        });
        this.org$apache$samza$job$yarn$SamzaContainerSecurityManager$$tokenRenewExecutor().schedule(tokenRenewRunnable, renewalInterval + (long)SamzaContainerSecurityManager$.MODULE$.INITIAL_DELAY_IN_SECONDS(), TimeUnit.SECONDS);
    }

    /*
     * WARNING - void declaration
     */
    public Credentials org$apache$samza$job$yarn$SamzaContainerSecurityManager$$getCredentialsFromHDFS(FileSystem fs, Path tokenPath) {
        Credentials credentials;
        FSDataInputStream stream = fs.open(tokenPath);
        try {
            Credentials newCredentials = new Credentials();
            newCredentials.readTokenStorageStream((DataInputStream)stream);
            credentials = newCredentials;
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.close();
            throw throwable;
        }
        stream.close();
        return credentials;
    }

    public void stop() {
        this.org$apache$samza$job$yarn$SamzaContainerSecurityManager$$tokenRenewExecutor().shutdown();
    }

    public SamzaContainerSecurityManager(Config config, Configuration hadoopConfig) {
        this.config = config;
        this.org$apache$samza$job$yarn$SamzaContainerSecurityManager$$hadoopConfig = hadoopConfig;
        Logging.class.$init$((Logging)this);
        this.org$apache$samza$job$yarn$SamzaContainerSecurityManager$$tokenRenewExecutor = Executors.newScheduledThreadPool(1, (ThreadFactory)new DaemonThreadFactory(SamzaContainerSecurityManager$.MODULE$.TOKEN_RENEW_THREAD_NAME_PREFIX()));
        this.org$apache$samza$job$yarn$SamzaContainerSecurityManager$$lastRefreshTimestamp = 0L;
    }
}

