/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.job.yarn;

import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.client.api.async.AMRMClientAsync;
import org.apache.samza.SamzaException;
import org.apache.samza.clustermanager.SamzaApplicationState;
import org.apache.samza.job.yarn.SamzaYarnAppMasterService;
import org.apache.samza.job.yarn.YarnAppState;
import org.apache.samza.util.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=c\u0001B\u0001\u0003\u00015\u00111dU1nu\u0006L\u0016M\u001d8BaBl\u0015m\u001d;fe2Kg-Z2zG2,'BA\u0002\u0005\u0003\u0011I\u0018M\u001d8\u000b\u0005\u00151\u0011a\u00016pE*\u0011q\u0001C\u0001\u0006g\u0006l'0\u0019\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001qA\u0003\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\t\u0003+ai\u0011A\u0006\u0006\u0003/\u0019\tA!\u001e;jY&\u0011\u0011D\u0006\u0002\b\u0019><w-\u001b8h\u0011!Y\u0002A!A!\u0002\u0013a\u0012\u0001D2p]R\f\u0017N\\3s\u001b\u0016l\u0007CA\b\u001e\u0013\tq\u0002CA\u0002J]RD\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006I\u0001H\u0001\rG>tG/Y5oKJ\u001c\u0005/\u001e\u0005\tE\u0001\u0011\t\u0011)A\u0005G\u0005i1/Y7{C\u0006\u0003\bo\u0015;bi\u0016\u0004\"\u0001J\u0014\u000e\u0003\u0015R!A\n\u0004\u0002\u001d\rdWo\u001d;fe6\fg.Y4fe&\u0011\u0001&\n\u0002\u0016'\u0006l'0Y!qa2L7-\u0019;j_:\u001cF/\u0019;f\u0011!Q\u0003A!A!\u0002\u0013Y\u0013!B:uCR,\u0007C\u0001\u0017.\u001b\u0005\u0011\u0011B\u0001\u0018\u0003\u00051I\u0016M\u001d8BaB\u001cF/\u0019;f\u0011!\u0001\u0004A!A!\u0002\u0013\t\u0014\u0001C1n\u00072LWM\u001c;\u0011\u0007Ibd(D\u00014\u0015\t!T'A\u0003bgft7M\u0003\u00027o\u0005\u0019\u0011\r]5\u000b\u0005aJ\u0014AB2mS\u0016tGO\u0003\u0002\u0004u)\u00111\bC\u0001\u0007Q\u0006$wn\u001c9\n\u0005u\u001a$aD!N%6\u001bE.[3oi\u0006\u001b\u0018P\\2\u0011\u0005}\nfB\u0001!P\u001d\t\teJ\u0004\u0002C\u001b:\u00111\t\u0014\b\u0003\t.s!!\u0012&\u000f\u0005\u0019KU\"A$\u000b\u0005!c\u0011A\u0002\u001fs_>$h(C\u0001\f\u0013\tI!\"\u0003\u0002<\u0011%\u00111AO\u0005\u0003qeJ!AN\u001c\n\u0005A+\u0014AC!N%6\u001bE.[3oi&\u0011!k\u0015\u0002\u0011\u0007>tG/Y5oKJ\u0014V-];fgRT!\u0001U\u001b\t\u000bU\u0003A\u0011\u0001,\u0002\rqJg.\u001b;?)\u00199\u0006,\u0017.\\9B\u0011A\u0006\u0001\u0005\u00067Q\u0003\r\u0001\b\u0005\u0006AQ\u0003\r\u0001\b\u0005\u0006EQ\u0003\ra\t\u0005\u0006UQ\u0003\ra\u000b\u0005\u0006aQ\u0003\r!\r\u0005\b=\u0002\u0001\r\u0011\"\u0001`\u0003Q1\u0018\r\\5e%\u0016\u001cx.\u001e:dKJ+\u0017/^3tiV\t\u0001\r\u0005\u0002\u0010C&\u0011!\r\u0005\u0002\b\u0005>|G.Z1o\u0011\u001d!\u0007\u00011A\u0005\u0002\u0015\f\u0001D^1mS\u0012\u0014Vm]8ve\u000e,'+Z9vKN$x\fJ3r)\t1\u0017\u000e\u0005\u0002\u0010O&\u0011\u0001\u000e\u0005\u0002\u0005+:LG\u000fC\u0004kG\u0006\u0005\t\u0019\u00011\u0002\u0007a$\u0013\u0007\u0003\u0004m\u0001\u0001\u0006K\u0001Y\u0001\u0016m\u0006d\u0017\u000e\u001a*fg>,(oY3SKF,Xm\u001d;!\u0011\u001dq\u0007\u00011A\u0005\u0002=\fqb\u001d5vi\u0012|wO\\'fgN\fw-Z\u000b\u0002aB\u0011\u0011\u000f\u001e\b\u0003\u001fIL!a\u001d\t\u0002\rA\u0013X\rZ3g\u0013\t)hO\u0001\u0004TiJLgn\u001a\u0006\u0003gBAq\u0001\u001f\u0001A\u0002\u0013\u0005\u00110A\ntQV$Hm\\<o\u001b\u0016\u001c8/Y4f?\u0012*\u0017\u000f\u0006\u0002gu\"9!n^A\u0001\u0002\u0004\u0001\bB\u0002?\u0001A\u0003&\u0001/\u0001\ttQV$Hm\\<o\u001b\u0016\u001c8/Y4fA!9a\u0010\u0001a\u0001\n\u0003y\u0018AB<fE\u0006\u0003\b/\u0006\u0002\u0002\u0002A\u0019A&a\u0001\n\u0007\u0005\u0015!AA\rTC6T\u0018-W1s]\u0006\u0003\b/T1ti\u0016\u00148+\u001a:wS\u000e,\u0007\"CA\u0005\u0001\u0001\u0007I\u0011AA\u0006\u0003)9XMY!qa~#S-\u001d\u000b\u0004M\u00065\u0001\"\u00036\u0002\b\u0005\u0005\t\u0019AA\u0001\u0011!\t\t\u0002\u0001Q!\n\u0005\u0005\u0011aB<fE\u0006\u0003\b\u000f\t\u0005\b\u0003+\u0001A\u0011AA\f\u0003\u0019yg.\u00138jiR\ta\rC\u0004\u0002\u001c\u0001!\t!a\u0006\u0002\u0011=t'+\u001a2p_RDq!a\b\u0001\t\u0003\t\t#\u0001\u0006p]NCW\u000f\u001e3po:$2AZA\u0012\u0011!\t)#!\bA\u0002\u0005\u001d\u0012AD:b[j\f\u0017\t\u001d9Ti\u0006$Xo\u001d\t\u0005\u0003S\tyCD\u0002%\u0003WI1!!\f&\u0003U\u0019\u0016-\u001c>b\u0003B\u0004H.[2bi&|gn\u0015;bi\u0016LA!!\r\u00024\tq1+Y7{C\u0006\u0003\bo\u0015;biV\u001c(bAA\u0017K!9\u0011q\u0007\u0001\u0005\u0002\u0005e\u0012!C4fiN#\u0018\r^;t)\u0011\tY$!\u0013\u0011\t\u0005u\u0012QI\u0007\u0003\u0003\u007fQA!!\u0011\u0002D\u00059!/Z2pe\u0012\u001c(B\u0001\u001c:\u0013\u0011\t9%a\u0010\u0003-\u0019Kg.\u00197BaBd\u0017nY1uS>t7\u000b^1ukND\u0001\"!\n\u00026\u0001\u0007\u0011q\u0005\u0005\u0007\u0003\u001b\u0002A\u0011A0\u0002\u001dMDw.\u001e7e'\",H\u000fZ8x]\u0002")
public class SamzaYarnAppMasterLifecycle
implements Logging {
    private final int containerMem;
    private final int containerCpu;
    private final SamzaApplicationState samzaAppState;
    private final YarnAppState state;
    private final AMRMClientAsync<AMRMClient.ContainerRequest> amClient;
    private boolean validResourceRequest;
    private String shutdownMessage;
    private SamzaYarnAppMasterService webApp;
    private final String loggerName;
    private final Logger logger;
    private final String startupLoggerName;
    private final Logger startupLogger;
    private volatile byte bitmap$0;

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        SamzaYarnAppMasterLifecycle samzaYarnAppMasterLifecycle = this;
        synchronized (samzaYarnAppMasterLifecycle) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.logger$lzycompute() : this.logger;
    }

    public String startupLoggerName() {
        return this.startupLoggerName;
    }

    private Logger startupLogger$lzycompute() {
        SamzaYarnAppMasterLifecycle samzaYarnAppMasterLifecycle = this;
        synchronized (samzaYarnAppMasterLifecycle) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.startupLogger = Logging.class.startupLogger((Logging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.startupLogger;
        }
    }

    public Logger startupLogger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.startupLogger$lzycompute() : this.startupLogger;
    }

    public void org$apache$samza$util$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void org$apache$samza$util$Logging$_setter_$startupLoggerName_$eq(String x$1) {
        this.startupLoggerName = x$1;
    }

    public void startupLog(Function0<Object> message) {
        Logging.class.startupLog((Logging)this, message);
    }

    public void trace(Function0<Object> message) {
        Logging.class.trace((Logging)this, message);
    }

    public void trace(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, message, e);
    }

    public void debug(Function0<Object> message) {
        Logging.class.debug((Logging)this, message);
    }

    public void debug(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, message, e);
    }

    public void info(Function0<Object> message) {
        Logging.class.info((Logging)this, message);
    }

    public void info(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.info((Logging)this, message, e);
    }

    public void warn(Function0<Object> message) {
        Logging.class.warn((Logging)this, message);
    }

    public void warn(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, message, e);
    }

    public void error(Function0<Object> message) {
        Logging.class.error((Logging)this, message);
    }

    public void error(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.error((Logging)this, message, e);
    }

    public void putMDC(Function0<String> key, Function0<String> value) {
        Logging.class.putMDC((Logging)this, key, value);
    }

    public String getMDC(Function0<String> key) {
        return Logging.class.getMDC((Logging)this, key);
    }

    public void removeMDC(Function0<String> key) {
        Logging.class.removeMDC((Logging)this, key);
    }

    public void clearMDC() {
        Logging.class.clearMDC((Logging)this);
    }

    public boolean validResourceRequest() {
        return this.validResourceRequest;
    }

    public void validResourceRequest_$eq(boolean x$1) {
        this.validResourceRequest = x$1;
    }

    public String shutdownMessage() {
        return this.shutdownMessage;
    }

    public void shutdownMessage_$eq(String x$1) {
        this.shutdownMessage = x$1;
    }

    public SamzaYarnAppMasterService webApp() {
        return this.webApp;
    }

    public void webApp_$eq(SamzaYarnAppMasterService x$1) {
        this.webApp = x$1;
    }

    public void onInit() {
        String host = this.state.nodeHost;
        RegisterApplicationMasterResponse response = this.amClient.registerApplicationMaster(host, this.state.rpcUrl.getPort(), new StringOps(Predef$.MODULE$.augmentString("%s:%d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{host, BoxesRunTime.boxToInteger((int)this.state.trackingUrl.getPort())})));
        Resource maxCapability = response.getMaximumResourceCapability();
        int maxMem = maxCapability.getMemory();
        int maxCpu = maxCapability.getVirtualCores();
        this.info((Function0<Object>)new Serializable(this, maxMem, maxCpu){
            public static final long serialVersionUID = 0L;
            private final int maxMem$1;
            private final int maxCpu$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Got AM register response. The YARN RM supports container requests with max-mem: %s, max-cpu: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.maxMem$1), BoxesRunTime.boxToInteger((int)this.maxCpu$1)}));
            }
            {
                this.maxMem$1 = maxMem$1;
                this.maxCpu$1 = maxCpu$1;
            }
        });
        if (this.containerMem > maxMem || this.containerCpu > maxCpu) {
            this.shutdownMessage_$eq(new StringOps(Predef$.MODULE$.augmentString("The YARN cluster is unable to run your job due to unsatisfiable resource requirements. You asked for mem: %s, and cpu: %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.containerMem), BoxesRunTime.boxToInteger((int)this.containerCpu)})));
            this.error((Function0<Object>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SamzaYarnAppMasterLifecycle $outer;

                public final String apply() {
                    return this.$outer.shutdownMessage();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            this.validResourceRequest_$eq(false);
            this.samzaAppState.status = SamzaApplicationState.SamzaAppStatus.FAILED;
            this.samzaAppState.jobHealthy.set(false);
        }
    }

    public void onReboot() {
        throw new SamzaException("Received a reboot signal from the RM, so throwing an exception to reboot the AM.");
    }

    public void onShutdown(SamzaApplicationState.SamzaAppStatus samzaAppStatus) {
        FinalApplicationStatus yarnStatus = this.getStatus(samzaAppStatus);
        this.info((Function0<Object>)new Serializable(this, samzaAppStatus, yarnStatus){
            public static final long serialVersionUID = 0L;
            private final SamzaApplicationState.SamzaAppStatus samzaAppStatus$1;
            private final FinalApplicationStatus yarnStatus$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Shutting down SamzaAppStatus: ").append((Object)this.samzaAppStatus$1).append((Object)" yarn status: ").append((Object)this.yarnStatus$1).toString();
            }
            {
                this.samzaAppStatus$1 = samzaAppStatus$1;
                this.yarnStatus$1 = yarnStatus$1;
            }
        });
        SamzaApplicationState.SamzaAppStatus samzaAppStatus2 = samzaAppStatus;
        SamzaApplicationState.SamzaAppStatus samzaAppStatus3 = SamzaApplicationState.SamzaAppStatus.UNDEFINED;
        if (!(samzaAppStatus2 != null ? !samzaAppStatus2.equals(samzaAppStatus3) : samzaAppStatus3 != null)) {
            this.info((Function0<Object>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Not unregistering AM from the RM. This will enable RM retries";
                }
            });
        } else {
            this.info((Function0<Object>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Unregistering AM from the RM.";
                }
            });
            this.amClient.unregisterApplicationMaster(yarnStatus, this.shutdownMessage(), null);
            this.info((Function0<Object>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Unregister complete.";
                }
            });
        }
    }

    public FinalApplicationStatus getStatus(SamzaApplicationState.SamzaAppStatus samzaAppStatus) {
        SamzaApplicationState.SamzaAppStatus samzaAppStatus2 = samzaAppStatus;
        SamzaApplicationState.SamzaAppStatus samzaAppStatus3 = SamzaApplicationState.SamzaAppStatus.FAILED;
        if (!(samzaAppStatus2 != null ? !samzaAppStatus2.equals(samzaAppStatus3) : samzaAppStatus3 != null)) {
            return FinalApplicationStatus.FAILED;
        }
        SamzaApplicationState.SamzaAppStatus samzaAppStatus4 = samzaAppStatus;
        SamzaApplicationState.SamzaAppStatus samzaAppStatus5 = SamzaApplicationState.SamzaAppStatus.SUCCEEDED;
        if (!(samzaAppStatus4 != null ? !samzaAppStatus4.equals(samzaAppStatus5) : samzaAppStatus5 != null)) {
            return FinalApplicationStatus.SUCCEEDED;
        }
        return FinalApplicationStatus.UNDEFINED;
    }

    public boolean shouldShutdown() {
        return !this.validResourceRequest();
    }

    public SamzaYarnAppMasterLifecycle(int containerMem, int containerCpu, SamzaApplicationState samzaAppState, YarnAppState state, AMRMClientAsync<AMRMClient.ContainerRequest> amClient) {
        this.containerMem = containerMem;
        this.containerCpu = containerCpu;
        this.samzaAppState = samzaAppState;
        this.state = state;
        this.amClient = amClient;
        Logging.class.$init$((Logging)this);
        this.validResourceRequest = true;
        this.shutdownMessage = null;
        this.webApp = null;
    }
}

