/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.job.yarn;

import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.samza.job.yarn.YarnContainer;

public class YarnAppState {
    public Map<String, YarnContainer> runningYarnContainers = new ConcurrentHashMap<String, YarnContainer>();
    public ConcurrentMap<String, ContainerStatus> failedContainersStatus = new ConcurrentHashMap<String, ContainerStatus>();
    public final int taskId;
    public final ContainerId amContainerId;
    public final String nodeHost;
    public final int nodePort;
    public final int nodeHttpPort;
    public final ApplicationAttemptId appAttemptId;
    public URL coordinatorUrl = null;
    public URL rpcUrl = null;
    public URL trackingUrl = null;

    public YarnAppState(int taskId, ContainerId amContainerId, String nodeHost, int nodePort, int nodeHttpPort) {
        this.taskId = taskId;
        this.amContainerId = amContainerId;
        this.nodeHost = nodeHost;
        this.nodePort = nodePort;
        this.nodeHttpPort = nodeHttpPort;
        this.appAttemptId = amContainerId.getApplicationAttemptId();
    }

    public String toString() {
        return "YarnAppState{, taskId=" + this.taskId + ", amContainerId=" + this.amContainerId + ", nodeHost='" + this.nodeHost + '\'' + ", nodePort=" + this.nodePort + ", nodeHttpPort=" + this.nodeHttpPort + ", appAttemptId=" + this.appAttemptId + ", coordinatorUrl=" + this.coordinatorUrl + ", rpcUrl=" + this.rpcUrl + ", trackingUrl=" + this.trackingUrl + ", runningYarnContainers=" + this.runningYarnContainers + ", failedContainersStatus=" + this.failedContainersStatus + '}';
    }
}

