/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.job.yarn;

import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.samza.job.yarn.YarnContainerUtils$;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.PeriodFormatter;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015b\u0001B\u0001\u0003\u00015\u0011Q\"W1s]\u000e{g\u000e^1j]\u0016\u0014(BA\u0002\u0005\u0003\u0011I\u0018M\u001d8\u000b\u0005\u00151\u0011a\u00016pE*\u0011q\u0001C\u0001\u0006g\u0006l'0\u0019\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001q\u0001CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\r\u0003\u0005\u0016\u0001\t\u0005\t\u0015!\u0003\u0017\u0003%\u0019wN\u001c;bS:,'\u000f\u0005\u0002\u0018?5\t\u0001D\u0003\u0002\u001a5\u00059!/Z2pe\u0012\u001c(BA\u000e\u001d\u0003\r\t\u0007/\u001b\u0006\u0003\u0007uQ!A\b\u0005\u0002\r!\fGm\\8q\u0013\t\u0001\u0003DA\u0005D_:$\u0018-\u001b8fe\")!\u0005\u0001C\u0001G\u00051A(\u001b8jiz\"\"\u0001\n\u0014\u0011\u0005\u0015\u0002Q\"\u0001\u0002\t\u000bU\t\u0003\u0019\u0001\f\t\u000f!\u0002!\u0019!C\u0001S\u0005\u0011\u0011\u000eZ\u000b\u0002UA\u0011qcK\u0005\u0003Ya\u00111bQ8oi\u0006Lg.\u001a:JI\"1a\u0006\u0001Q\u0001\n)\n1!\u001b3!\u0011\u001d\u0001\u0004A1A\u0005\u0002E\naA\\8eK&#W#\u0001\u001a\u0011\u0005]\u0019\u0014B\u0001\u001b\u0019\u0005\u0019qu\u000eZ3JI\"1a\u0007\u0001Q\u0001\nI\nqA\\8eK&#\u0007\u0005C\u00049\u0001\t\u0007I\u0011A\u001d\u0002\u001f9|G-\u001a%uiB\fE\r\u001a:fgN,\u0012A\u000f\t\u0003w\u0001k\u0011\u0001\u0010\u0006\u0003{y\nA\u0001\\1oO*\tq(\u0001\u0003kCZ\f\u0017BA!=\u0005\u0019\u0019FO]5oO\"11\t\u0001Q\u0001\ni\n\u0001C\\8eK\"#H\u000f]!eIJ,7o\u001d\u0011\t\u000f\u0015\u0003!\u0019!C\u0001\r\u0006A!/Z:pkJ\u001cW-F\u0001H!\t9\u0002*\u0003\u0002J1\tA!+Z:pkJ\u001cW\r\u0003\u0004L\u0001\u0001\u0006IaR\u0001\ne\u0016\u001cx.\u001e:dK\u0002Bq!\u0014\u0001C\u0002\u0013\u0005a*\u0001\u0005qe&|'/\u001b;z+\u0005y\u0005CA\fQ\u0013\t\t\u0006D\u0001\u0005Qe&|'/\u001b;z\u0011\u0019\u0019\u0006\u0001)A\u0005\u001f\u0006I\u0001O]5pe&$\u0018\u0010\t\u0005\b+\u0002\u0011\r\u0011\"\u0001W\u00039\u0019wN\u001c;bS:,'\u000fV8lK:,\u0012a\u0016\t\u0003/aK!!\u0017\r\u0003\u000bQ{7.\u001a8\t\rm\u0003\u0001\u0015!\u0003X\u0003=\u0019wN\u001c;bS:,'\u000fV8lK:\u0004\u0003bB/\u0001\u0005\u0004%\tAX\u0001\ngR\f'\u000f\u001e+j[\u0016,\u0012a\u0018\t\u0003\u001f\u0001L!!\u0019\t\u0003\t1{gn\u001a\u0005\u0007G\u0002\u0001\u000b\u0011B0\u0002\u0015M$\u0018M\u001d;US6,\u0007\u0005C\u0003f\u0001\u0011\u0005a-\u0001\u0007ti\u0006\u0014H\u000fV5nKN#(\u000f\u0006\u0002;O\"9\u0001\u000e\u001aI\u0001\u0002\u0004I\u0017a\u00033u\r>\u0014X.\u0019;uKJ\u00042a\u00046m\u0013\tY\u0007C\u0001\u0004PaRLwN\u001c\t\u0003[Rl\u0011A\u001c\u0006\u0003_B\faAZ8s[\u0006$(BA9s\u0003\u0011!\u0018.\\3\u000b\u0005MT\u0011\u0001\u00026pI\u0006L!!\u001e8\u0003#\u0011\u000bG/\u001a+j[\u00164uN]7biR,'\u000fC\u0003x\u0001\u0011\u0005a,\u0001\u0004vaRKW.\u001a\u0005\u0006s\u0002!\tA_\u0001\nkB$\u0016.\\3TiJ$\"AO>\t\u000fqD\b\u0013!a\u0001{\u0006y\u0001/\u001a:j_\u00124uN]7biR,'\u000fE\u0002\u0010Uz\u0004\"!\\@\n\u0007\u0005\u0005aNA\bQKJLw\u000e\u001a$pe6\fG\u000f^3s\u0011%\t)\u0001AI\u0001\n\u0003\t9!\u0001\fti\u0006\u0014H\u000fV5nKN#(\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\tIAK\u0002j\u0003\u0017Y#!!\u0004\u0011\t\u0005=\u0011\u0011D\u0007\u0003\u0003#QA!a\u0005\u0002\u0016\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003/\u0001\u0012AC1o]>$\u0018\r^5p]&!\u00111DA\t\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0003?\u0001\u0011\u0013!C\u0001\u0003C\t1#\u001e9US6,7\u000b\u001e:%I\u00164\u0017-\u001e7uIE*\"!a\t+\u0007u\fY\u0001")
public class YarnContainer {
    private final ContainerId id;
    private final NodeId nodeId;
    private final String nodeHttpAddress;
    private final Resource resource;
    private final Priority priority;
    private final Token containerToken;
    private final long startTime;

    public ContainerId id() {
        return this.id;
    }

    public NodeId nodeId() {
        return this.nodeId;
    }

    public String nodeHttpAddress() {
        return this.nodeHttpAddress;
    }

    public Resource resource() {
        return this.resource;
    }

    public Priority priority() {
        return this.priority;
    }

    public Token containerToken() {
        return this.containerToken;
    }

    public long startTime() {
        return this.startTime;
    }

    public String startTimeStr(Option<DateTimeFormatter> dtFormatter) {
        return ((DateTimeFormatter)dtFormatter.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final DateTimeFormatter apply() {
                return YarnContainerUtils$.MODULE$.dateFormater();
            }
        })).print(this.startTime());
    }

    public Option<DateTimeFormatter> startTimeStr$default$1() {
        return None$.MODULE$;
    }

    public long upTime() {
        return System.currentTimeMillis();
    }

    public String upTimeStr(Option<PeriodFormatter> periodFormatter) {
        return ((PeriodFormatter)periodFormatter.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final PeriodFormatter apply() {
                return YarnContainerUtils$.MODULE$.periodFormater();
            }
        })).print((ReadablePeriod)new Period(this.startTime(), this.upTime()));
    }

    public Option<PeriodFormatter> upTimeStr$default$1() {
        return None$.MODULE$;
    }

    public YarnContainer(Container container) {
        this.id = container.getId();
        this.nodeId = container.getNodeId();
        this.nodeHttpAddress = container.getNodeHttpAddress();
        this.resource = container.getResource();
        this.priority = container.getPriority();
        this.containerToken = container.getContainerToken();
        this.startTime = System.currentTimeMillis();
    }
}

