/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.job.yarn;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.samza.config.Config;
import org.apache.samza.config.JobConfig$;
import org.apache.samza.config.MapConfig;
import org.apache.samza.config.ShellCommandConfig$;
import org.apache.samza.config.YarnConfig;
import org.apache.samza.job.ApplicationStatus;
import org.apache.samza.job.StreamJob;
import org.apache.samza.job.yarn.ClientHelper;
import org.apache.samza.serializers.model.SamzaObjectMapper;
import org.apache.samza.util.Util$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Null$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ua\u0001B\u0001\u0003\u00015\u0011q!W1s]*{'M\u0003\u0002\u0004\t\u0005!\u00110\u0019:o\u0015\t)a!A\u0002k_\nT!a\u0002\u0005\u0002\u000bM\fWN_1\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\r\u0001aB\u0006\t\u0003\u001fQi\u0011\u0001\u0005\u0006\u0003#I\tA\u0001\\1oO*\t1#\u0001\u0003kCZ\f\u0017BA\u000b\u0011\u0005\u0019y%M[3diB\u0011q\u0003G\u0007\u0002\t%\u0011\u0011\u0004\u0002\u0002\n'R\u0014X-Y7K_\nD\u0001b\u0007\u0001\u0003\u0002\u0003\u0006I\u0001H\u0001\u0007G>tg-[4\u0011\u0005uyR\"\u0001\u0010\u000b\u0005m1\u0011B\u0001\u0011\u001f\u0005\u0019\u0019uN\u001c4jO\"A!\u0005\u0001B\u0001B\u0003%1%\u0001\u0007iC\u0012|w\u000e]\"p]\u001aLw\r\u0005\u0002%S5\tQE\u0003\u0002'O\u0005!1m\u001c8g\u0015\tA\u0003\"\u0001\u0004iC\u0012|w\u000e]\u0005\u0003U\u0015\u0012QbQ8oM&<WO]1uS>t\u0007\"\u0002\u0017\u0001\t\u0003i\u0013A\u0002\u001fj]&$h\bF\u0002/aE\u0002\"a\f\u0001\u000e\u0003\tAQaG\u0016A\u0002qAQAI\u0016A\u0002\rBqa\r\u0001C\u0002\u0013\u0005A'\u0001\u0004dY&,g\u000e^\u000b\u0002kA\u0011qFN\u0005\u0003o\t\u0011Ab\u00117jK:$\b*\u001a7qKJDa!\u000f\u0001!\u0002\u0013)\u0014aB2mS\u0016tG\u000f\t\u0005\bw\u0001\u0001\r\u0011\"\u0001=\u0003\u0015\t\u0007\u000f]%e+\u0005i\u0004c\u0001 B\u00076\tqHC\u0001A\u0003\u0015\u00198-\u00197b\u0013\t\u0011uH\u0001\u0004PaRLwN\u001c\t\u0003\t*k\u0011!\u0012\u0006\u0003\r\u001e\u000bqA]3d_J$7O\u0003\u0002I\u0013\u0006\u0019\u0011\r]5\u000b\u0005\r9\u0013BA&F\u00055\t\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8JI\"9Q\n\u0001a\u0001\n\u0003q\u0015!C1qa&#w\fJ3r)\ty%\u000b\u0005\u0002?!&\u0011\u0011k\u0010\u0002\u0005+:LG\u000fC\u0004T\u0019\u0006\u0005\t\u0019A\u001f\u0002\u0007a$\u0013\u0007\u0003\u0004V\u0001\u0001\u0006K!P\u0001\u0007CB\u0004\u0018\n\u001a\u0011\t\u000f]\u0003!\u0019!C\u00011\u0006Q\u00110\u0019:o\u0007>tg-[4\u0016\u0003e\u0003\"!\b.\n\u0005ms\"AC-be:\u001cuN\u001c4jO\"1Q\f\u0001Q\u0001\ne\u000b1\"_1s]\u000e{gNZ5hA!9q\f\u0001b\u0001\n\u0003\u0001\u0017A\u00027pO\u001e,'/F\u0001b!\t\u0011W-D\u0001d\u0015\t!'\"A\u0003tY\u001a$$.\u0003\u0002gG\n1Aj\\4hKJDa\u0001\u001b\u0001!\u0002\u0013\t\u0017a\u00027pO\u001e,'\u000f\t\u0005\u0006U\u0002!\ta[\u0001\u0007gV\u0014W.\u001b;\u0015\u00039BQ!\u001c\u0001\u0005\u00029\f!BY;jY\u0012\fUnQ7e)\u0005y\u0007CA\bq\u0013\t\t\bC\u0001\u0004TiJLgn\u001a\u0005\u0006g\u0002!\t\u0001^\u0001\u000eo\u0006LGOR8s\r&t\u0017n\u001d5\u0015\u0005UD\bCA\fw\u0013\t9HAA\tBaBd\u0017nY1uS>t7\u000b^1ukNDQ!\u001f:A\u0002i\f\u0011\u0002^5nK>,H/T:\u0011\u0005yZ\u0018B\u0001?@\u0005\u0011auN\\4\t\u000by\u0004A\u0011A@\u0002\u001b]\f\u0017\u000e\u001e$peN#\u0018\r^;t)\u0015)\u0018\u0011AA\u0003\u0011\u0019\t\u0019! a\u0001k\u000611\u000f^1ukNDQ!_?A\u0002iDq!!\u0003\u0001\t\u0003\tY!A\u0005hKR\u001cF/\u0019;vgR\tQ\u000f\u0003\u0004\u0002\u0010\u0001!\ta[\u0001\u0005W&dG\u000e\u0003\u0004\u0002\u0014\u0001!I\u0001P\u0001\tO\u0016$\u0018\t\u001d9JI\u0002")
public class YarnJob
implements StreamJob {
    private final Config config;
    private final ClientHelper client;
    private Option<ApplicationId> appId;
    private final YarnConfig yarnConfig;
    private final Logger logger;

    public ClientHelper client() {
        return this.client;
    }

    public Option<ApplicationId> appId() {
        return this.appId;
    }

    public void appId_$eq(Option<ApplicationId> x$1) {
        this.appId = x$1;
    }

    public YarnConfig yarnConfig() {
        return this.yarnConfig;
    }

    public Logger logger() {
        return this.logger;
    }

    public YarnJob submit() {
        try {
            String cmdExec = this.buildAmCmd();
            MapConfig coordinatorSystemConfig = Util$.MODULE$.buildCoordinatorStreamConfig(this.config);
            scala.collection.immutable.Map envMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ShellCommandConfig$.MODULE$.ENV_COORDINATOR_SYSTEM_CONFIG()), (Object)Util$.MODULE$.envVarEscape(SamzaObjectMapper.getObjectMapper().writeValueAsString((Object)coordinatorSystemConfig))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ShellCommandConfig$.MODULE$.ENV_JAVA_OPTS()), (Object)Util$.MODULE$.envVarEscape(this.yarnConfig().getAmOpts()))}));
            String amJavaHome = this.yarnConfig().getAMJavaHome();
            scala.collection.immutable.Map envMapWithJavaHome = amJavaHome == null ? envMap : envMap.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ShellCommandConfig$.MODULE$.ENV_JAVA_HOME()), (Object)amJavaHome));
            this.appId_$eq(this.client().submitApplication(this.config, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringOps(Predef$.MODULE$.augmentString("export SAMZA_LOG_DIR=%s && ln -sfn %s logs && exec %s 1>logs/%s 2>logs/%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"<LOG_DIR>", "<LOG_DIR>", cmdExec, "stdout", "stderr"}))})), (Option<Map<String, String>>)new Some((Object)envMapWithJavaHome), (Option<String>)new Some((Object)new StringOps(Predef$.MODULE$.augmentString("%s_%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JobConfig$.MODULE$.Config2Job(this.config).getName().get(), JobConfig$.MODULE$.Config2Job(this.config).getJobId().getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply() {
                    return this.apply$mcI$sp();
                }

                public int apply$mcI$sp() {
                    return 1;
                }
            })})))));
            return this;
        }
        catch (Throwable throwable) {
            this.client().cleanupStagingDir();
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public String buildAmCmd() {
        void var3_3;
        String fwkPath = this.config.get(JobConfig$.MODULE$.SAMZA_FWK_PATH(), "");
        String fwkVersion = (String)this.config.get((Object)JobConfig$.MODULE$.SAMZA_FWK_VERSION());
        if (fwkVersion == null || fwkVersion.isEmpty()) {
            fwkVersion = "STABLE";
        }
        this.logger().info(new StringOps(Predef$.MODULE$.augmentString("Inside YarnJob: fwk_path is %s, ver is %s use it directly ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fwkPath, fwkVersion})));
        String cmdExec = "./__package/bin/run-jc.sh";
        if (!fwkPath.isEmpty()) {
            cmdExec = new StringBuilder().append((Object)fwkPath).append((Object)"/").append((Object)fwkVersion).append((Object)"/bin/run-jc.sh").toString();
            this.logger().info(new StringBuilder().append((Object)"Using FWK path: ").append((Object)new StringOps(Predef$.MODULE$.augmentString("export SAMZA_LOG_DIR=%s && ln -sfn %s logs && exec %s 1>logs/%s 2>logs/%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"<LOG_DIR>", "<LOG_DIR>", cmdExec, "stdout", "stderr"}))).toString());
        }
        return var3_3;
    }

    public ApplicationStatus waitForFinish(long timeoutMs) {
        long startTimeMs = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTimeMs < timeoutMs) {
            Option option = Option$.MODULE$.apply((Object)this.getStatus());
            if (option instanceof Some) {
                Some some = (Some)option;
                ApplicationStatus s = (ApplicationStatus)some.x();
                if (ApplicationStatus.SuccessfulFinish.equals((Object)s) || ApplicationStatus.UnsuccessfulFinish.equals((Object)s)) {
                    this.client().cleanupStagingDir();
                }
                return s;
            }
            if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                Thread.sleep(1000L);
                continue;
            }
            throw new MatchError((Object)option);
        }
        return ApplicationStatus.Running;
    }

    public ApplicationStatus waitForStatus(ApplicationStatus status2, long timeoutMs) {
        long startTimeMs = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTimeMs < timeoutMs) {
            Option option;
            block7: {
                block6: {
                    BoxedUnit boxedUnit;
                    block5: {
                        option = Option$.MODULE$.apply((Object)this.getStatus());
                        if (!(option instanceof Some)) break block5;
                        Some some = (Some)option;
                        ApplicationStatus s = (ApplicationStatus)some.x();
                        if (status2.equals((Object)s)) {
                            return status2;
                        }
                        boxedUnit = BoxedUnit.UNIT;
                        break block6;
                    }
                    if (!None$.MODULE$.equals(option)) break block7;
                    boxedUnit = null;
                }
                Thread.sleep(1000L);
                continue;
            }
            throw new MatchError((Object)option);
        }
        return ApplicationStatus.Running;
    }

    public ApplicationStatus getStatus() {
        Option<ApplicationId> option;
        block4: {
            ApplicationStatus applicationStatus;
            block3: {
                block2: {
                    option = this.getAppId();
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    ApplicationId appId = (ApplicationId)some.x();
                    this.logger().info(new StringOps(Predef$.MODULE$.augmentString("Getting status for applicationId %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{appId})));
                    applicationStatus = (ApplicationStatus)this.client().status(appId).getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Null$ apply() {
                            return null;
                        }
                    });
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                this.logger().info("Unable to report status because no applicationId could be found.");
                applicationStatus = ApplicationStatus.SuccessfulFinish;
            }
            return applicationStatus;
        }
        throw new MatchError(option);
    }

    public YarnJob kill() {
        Option<ApplicationId> option;
        block8: {
            block7: {
                option = this.getAppId();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    ApplicationId appId = (ApplicationId)some.x();
                    this.logger().info("Killing applicationId {}", new Object[]{appId});
                    this.client().kill(appId);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block7;
                }
                if (!None$.MODULE$.equals(option)) break block8;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return this;
        }
        throw new MatchError(option);
        finally {
            this.client().cleanupStagingDir();
        }
    }

    private Option<ApplicationId> getAppId() {
        Option<ApplicationId> option;
        block7: {
            Option option2;
            block10: {
                None$ none$;
                block6: {
                    None$ none$2;
                    block9: {
                        block8: {
                            Option option3;
                            block5: {
                                option = this.appId();
                                if (!(option instanceof Some)) break block5;
                                none$ = this.appId();
                                break block6;
                            }
                            if (!None$.MODULE$.equals(option)) break block7;
                            option2 = JobConfig$.MODULE$.Config2Job(this.config).getName();
                            if (!(option2 instanceof Some)) break block8;
                            Some some = (Some)option2;
                            String jobName = (String)some.x();
                            String applicationName = new StringOps(Predef$.MODULE$.augmentString("%s_%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{jobName, JobConfig$.MODULE$.Config2Job(this.config).getJobId().getOrElse((Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final int apply() {
                                    return this.apply$mcI$sp();
                                }

                                public int apply$mcI$sp() {
                                    return 1;
                                }
                            })}));
                            this.logger().info(new StringOps(Predef$.MODULE$.augmentString("Fetching status from YARN for application name %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{applicationName})));
                            List<ApplicationId> applicationIds = this.client().getActiveApplicationIds(applicationName);
                            if (applicationIds.nonEmpty()) {
                                this.logger().info(new StringBuilder().append((Object)"Matching active ids: ").append((Object)((List)applicationIds.sorted(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()))).reverse().toString()).toString());
                                option3 = ((List)applicationIds.sorted(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()))).reverse().headOption();
                            } else {
                                List<ApplicationId> pastApplicationIds = this.client().getPreviousApplicationIds(applicationName);
                                option3 = ((List)pastApplicationIds.sorted(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()))).reverse().headOption();
                            }
                            none$2 = option3;
                            break block9;
                        }
                        if (!None$.MODULE$.equals(option2)) break block10;
                        none$2 = None$.MODULE$;
                    }
                    none$ = none$2;
                }
                return none$;
            }
            throw new MatchError((Object)option2);
        }
        throw new MatchError(option);
    }

    public YarnJob(Config config, Configuration hadoopConfig) {
        this.config = config;
        this.client = new ClientHelper(hadoopConfig);
        this.appId = None$.MODULE$;
        this.yarnConfig = new YarnConfig(config);
        this.logger = LoggerFactory.getLogger(this.getClass());
    }
}

