/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.metrics;

import org.apache.servicecomb.foundation.common.CommonThread;
import org.apache.servicecomb.foundation.metrics.Metrics;
import org.apache.servicecomb.foundation.metrics.MetricsConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsThread
extends CommonThread {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetricsThread.class);
    private static final long SECOND_MILLS = 1000L;
    private static long msTick = 0L;

    public MetricsThread() {
        this.setName("metrics");
    }

    public void run() {
        while (this.isRunning()) {
            this.waitOneCycle();
            try {
                Metrics.onCycle();
            }
            catch (Exception e) {
                LOGGER.info(e.getMessage());
            }
        }
    }

    private void waitOneCycle() {
        long msLastCycle = msTick;
        do {
            try {
                MetricsThread.sleep((long)1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while ((msTick += 1000L) - msLastCycle < (long)MetricsConfig.getMsCycle());
    }

    public static long getMsTick() {
        return msTick;
    }
}

