/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.metrics.performance;

import java.util.ArrayList;
import java.util.List;
import org.apache.servicecomb.foundation.metrics.performance.PerfResult;
import org.apache.servicecomb.foundation.metrics.performance.PerfStat;
import org.apache.servicecomb.foundation.metrics.performance.PerfStatData;

public class PerfStatImpl
implements PerfStat {
    private String name;
    private List<PerfStatData> dataList = new ArrayList<PerfStatData>();

    public PerfStatImpl(String name) {
        this.name = name;
    }

    public PerfStatImpl(String name, PerfStatData data) {
        this.name = name;
        this.addPerfStatData(data);
    }

    public void addPerfStatData(PerfStatData data) {
        this.dataList.add(data);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<PerfStatData> getPerfStatDataList() {
        return this.dataList;
    }

    @Override
    public void mergeFrom(PerfStat otherPerfStat) {
        this.name = otherPerfStat.getName();
        List<PerfStatData> otherDataList = otherPerfStat.getPerfStatDataList();
        if (this.dataList.isEmpty()) {
            otherDataList.forEach(otherData -> this.dataList.add(new PerfStatData(otherData.getName())));
        }
        for (int idx = 0; idx < otherDataList.size(); ++idx) {
            this.dataList.get(idx).mergeFrom(otherDataList.get(idx));
        }
    }

    @Override
    public void calc(long msNow, List<PerfResult> perfResultList) {
        for (PerfStatData data : this.dataList) {
            perfResultList.add(data.calc(msNow));
        }
    }

    @Override
    public void calc(PerfStat lastCycle, long msCycle, List<PerfResult> perfResultList) {
        if (lastCycle == null) {
            return;
        }
        List<PerfStatData> lastCycleDataList = lastCycle.getPerfStatDataList();
        for (int idx = 0; idx < this.dataList.size(); ++idx) {
            PerfStatData data = this.dataList.get(idx);
            PerfStatData lastCycleData = lastCycleDataList.get(idx);
            perfResultList.add(data.calc(lastCycleData, msCycle));
        }
    }
}

