/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.metrics.performance;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.servicecomb.foundation.metrics.performance.PerfStat;
import org.apache.servicecomb.foundation.metrics.performance.PerfStatData;
import org.apache.servicecomb.foundation.metrics.performance.PerfStatMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerfStatMonitorMgr {
    private static final Logger LOGGER = LoggerFactory.getLogger(PerfStatMonitorMgr.class);
    private Map<String, PerfStatMonitor> monitorMap = new HashMap<String, PerfStatMonitor>();
    private List<PerfStatMonitor> monitorList = new ArrayList<PerfStatMonitor>();
    private String header = String.format("             call count       msg count        avg tps    avg latency(ms) |%s", PerfStatData.getStrSegmentDef());
    private String statFmt = "%-16d %-16d %-10d %-16.3f %s\n";

    public void registerPerfStat(PerfStat perfStat, int index) {
        String name = perfStat.getName();
        PerfStatMonitor monitor = this.monitorMap.get(name);
        if (monitor == null) {
            monitor = new PerfStatMonitor(name, index);
            this.monitorMap.put(name, monitor);
            this.monitorList.add(monitor);
            this.monitorList.sort(Comparator.comparingInt(PerfStatMonitor::getIndex));
        }
        monitor.addThreadStat(perfStat);
    }

    public void onCycle(long msNow, long msCycle) {
        StringBuilder sb = new StringBuilder();
        sb.append("Cycle stat output:\n" + this.header + "\n");
        for (PerfStatMonitor monitor : this.monitorList) {
            monitor.calcCycle(msNow, msCycle);
            sb.append(" " + monitor.getName() + ":\n");
            monitor.format(sb, this.statFmt);
        }
        LOGGER.info(sb.toString());
    }

    public Map<String, PerfStat> getMonitorPerfStat() {
        return this.monitorList.stream().collect(Collectors.toMap(PerfStatMonitor::getName, PerfStatMonitor::getPerfStat));
    }

    public List<PerfStatMonitor> getMonitorList() {
        return this.monitorList;
    }
}

