/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.provider.pojo;

import javax.inject.Inject;
import org.apache.servicecomb.core.definition.schema.ProducerSchemaFactory;
import org.apache.servicecomb.core.provider.producer.AbstractProducerProvider;
import org.apache.servicecomb.foundation.common.RegisterManager;
import org.apache.servicecomb.foundation.common.utils.BeanUtils;
import org.apache.servicecomb.provider.pojo.InstanceFactory;
import org.apache.servicecomb.provider.pojo.instance.PojoInstanceFactory;
import org.apache.servicecomb.provider.pojo.instance.SpringInstanceFactory;
import org.apache.servicecomb.provider.pojo.schema.PojoProducerMeta;
import org.apache.servicecomb.provider.pojo.schema.PojoProducers;
import org.apache.servicecomb.serviceregistry.RegistryUtils;
import org.apache.servicecomb.serviceregistry.api.registry.Microservice;
import org.springframework.stereotype.Component;

@Component
public class PojoProducerProvider
extends AbstractProducerProvider {
    private RegisterManager<String, InstanceFactory> instanceFactoryMgr = new RegisterManager("pojo instance factory manager");
    @Inject
    private ProducerSchemaFactory producerSchemaFactory;
    @Inject
    private PojoProducers pojoProducers;

    public void registerInstanceFactory(InstanceFactory instanceFactory) {
        this.instanceFactoryMgr.register((Object)instanceFactory.getImplName(), (Object)instanceFactory);
    }

    public PojoProducerProvider() {
        this.registerInstanceFactory(new PojoInstanceFactory());
        this.registerInstanceFactory(new SpringInstanceFactory());
    }

    public void init() throws Exception {
        for (PojoProducerMeta pojoProducerMeta : this.pojoProducers.getProducers()) {
            this.initPojoProducerMeta(pojoProducerMeta);
            Microservice microservice = RegistryUtils.getMicroservice();
            try {
                this.producerSchemaFactory.getOrCreateProducerSchema(microservice.getServiceName(), pojoProducerMeta.getSchemaId(), pojoProducerMeta.getInstanceClass(), pojoProducerMeta.getInstance());
            }
            catch (Throwable e) {
                throw new IllegalArgumentException("create producer schema failed, class=" + pojoProducerMeta.getInstanceClass().getName(), e);
            }
        }
    }

    public String getName() {
        return "pojo";
    }

    private void initPojoProducerMeta(PojoProducerMeta pojoProducerMeta) {
        if (pojoProducerMeta.getInstance() != null) {
            return;
        }
        String[] nameAndValue = this.parseImplementation(pojoProducerMeta.getImplementation());
        InstanceFactory factory = (InstanceFactory)this.instanceFactoryMgr.ensureFindValue((Object)nameAndValue[0]);
        Object instance = factory.create(nameAndValue[1]);
        Class instanceClass = BeanUtils.getImplClassFromBean((Object)instance);
        pojoProducerMeta.setInstance(instance);
        pojoProducerMeta.setInstanceClass(instanceClass);
    }

    private String[] parseImplementation(String implementation) {
        String implName = "pojo";
        String implValue = implementation;
        int idx = implementation.indexOf(58);
        if (idx != -1) {
            implName = implementation.substring(0, idx);
            implValue = implementation.substring(idx + 1);
        }
        return new String[]{implName, implValue};
    }
}

